/*
 * Decompiled with CFR 0.152.
 */
package com.apple.jingle.leghorn.fileformat;

import com.apple.jingle.leghorn.fileformat.ContainerType;

public class ContainerConformanceProfileIdentifier {
    private static final String CONTAINER_WILDCARD = "*";
    private static final String PROFILE_WILDCARD = "*";
    protected String containerUTIName;
    protected String conformanceProfileName;

    public ContainerConformanceProfileIdentifier(String profileString) {
        this.parseString(profileString);
    }

    protected void parseString(String profileString) {
        if (profileString == null) {
            throw new IllegalArgumentException("Unable to parse null profile string");
        }
        try {
            String[] elements = profileString.split(":");
            this.containerUTIName = elements[0];
            this.conformanceProfileName = elements[1];
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Unable to parse profile string: " + profileString);
        }
    }

    public String getContainerUTIName() {
        return this.containerUTIName;
    }

    public String getConformanceProfileName() {
        return this.conformanceProfileName;
    }

    public boolean isWildcardContainer() {
        return this.containerUTIName.equals("*");
    }

    public boolean isWildcardConformance() {
        return this.conformanceProfileName.equals("*");
    }

    public void setContainerConformanceProfile(ContainerType containerType, String conformanceProfileName) {
        this.containerUTIName = containerType == null ? "*" : containerType.getUTITypeName();
        this.conformanceProfileName = conformanceProfileName == null ? "*" : conformanceProfileName;
    }

    public String toString() {
        return this.containerUTIName + ":" + this.conformanceProfileName;
    }
}

