/*
 * Decompiled with CFR 0.152.
 */
package com.apple.jingle.leghorn.epub.verifiers.helpers;

import com.apple.itunes.epubtoolkit.XHTMLSAXHandler;
import java.util.HashSet;
import java.util.Set;
import java.util.regex.Pattern;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class XHTMLVideoAttributeFinderSAXHandler
extends XHTMLSAXHandler {
    private static final Pattern VIDEO_BOOLEAN_ATTRIBUTE_PATTERN = Pattern.compile("autobuffer|controls|autoplay", 2);
    private static final String errorMessage = " = 'false' not allowed.  In HTML5 this attribute defaults to false when not present and true when present.  Remove this attribute.";
    private Set<String> errors = new HashSet<String>();

    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        if (!"video".equalsIgnoreCase(qName)) {
            return;
        }
        for (int i = 0; i < attributes.getLength(); ++i) {
            String attributeName = attributes.getQName(i);
            String attributeValue = attributes.getValue(i);
            if (!VIDEO_BOOLEAN_ATTRIBUTE_PATTERN.matcher(attributeName).matches() || !"false".equalsIgnoreCase(attributeValue)) continue;
            String error = attributeName + errorMessage;
            this.errors.add(error);
        }
    }

    public Set<String> getErrors() {
        return this.errors;
    }
}

