/*
 * Decompiled with CFR 0.152.
 */
package com.apple.jingle.leghorn.epub.verifiers;

import com.apple.itunes.epubtoolkit.EPUBInfo;
import com.apple.itunes.epubtoolkit.EPUBInternalsValidationResult;
import com.apple.itunes.epubtoolkit.EPUBInternalsValidationRule;
import com.apple.jingle.leghorn.epub.beans.EPUBMessage;
import com.apple.jingle.leghorn.epub.beans.EPUBMessageInstance;
import com.apple.jingle.leghorn.epub.beans.EPUBMessageInstances;
import com.apple.jingle.leghorn.epub.beans.ObjectFactory;
import com.apple.jingle.leghorn.fileformat.ContainerType;
import com.apple.jingle.leghorn.fileformat.ValidationListener;
import com.apple.jingle.leghorn.fileformat.Verifier;
import com.apple.jingle.leghorn.fileformat.exceptions.UnknownTypeException;
import com.apple.jingle.leghorn.fileformat.impl.ContainerTypeFactory;
import com.apple.jingle.leghorn.fileformat.impl.ValidationsCollector;
import com.apple.jingle.leghorn.fileformat.impl.VerifierBuilder;
import com.apple.jingle.leghorn.image.ImageDescriptionGenerator;
import com.apple.jingle.leghorn.image.beans.Height;
import com.apple.jingle.leghorn.image.beans.Image;
import com.apple.jingle.leghorn.image.beans.ImageDocument;
import com.apple.jingle.leghorn.image.beans.Width;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.List;

public class ImageSizeCollector
implements EPUBInternalsValidationRule {
    private Verifier verifier;
    private ContainerTypeFactory typeFactory;
    private ArrayList<ImageWrapper> topten = new ArrayList();

    public ImageSizeCollector() {
        try {
            this.verifier = Verifier.getDefaultVerifier();
            this.typeFactory = this.verifier.getContainerTypeFactory();
        }
        catch (VerifierBuilder.UnableToBuildVerifierException e) {
            throw new RuntimeException("Error building verifier for epub describers.", e);
        }
    }

    public boolean shouldValidate(File root, EPUBInfo.EPUBFile epFile) {
        String path;
        if (epFile.isManifestItem() && epFile.getMediaType() != null && epFile.getMediaType().toLowerCase().startsWith("image") && (path = epFile.getPath()) != null) {
            File ff = new File(root, path);
            if (ff.length() < 3000L) {
                return false;
            }
            try {
                ContainerType cType = this.typeFactory.getTypeForFile(ff);
                String utiName = cType.getUTITypeName();
                return "public.jpeg".equals(utiName) || "public.png".equals(utiName) || "public.tiff".equals(utiName) || "public.gif".equals(utiName);
            }
            catch (UnknownTypeException e) {
                return false;
            }
        }
        return false;
    }

    public boolean isFullePub() {
        return false;
    }

    public void validate(File root, EPUBInfo.EPUBFile epFile, EPUBInternalsValidationResult result) {
        if (this.typeFactory != null) {
            File ff = new File(root, epFile.getPath());
            try {
                ImageDocument description;
                ContainerType cType = this.typeFactory.getTypeForFile(ff);
                ValidationsCollector listener = new ValidationsCollector();
                try (BufferedInputStream bis = new BufferedInputStream(new FileInputStream(ff));){
                    description = ImageDescriptionGenerator.generateDescription(bis, cType, (ValidationListener)listener);
                }
                if (description != null) {
                    Image i = description.getImage();
                    if (i != null) {
                        Width w;
                        Height h = i.getHeight();
                        BigInteger height = null;
                        BigInteger width = null;
                        if (h != null) {
                            height = h.getBigIntegerValue();
                        }
                        if ((w = i.getWidth()) != null) {
                            width = w.getBigIntegerValue();
                        }
                        if (height == null || width == null) {
                            return;
                        }
                        BigInteger size = height.multiply(width);
                        this.addToList(new ImageWrapper(size, i, epFile.getPath()));
                    }
                } else {
                    String error = ff.getName() + " unknown error occured while parsing. Image is likely corrupt.";
                    if (listener != null && listener.getValidationErrors().size() > 0) {
                        error = error + ", it has these validation issues: " + listener.getValidationErrors().get(0);
                    }
                    result.getErrors().add(error);
                }
            }
            catch (Exception e) {
                return;
            }
        }
    }

    public List<ImageWrapper> getTopTen() {
        return this.topten;
    }

    private void addToList(ImageWrapper img) {
        if (this.topten.size() < 10 || this.topten.get(9).compareTo(img) < 0) {
            int x = 0;
            while (x < 10) {
                if (x == this.topten.size()) {
                    this.topten.add(img);
                    x = 10;
                    continue;
                }
                if (this.topten.get(x).compareTo(img) < 0) {
                    ImageWrapper swap = this.topten.get(x);
                    this.topten.set(x, img);
                    img = swap;
                }
                ++x;
            }
        }
    }

    public String getMessage() {
        return null;
    }

    public String getType() {
        return null;
    }

    public int getCode() {
        return 1001;
    }

    public Boolean ticketsRequired(EPUBInternalsValidationResult result) {
        return null;
    }

    public EPUBMessage getDescriptionMessage() {
        if (this.topten == null || this.topten.isEmpty()) {
            return null;
        }
        ObjectFactory factory = new ObjectFactory();
        EPUBMessage message = factory.createEPUBMessage();
        EPUBMessageInstances messageTexts = factory.createEPUBMessageInstances();
        message.setMessageCount(new BigInteger("" + this.topten.size()));
        message.setMessageNumber(new BigInteger("" + this.getCode()));
        message.setMessageInstances(messageTexts);
        for (ImageWrapper iw : this.topten) {
            EPUBMessageInstance messageText = factory.createEPUBMessageInstance();
            messageText.setFile(iw.filename);
            messageText.setMessageText(iw.size + " , " + iw.i.getHeight().getStringValue() + " , " + iw.i.getWidth().getStringValue());
            messageTexts.getMessageInstance().add(messageText);
        }
        return message;
    }

    private class ImageWrapper
    implements Comparable<ImageWrapper> {
        private Image i;
        private BigInteger size;
        private String filename;

        public ImageWrapper(BigInteger size, Image i, String filename) {
            this.i = i;
            this.size = size;
            this.filename = filename;
        }

        @Override
        public int compareTo(ImageWrapper o) {
            return this.size.compareTo(o.size);
        }

        public boolean equals(Object obj) {
            if (obj instanceof ImageWrapper) {
                return this.i.equals(((ImageWrapper)obj).i);
            }
            return false;
        }

        public int hashCode() {
            return this.size.hashCode();
        }
    }
}

