/*
 * Decompiled with CFR 0.152.
 */
package com.apple.jingle.leghorn.epub.verifiers;

import com.apple.itunes.epubtoolkit.EPUBException;
import com.apple.itunes.epubtoolkit.cfi.CFI;
import com.apple.itunes.epubtoolkit.model.EPUBModel;
import com.apple.itunes.epubtoolkit.model.OPFManifestItem;
import com.apple.itunes.epubtoolkit.model.SearchIndex;
import com.apple.itunes.epubtoolkit.util.XMLUtilities;
import com.apple.jingle.leghorn.epub.beans.EPUBMessage;
import com.apple.jingle.leghorn.epub.beans.EPUBMessageInstance;
import com.apple.jingle.leghorn.epub.beans.EPUBMessageInstances;
import java.io.File;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.List;
import org.jdom2.Document;
import org.jdom2.Element;

public class IBASearchIndexChecker {
    private static final int termCountError = 2001;
    private static final int termInstanceError = 2002;
    private static final int occurancesError = 2003;
    private static final int refTextTermError = 2004;
    private static final int referenceError = 2005;
    private SearchIndex searchIndex;
    private EPUBModel model;

    public IBASearchIndexChecker(EPUBModel model) throws EPUBException {
        this.searchIndex = new SearchIndex(model);
        this.model = model;
    }

    public List<EPUBMessage> validateSearchIndex() throws EPUBException {
        EPUBMessage referenceValidations;
        EPUBMessage refTextTerm;
        EPUBMessage occurances;
        EPUBMessage termInstaces;
        ArrayList<EPUBMessage> errors = new ArrayList<EPUBMessage>();
        EPUBMessage termCount = this.validateTermCount();
        if (termCount != null) {
            errors.add(termCount);
        }
        if ((termInstaces = this.validateTermInstances()) != null) {
            errors.add(termInstaces);
        }
        if ((occurances = this.validateOccurances()) != null) {
            errors.add(occurances);
        }
        if ((refTextTerm = this.validatedRefTextTermCount()) != null) {
            errors.add(refTextTerm);
        }
        if ((referenceValidations = this.validateReferences()) != null) {
            errors.add(referenceValidations);
        }
        return errors;
    }

    private EPUBMessage validateReferences() throws EPUBException {
        List instances = this.searchIndex.getReftextTerms();
        if (null == instances) {
            return null;
        }
        ArrayList<String> errors = new ArrayList<String>();
        for (Element instance : instances) {
            String ref = instance.getAttributeValue("fi");
            if (ref == null || ref.isEmpty() || !CFI.isCFI((String)ref)) continue;
            try {
                CFI cfi = new CFI(ref);
                OPFManifestItem item = this.model.getOPF().getManifestItem(cfi);
                if (item != null) {
                    File file = this.model.getManifestItemFile(item);
                    if (file != null && file.exists()) {
                        CFI targetCfi = cfi.getRedirectTarget();
                        if (targetCfi != null) {
                            Document contentDoc = XMLUtilities.createDocument((File)file);
                            Element targetElement = (Element)targetCfi.resolveToElement((Object)contentDoc.getRootElement());
                            if (targetElement != null) continue;
                        }
                        errors.add("Cannot resolve CFI (no redirect target): " + cfi);
                        continue;
                    }
                    errors.add("Content file does not exist for " + item.getHref());
                    continue;
                }
                errors.add("Cannot find OPF manifest item for " + cfi);
            }
            catch (Exception e) {
                errors.add(e.getMessage());
            }
        }
        if (!errors.isEmpty()) {
            EPUBMessage message = this.createMultiEPUBMessage(2005, errors);
            return message;
        }
        return null;
    }

    private EPUBMessage validatedRefTextTermCount() {
        List instances = this.searchIndex.getReftextTerms();
        if (null == instances || instances.isEmpty()) {
            return this.createEPUBMessage(2004, "Search index ref text does not have any term elements");
        }
        return null;
    }

    private EPUBMessage validateOccurances() {
        List instances = this.searchIndex.getInstances();
        if (null == instances) {
            return null;
        }
        ArrayList<String> errors = new ArrayList<String>();
        for (Element instance : instances) {
            List os;
            String sr = instance.getAttributeValue("sr");
            if (sr == null) {
                sr = "";
            }
            if (!(os = instance.getChildren("o")).isEmpty()) continue;
            errors.add("instance '" + sr + "' does not have any occurances");
        }
        if (!errors.isEmpty()) {
            EPUBMessage message = this.createMultiEPUBMessage(2003, errors);
            return message;
        }
        return null;
    }

    private EPUBMessage validateTermInstances() {
        List termInstances = this.searchIndex.getTermElements();
        if (null == termInstances) {
            return null;
        }
        ArrayList<String> instances = new ArrayList<String>();
        for (Element term : termInstances) {
            String sr;
            Element i;
            String s = term.getAttributeValue("s");
            if (s == null || (i = term.getChild("i")) == null || s.equals(sr = i.getAttributeValue("sr"))) continue;
            instances.add("instance attribute '" + sr + "' does not match term '" + s + "'");
        }
        if (!instances.isEmpty()) {
            EPUBMessage message = this.createMultiEPUBMessage(2002, instances);
            return message;
        }
        return null;
    }

    private EPUBMessage validateTermCount() {
        List terms = this.searchIndex.getTermStems();
        int count = 0;
        if (terms != null) {
            for (Element stem : terms) {
                List ts = stem.getChildren("t");
                if (!ts.isEmpty()) continue;
                ++count;
            }
        }
        if (count > 0) {
            EPUBMessage message = this.createEPUBMessage(2001, "Search index term stem does not have any term elements");
            if (count > 1) {
                message.setMessageCount(new BigInteger("" + count));
            }
            return message;
        }
        return null;
    }

    private EPUBMessage createEPUBMessage(int messageId, String text) {
        EPUBMessage message = new EPUBMessage();
        message.setMessageNumber(new BigInteger("" + messageId));
        EPUBMessageInstances instances = new EPUBMessageInstances();
        EPUBMessageInstance instance = new EPUBMessageInstance();
        instance.setFile(this.searchIndex.getPath());
        instance.setMessageText(text);
        instances.getMessageInstance().add(instance);
        message.setMessageInstances(instances);
        return message;
    }

    private EPUBMessage createMultiEPUBMessage(int messageId, List<String> texts) {
        EPUBMessage message = new EPUBMessage();
        EPUBMessageInstances instances = new EPUBMessageInstances();
        message.setMessageInstances(instances);
        message.setMessageNumber(new BigInteger("" + messageId));
        List<EPUBMessageInstance> messageInstances = instances.getMessageInstance();
        if (texts.size() > 5) {
            message.setMessageCount(new BigInteger("" + texts.size()));
            EPUBMessageInstance instance = new EPUBMessageInstance();
            instance.setFile(this.searchIndex.getPath());
            instance.setMessageText(texts.get(0));
            messageInstances.add(instance);
        } else {
            for (String text : texts) {
                EPUBMessageInstance instance = new EPUBMessageInstance();
                instance.setFile(this.searchIndex.getPath());
                instance.setMessageText(text);
                messageInstances.add(instance);
            }
        }
        return message;
    }
}

