/*
 * Decompiled with CFR 0.152.
 */
package com.apple.jingle.leghorn.epub.verifiers;

import com.apple.itunes.epubtoolkit.EPUBInfo;
import com.apple.itunes.epubtoolkit.EPUBInternalsValidationResult;
import com.apple.itunes.epubtoolkit.EPUBInternalsValidationRule;
import com.apple.itunes.epubtoolkit.util.DocumentInputSource;
import com.apple.jingle.leghorn.epub.beans.EPUBMessage;
import com.apple.jingle.leghorn.epub.beans.EPUBMessageInstance;
import com.apple.jingle.leghorn.epub.beans.EPUBMessageInstances;
import com.apple.jingle.leghorn.epub.beans.ObjectFactory;
import com.apple.jingle.leghorn.epub.verifiers.helpers.XHTMLVideoAttributeFinderSAXHandler;
import java.io.File;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.xml.parsers.SAXParser;
import org.xml.sax.InputSource;
import org.xml.sax.helpers.DefaultHandler;

public class BooleanHTML5AttributeChecker
implements EPUBInternalsValidationRule {
    private List<String> errors = new ArrayList<String>();
    private List<String> files = new ArrayList<String>();
    private static final int maxErrors = 10;

    public boolean shouldValidate(File root, EPUBInfo.EPUBFile file) {
        return file.isXml() && file.isSpineItem();
    }

    public boolean isFullePub() {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void validate(File root, EPUBInfo.EPUBFile file, EPUBInternalsValidationResult result) {
        SAXParser parser;
        File ff = new File(root, file.getPath());
        XHTMLVideoAttributeFinderSAXHandler handler = new XHTMLVideoAttributeFinderSAXHandler();
        try {
            parser = handler.createParser();
        }
        catch (Exception e) {
            result.getErrors().add("Internal error while trying to parse " + file.getPath());
            return;
        }
        try {
            DocumentInputSource inputSource = new DocumentInputSource(ff);
            try {
                parser.parse((InputSource)inputSource, (DefaultHandler)((Object)handler));
            }
            finally {
                if (inputSource != null) {
                    inputSource.cleanup();
                }
            }
        }
        catch (Exception e) {
            result.getErrors().add("Unable to parse: " + file.getPath());
            return;
        }
        for (String error : handler.getErrors()) {
            this.files.add(file.getPath());
            this.errors.add(file.getPath() + ": " + error);
        }
    }

    public String getMessage() {
        return null;
    }

    public String getType() {
        return null;
    }

    public int getCode() {
        return 1002;
    }

    public Boolean ticketsRequired(EPUBInternalsValidationResult result) {
        return null;
    }

    public EPUBMessage getDescriptionMessage() {
        if (this.errors.isEmpty()) {
            return null;
        }
        ObjectFactory factory = new ObjectFactory();
        EPUBMessage message = factory.createEPUBMessage();
        EPUBMessageInstances messageTexts = factory.createEPUBMessageInstances();
        message.setMessageCount(new BigInteger("" + this.errors.size()));
        message.setMessageNumber(new BigInteger("" + this.getCode()));
        message.setMessageInstances(messageTexts);
        Iterator<String> errorIt = this.errors.iterator();
        if (this.errors.size() > 10) {
            EPUBMessageInstance messageText = factory.createEPUBMessageInstance();
            messageText.setMessageText(errorIt.next());
            messageTexts.getMessageInstance().add(messageText);
        } else {
            while (errorIt.hasNext()) {
                EPUBMessageInstance messageText = factory.createEPUBMessageInstance();
                messageText.setMessageText(errorIt.next());
                messageTexts.getMessageInstance().add(messageText);
            }
        }
        return message;
    }
}

