/*
 * Decompiled with CFR 0.152.
 */
package com.apple.jingle.leghorn.epub;

import com.apple.its.epubcheck.EpubCheckRunner;
import com.apple.its.epubcheck.Report;
import com.apple.itunes.epubtoolkit.EPUBException;
import com.apple.itunes.epubtoolkit.EPUBInfo;
import com.apple.itunes.epubtoolkit.EPUBInfoError;
import com.apple.itunes.epubtoolkit.EPUBInfoErrorEnum;
import com.apple.itunes.epubtoolkit.EPUBInfoExtractor;
import com.apple.itunes.epubtoolkit.EPUBInternalsValidationRule;
import com.apple.itunes.epubtoolkit.EPUBInternalsValidator;
import com.apple.itunes.epubtoolkit.model.EPUBModel;
import com.apple.itunes.epubtoolkit.util.FileUtilities;
import com.apple.jingle.leghorn.Configuration;
import com.apple.jingle.leghorn.epub.EPUBCheckAlertCollector;
import com.apple.jingle.leghorn.epub.beans.EPUBDescription;
import com.apple.jingle.leghorn.epub.beans.EPUBMessage;
import com.apple.jingle.leghorn.epub.beans.EPUBMessageInstance;
import com.apple.jingle.leghorn.epub.beans.EPUBMessageInstances;
import com.apple.jingle.leghorn.epub.beans.EPUBMessages;
import com.apple.jingle.leghorn.epub.beans.ObjectFactory;
import com.apple.jingle.leghorn.epub.verifiers.BooleanHTML5AttributeChecker;
import com.apple.jingle.leghorn.epub.verifiers.IBASearchIndexChecker;
import com.apple.jingle.leghorn.epub.verifiers.ImageSizeCollector;
import com.apple.jingle.leghorn.fileformat.ContainerDescription;
import com.apple.jingle.leghorn.fileformat.ContainerType;
import com.apple.jingle.leghorn.fileformat.exceptions.DescriptionException;
import com.apple.jingle.leghorn.fileformat.impl.ContainerContainerDescriberRunner;
import com.apple.jingle.leghorn.fileformat.impl.ContainerTypeImpl;
import com.apple.jingle.leghorn.fileformat.impl.SeekableDataInputContainerDescriberBase;
import com.apple.jingle.leghorn.fileformat.impl.SimpleContainerDescription;
import com.apple.jingle.media.foundation.io.FileSeekableDataInput;
import com.apple.jingle.media.foundation.io.SeekableDataInput;
import com.apple.jingle.media.foundation.io.SeekableInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigInteger;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public class EPUBDescriber
extends SeekableDataInputContainerDescriberBase<Node> {
    private static final String CONTAINER_NAME = "EPUB";
    private static final String UTI = "org.idpf.epub-container";
    private static final String MIME_TYPE = "application/epub+zip";
    private static final String[] REPLACE_TEXT_IN_DESCRIBER_MESSAGES = new String[]{"<!\\[CDATA\\[", "**CDATA**", "\\]\\]>", "**"};
    public static final BigInteger EPUB_MESSAGE_UNKNOWN = BigInteger.valueOf(9000L);
    public static final BigInteger EPUB_MESSAGE_INVALID_XML_CHARS = BigInteger.valueOf(9001L);
    public static final BigInteger EPUB_MESSAGE_COVER_ONLY_LINEAR_SPINE_ITEM = BigInteger.valueOf(9002L);
    public static final BigInteger EPUB_INFO_NCX_NOT_NCX_DOCUMENT = BigInteger.valueOf(9003L);
    public static final BigInteger EPUB_INFO_NO_ANCHOR_TAG_FOR_DATA_ANCHOR_REF = BigInteger.valueOf(9004L);
    public static final BigInteger EPUB_INFO_NO_OBJECT_CHILD_WITH_ANCHORED_GUTTER = BigInteger.valueOf(9005L);
    public static final BigInteger EPUB_INFO_CANNOT_CREATE_DOC_FOR_NCX_EXTENSIONS = BigInteger.valueOf(9006L);
    public static final BigInteger EPUB_INFO_NCX_EXTENSIONS_INVALID_NAV_POINT_ENTRY = BigInteger.valueOf(9007L);
    public static final BigInteger EPUB_INFO_NO_NCX_EXTENSIONS_DOCUMENT_FILE = BigInteger.valueOf(9008L);
    public static final BigInteger EPUB_INFO_NO_NCX_EXTENSIONS_DOCUMENT_SPECIFIED = BigInteger.valueOf(9009L);
    public static final BigInteger EPUB_INFO_NO_NCX_EXTENSION_FOUND_FOR_NAVPOINT = BigInteger.valueOf(9010L);
    public static final BigInteger EPUB_MESSAGE_JDOM_EXCEPTION_IN_PARSING_XML = BigInteger.valueOf(9014L);
    public static final BigInteger EPUB_MESSAGE_IO_EXCEPTION_IN_PARSING_XML = BigInteger.valueOf(9015L);
    public static final BigInteger EPUB_MESSAGE_ILLEGAL_RUNTIME_EXCEPTION_IN_PARSING_XML = BigInteger.valueOf(9016L);
    public static final BigInteger EPUB_MESSAGE_MANIFESTED_DIRECTORY_FOUND = BigInteger.valueOf(9017L);
    public static final BigInteger EPUB_MESSAGE_REFERENCED_FILE_NOT_FOUND = BigInteger.valueOf(9018L);
    private String schemaName;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    @Override
    public ContainerDescription<Node> describe(SeekableDataInput sdi, ContainerType type) throws IOException, DescriptionException {
        factory = new ObjectFactory();
        messages = factory.createEPUBMessages();
        epubtoolkitDescription = factory.createEPUBToolkitDescription();
        epubtoolkitDescription.setEpubMessages(messages);
        fsdi = null;
        epubcheckDescription = null;
        sdi.seek(0L);
        sis = new SeekableInputStream(sdi);
        if (sdi instanceof FileSeekableDataInput) {
            fsdi = (FileSeekableDataInput)sdi;
            fsdi.getFilePath();
            extractor = new EPUBInfoExtractor(new File(fsdi.getFilePath()));
        } else {
            extractor = new EPUBInfoExtractor((InputStream)sis);
        }
        fileCount = 0;
        tempDir = null;
        try {
            tempDir = FileUtilities.createTempDirectory((String)(System.currentTimeMillis() + "."), (String)"unpacked");
            model = extractor.getModel(tempDir);
            info = extractor.extract(model);
            epubMessage = this.checkForCoverOnlyLinearSpineItem(model);
            if (epubMessage != null) {
                messages.getMessage().add(epubMessage);
            }
            mimeType = info.getMimeType();
            epubtoolkitDescription.setMimeType(mimeType);
            rootTagCount = info.getRootTagCount();
            epubtoolkitDescription.setRootFileTagCount(BigInteger.valueOf(rootTagCount));
            hasAllManifestItems = info.hasAllManifestItems();
            epubtoolkitDescription.setAllManifestDocumentsFound(hasAllManifestItems);
            hasAllSpineItems = info.hasAllSpineItems();
            epubtoolkitDescription.setAllSpineDocumentsFound(hasAllSpineItems);
            hasRightsXml = info.isSignaturesXmlPresent();
            epubtoolkitDescription.setHasRightsXml(hasRightsXml);
            hasEncryptionXml = info.isEncryptionXmlPresent();
            epubtoolkitDescription.setHasEncryptionXml(hasEncryptionXml);
            encryptionXmlContents = info.getEncryptionXmlContents();
            if (encryptionXmlContents != null) {
                epubtoolkitDescription.setEncryptionXml(encryptionXmlContents);
            }
            opfContents = info.getOpfContents();
            epubtoolkitDescription.setOpfXml(opfContents);
            ncxContents = info.getNCXNavContents();
            epubtoolkitDescription.setNcxXml(ncxContents);
            xhtmlNavContents = info.getXHTMLNavContents();
            epubtoolkitDescription.setXhtmlNav(xhtmlNavContents);
            fileList = factory.createEPUBToolkitDescriptionFileList();
            epubtoolkitDescription.setFiles(fileList);
            epubFiles = info.getFiles();
            fileCount = epubFiles.size();
            for (EPUBInfo.EPUBFile epubFile : epubFiles) {
                fileItem = factory.createEPUBToolkitDescriptionFileItem();
                fileList.getFile().add(fileItem);
                path = epubFile.getPath();
                fileItem.setFile(path);
                isManifestItem = epubFile.isManifestItem();
                fileItem.setManifested(isManifestItem);
                isPresent = epubFile.isPresent();
                fileItem.setPresent(isPresent);
                isXml = epubFile.isXml();
                fileItem.setXml(isXml);
                namespace = epubFile.getNamespace();
                fileItem.setNamespce(namespace);
                doctypePublicId = epubFile.getDocTypePublicId();
                fileItem.setPublicId(doctypePublicId);
                ftyp = epubFile.getFtyp();
                fileItem.setFtyp(ftyp);
                id = epubFile.getManifestId();
                fileItem.setManifestId(id);
                properties = epubFile.fileProperties();
                if (properties == null) continue;
                props = "";
                for (EPUBInfo.FileProperties property : properties) {
                    props = props + property.getValue() + " ";
                }
                fileItem.setProperties(props);
            }
            adoMap = info.getAppleDisplayOptions();
            if (adoMap != null && !adoMap.isEmpty()) {
                ado = factory.createAppleDisplayOptions();
                for (String platform : adoMap.keySet()) {
                    platformWrap = factory.createAppleDisplayOptionsPlatform();
                    platformWrap.setName(platform);
                    platformMap = (Map)adoMap.get(platform);
                    for (String key : platformMap.keySet()) {
                        platformOptionWrap = factory.createAppleDisplayOptionsPlatformOption();
                        platformOptionWrap.setName(key);
                        platformOptionWrap.setValue((String)platformMap.get(key));
                        platformWrap.getOption().add(platformOptionWrap);
                    }
                    ado.getPlatform().add(platformWrap);
                }
                epubtoolkitDescription.setAppleDisplayOptions(ado);
            }
            if ((printablesMap = info.getApplePrintables()) != null && !printablesMap.isEmpty()) {
                printables = factory.createApplePrintables();
                for (String idref : printablesMap.keySet()) {
                    printable = factory.createApplePrintable();
                    printable.setIdref(idref);
                    printable.setPrintable((Boolean)printablesMap.get(idref));
                    printables.getApplePrintable().add(printable);
                }
                epubtoolkitDescription.setApplePrintables(printables);
            }
            this.runAdditionalChecks(model, info, tempDir, messages);
            epubtoolkitDescription.setEpubMessages(messages);
            epubInfoErrorList = info.getEPUBInfoErrorList();
            for (EPUBInfoError error : epubInfoErrorList) {
                message = this.convertToEPUBMessage(error);
                messages.getMessage().add(message);
            }
            ** if (tempDir == null) goto lbl-1000
        }
        catch (EPUBException e) {
            try {
                if (e.getErrorCode() == 1) {
                    message = new EPUBMessage();
                    message.setMessageCount(BigInteger.ONE);
                    message.setMessageNumber(EPUBDescriber.EPUB_MESSAGE_INVALID_XML_CHARS);
                    instances = new EPUBMessageInstances();
                    message.setMessageInstances(instances);
                    messages.getMessage().add(message);
                    instance = new EPUBMessageInstance();
                    instance.setFile(e.getFileName());
                    instance.setMessageText(e.getMessage());
                    instances.getMessageInstance().add(instance);
                } else {
                    epubtoolkitDescription.setInternalError(e.getMessage());
                }
                ** if (tempDir == null) goto lbl-1000
            }
            catch (Throwable var42_53) {
                if (tempDir != null) {
                    FileUtilities.deleteRecursively(tempDir);
                }
                throw var42_53;
            }
lbl-1000:
            // 1 sources

            {
                FileUtilities.deleteRecursively((File)tempDir);
            }
lbl-1000:
            // 2 sources

            {
            }
        }
lbl-1000:
        // 1 sources

        {
            FileUtilities.deleteRecursively((File)tempDir);
        }
lbl-1000:
        // 2 sources

        {
        }
        try {
            describeLargeFiles = System.getProperty("com.apple.jingle.importer.publication.epubcheckLargeAssets");
            fileCountMaxProp = System.getProperty("com.apple.jingle.importer.publication.epubcheckLargeAssets.fileCount");
            fileCountMax = 60000;
            if (fileCountMaxProp != null) {
                fileCountMax = Integer.parseInt(fileCountMaxProp);
            }
            if (fileCount < fileCountMax || "true".equals(describeLargeFiles)) {
                if (epubcheckDescription == null) {
                    epubcheckDescription = factory.createEPUBCheckDescription();
                }
                collector = new EPUBCheckAlertCollector(factory, epubcheckDescription);
                epubcheck = null;
                if (fsdi != null) {
                    epubcheck = new EpubCheckRunner(new File(fsdi.getFilePath()), (Report)collector);
                } else {
                    sdi.seek(0L);
                    epubcheck = new EpubCheckRunner((InputStream)sis, (Report)collector, ".epub");
                }
                epubcheck.validate();
            }
        }
        catch (Exception e) {
            buf = new StringBuilder(e.getMessage());
            cause = e.getCause();
            if (cause != null) {
                buf.append(" (caused by: ").append(cause.getMessage()).append(')');
            }
            epubcheckDescription.setInternalError(buf.toString());
        }
        description = factory.createEPUBDescription();
        description.setEpubcheck(epubcheckDescription);
        description.setEpubtoolkit(epubtoolkitDescription);
        return this.createContainerDescription(factory, description);
    }

    private EPUBMessage convertToEPUBMessage(EPUBInfoError error) {
        EPUBMessage message = new EPUBMessage();
        message.setMessageCount(BigInteger.ONE);
        if (error.getErrorType().equals((Object)EPUBInfoErrorEnum.NCX_NOT_NCX_DOCUMENT)) {
            message.setMessageNumber(EPUB_INFO_NCX_NOT_NCX_DOCUMENT);
        } else if (error.getErrorType().equals((Object)EPUBInfoErrorEnum.NO_ANCHOR_TAG_FOR_DATA_ANCHOR_REF)) {
            message.setMessageNumber(EPUB_INFO_NO_ANCHOR_TAG_FOR_DATA_ANCHOR_REF);
        } else if (error.getErrorType().equals((Object)EPUBInfoErrorEnum.NO_OBJECT_CHILD_WITH_ANCHORED_GUTTER)) {
            message.setMessageNumber(EPUB_INFO_NO_OBJECT_CHILD_WITH_ANCHORED_GUTTER);
        } else if (error.getErrorType().equals((Object)EPUBInfoErrorEnum.CANNOT_CREATE_DOC_FOR_NCX_EXTENSIONS)) {
            message.setMessageNumber(EPUB_INFO_CANNOT_CREATE_DOC_FOR_NCX_EXTENSIONS);
        } else if (error.getErrorType().equals((Object)EPUBInfoErrorEnum.NCX_EXTENSIONS_INVALID_NAV_POINT_ENTRY)) {
            message.setMessageNumber(EPUB_INFO_NCX_EXTENSIONS_INVALID_NAV_POINT_ENTRY);
        } else if (error.getErrorType().equals((Object)EPUBInfoErrorEnum.NO_NCX_EXTENSIONS_DOCUMENT_FILE)) {
            message.setMessageNumber(EPUB_INFO_NO_NCX_EXTENSIONS_DOCUMENT_FILE);
        } else if (error.getErrorType().equals((Object)EPUBInfoErrorEnum.NO_NCX_EXTENSIONS_DOCUMENT_SPECIFIED)) {
            message.setMessageNumber(EPUB_INFO_NO_NCX_EXTENSIONS_DOCUMENT_SPECIFIED);
        } else if (error.getErrorType().equals((Object)EPUBInfoErrorEnum.NO_NCX_EXTENSION_FOUND_FOR_NAVPOINT)) {
            message.setMessageNumber(EPUB_INFO_NO_NCX_EXTENSION_FOUND_FOR_NAVPOINT);
        } else if (error.getErrorType().equals((Object)EPUBInfoErrorEnum.JDOM_EXCEPTION_IN_PARSING_XML)) {
            message.setMessageNumber(EPUB_MESSAGE_JDOM_EXCEPTION_IN_PARSING_XML);
        } else if (error.getErrorType().equals((Object)EPUBInfoErrorEnum.IO_EXCEPTION_IN_PARSING_XML)) {
            message.setMessageNumber(EPUB_MESSAGE_IO_EXCEPTION_IN_PARSING_XML);
        } else if (error.getErrorType().equals((Object)EPUBInfoErrorEnum.ILLEGAL_RUNTIME_EXCEPTION_IN_PARSING_XML)) {
            message.setMessageNumber(EPUB_MESSAGE_ILLEGAL_RUNTIME_EXCEPTION_IN_PARSING_XML);
        } else if (error.getErrorType().equals((Object)EPUBInfoErrorEnum.MANIFESTED_DIRECTORY_FOUND)) {
            message.setMessageNumber(EPUB_MESSAGE_MANIFESTED_DIRECTORY_FOUND);
        } else if (error.getErrorType().equals((Object)EPUBInfoErrorEnum.REFERENCED_FILE_NOT_FOUND)) {
            message.setMessageNumber(EPUB_MESSAGE_REFERENCED_FILE_NOT_FOUND);
        } else {
            message.setMessageNumber(EPUB_MESSAGE_UNKNOWN);
        }
        EPUBMessageInstances instances = new EPUBMessageInstances();
        message.setMessageInstances(instances);
        EPUBMessageInstance instance = new EPUBMessageInstance();
        instance.setFile(error.getErrorFileName());
        instance.setMessageText(this.replaceDangerousSubstrings(error.getErrorMessage()));
        instances.getMessageInstance().add(instance);
        return message;
    }

    private String replaceDangerousSubstrings(String errorMessage) {
        if (errorMessage == null) {
            return null;
        }
        int length = REPLACE_TEXT_IN_DESCRIBER_MESSAGES.length;
        for (int i = 0; i < length; i += 2) {
            errorMessage = errorMessage.replaceAll(REPLACE_TEXT_IN_DESCRIBER_MESSAGES[i], REPLACE_TEXT_IN_DESCRIBER_MESSAGES[i + 1]);
        }
        return errorMessage;
    }

    private EPUBMessage checkForCoverOnlyLinearSpineItem(EPUBModel model) throws EPUBException {
        if (model.isCoverOnlyLinearSpineItem()) {
            EPUBMessage message = new EPUBMessage();
            message.setMessageCount(BigInteger.ONE);
            message.setMessageNumber(EPUB_MESSAGE_COVER_ONLY_LINEAR_SPINE_ITEM);
            EPUBMessageInstances instances = new EPUBMessageInstances();
            message.setMessageInstances(instances);
            EPUBMessageInstance instance = new EPUBMessageInstance();
            instance.setFile(null);
            instance.setMessageText("Cover only spine item that is linear");
            instances.getMessageInstance().add(instance);
            return message;
        }
        return null;
    }

    private EPUBMessages runAdditionalChecks(EPUBModel model, EPUBInfo info, File tempDir, EPUBMessages messages) throws EPUBException {
        EPUBInternalsValidator validator = new EPUBInternalsValidator(info, tempDir);
        ImageSizeCollector isc = new ImageSizeCollector();
        BooleanHTML5AttributeChecker bhac = new BooleanHTML5AttributeChecker();
        if (info.iBooksAuthorVersion() != null) {
            validator.addRule((EPUBInternalsValidationRule)bhac);
        } else {
            validator.addRule((EPUBInternalsValidationRule)isc);
        }
        validator.execute();
        EPUBMessage message = isc.getDescriptionMessage();
        if (message != null) {
            messages.getMessage().add(message);
        }
        if ((message = bhac.getDescriptionMessage()) != null) {
            messages.getMessage().add(message);
        }
        if (info.iBooksAuthorVersion() != null) {
            IBASearchIndexChecker sic = new IBASearchIndexChecker(model);
            List<EPUBMessage> searchIndexMessages = sic.validateSearchIndex();
            messages.getMessage().addAll(searchIndexMessages);
        }
        if (messages.getMessage().isEmpty()) {
            return null;
        }
        return messages;
    }

    private ContainerDescription<Node> createContainerDescription(ObjectFactory factory, EPUBDescription description) throws DescriptionException {
        Document document;
        try {
            document = this.createDocument(description, factory);
        }
        catch (JAXBException e) {
            throw new DescriptionException(e);
        }
        return this.createContainerDescription(document);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Document createDocument(EPUBDescription description, ObjectFactory factory) throws JAXBException {
        ClassLoader jaxbClassLoader;
        ClassLoader oldClassLoader = Thread.currentThread().getContextClassLoader();
        ClassLoader classLoader = jaxbClassLoader = JAXBContext.class.getClassLoader() == null ? EPUBDescription.class.getClassLoader() : JAXBContext.class.getClassLoader();
        if (jaxbClassLoader != null) {
            Thread.currentThread().setContextClassLoader(jaxbClassLoader);
        }
        try {
            ClassLoader cl = ObjectFactory.class.getClassLoader();
            JAXBContext jc = JAXBContext.newInstance((String)EPUBDescription.class.getPackage().getName(), (ClassLoader)cl);
            Marshaller m = jc.createMarshaller();
            JAXBElement<EPUBDescription> jd = factory.createEpubDescription(description);
            Document document = this.createDocument(m, jd);
            Thread.currentThread().setContextClassLoader(oldClassLoader);
            Document document2 = document;
            return document2;
        }
        finally {
            Thread.currentThread().setContextClassLoader(oldClassLoader);
        }
    }

    private Document createDocument(Marshaller m, JAXBElement<EPUBDescription> jd) {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setNamespaceAware(true);
        try {
            DocumentBuilder builder = factory.newDocumentBuilder();
            Document doc = builder.newDocument();
            m.marshal(jd, (Node)doc);
            return doc;
        }
        catch (Exception e) {
            throw new RuntimeException("Unable to create document builder.", e);
        }
    }

    private ContainerDescription<Node> createContainerDescription(Document document) {
        ContainerTypeImpl containerType = this.createContainerType();
        SimpleContainerDescription result = new SimpleContainerDescription();
        result.setHasMultipleStreams(false);
        result.setStreamIdentifiers(Collections.emptyList());
        result.setType(containerType);
        result.setDescriptionDocument(document);
        return result;
    }

    private ContainerTypeImpl createContainerType() {
        ContainerTypeImpl containerType = new ContainerTypeImpl();
        containerType.setCanHaveMultipleStreams(Boolean.FALSE.toString());
        containerType.setContainerDescriber(this);
        containerType.setContainerVerifier(null);
        containerType.setMatcher(null);
        containerType.setMIMETypeName(MIME_TYPE);
        containerType.setName(CONTAINER_NAME);
        containerType.setUTITypeName(UTI);
        return containerType;
    }

    public String getSchemaName() {
        return this.schemaName;
    }

    public void setSchemaName(String schemaName) {
        this.schemaName = schemaName;
    }

    @Override
    public String getToolName() {
        return "Leghorn epub describer";
    }

    @Override
    public String getToolVersion() {
        return Configuration.getVersion();
    }

    public static void main(String[] args) throws Exception {
        ContainerContainerDescriberRunner.main(new EPUBDescriber(), null, args);
    }
}

