/*
 * Decompiled with CFR 0.152.
 */
package com.apple.jingle.leghorn.epub;

import com.apple.its.epubcheck.Report;
import com.apple.its.epubcheck.Severity;
import com.apple.jingle.leghorn.epub.beans.Alert;
import com.apple.jingle.leghorn.epub.beans.EPUBCheckDescription;
import com.apple.jingle.leghorn.epub.beans.ObjectFactory;
import java.math.BigInteger;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

class EPUBCheckAlertCollector
implements Report {
    private ObjectFactory factory;
    private EPUBCheckDescription description;
    private Map<String, Alert> errors;
    private Map<String, Alert> warnings;
    private static final Pattern REPLACE_WITH_NOTHING = Pattern.compile("[\\u0000-\\u0008|\\u000B-\\u001F|\\u007F-\\u009F]");

    public EPUBCheckAlertCollector(ObjectFactory factory, EPUBCheckDescription description) {
        this.factory = factory;
        this.description = description;
        if (description.getErrors() == null) {
            description.setErrors(factory.createErrorList());
        }
        if (description.getWarnings() == null) {
            description.setWarnings(factory.createWarningList());
        }
        this.errors = new LinkedHashMap<String, Alert>();
        this.warnings = new LinkedHashMap<String, Alert>();
    }

    public void message(@Nonnull Severity severity, @Nonnull String code, @Nonnull String details, @Nonnull String file, int line, int column, @Nullable String context) {
        String key = code + details;
        switch (severity) {
            case FATAL: 
            case ERROR: {
                Alert alert = this.errors.get(key);
                if (alert == null) {
                    alert = this.createAlert(code, details, file, line, context);
                    this.description.getErrors().getError().add(alert);
                    this.errors.put(key, alert);
                    break;
                }
                this.increment(alert);
                break;
            }
            case WARNING: {
                Alert alert = this.warnings.get(key);
                if (alert == null) {
                    alert = this.createAlert(code, details, file, line, context);
                    this.description.getWarnings().getWarning().add(alert);
                    this.warnings.put(key, alert);
                    break;
                }
                this.increment(alert);
                break;
            }
        }
    }

    private Alert createAlert(@Nonnull String code, @Nonnull String details, @Nonnull String file, int line, @Nullable String context) {
        Alert alert = this.factory.createAlert();
        alert.setResource(file);
        alert.setLine(BigInteger.valueOf(line));
        alert.setMessage(EPUBCheckAlertCollector.sanitizeMessage(details));
        alert.setMessageId(code);
        alert.setOccurrences(BigInteger.valueOf(1L));
        alert.setContext(context);
        return alert;
    }

    protected static String sanitizeMessage(String message) {
        if (message == null) {
            return message;
        }
        Matcher m = REPLACE_WITH_NOTHING.matcher(message);
        return m.replaceAll("");
    }

    private void increment(Alert alert) {
        alert.setOccurrences(alert.getOccurrences().add(BigInteger.valueOf(1L)));
    }
}

