/*
 * Decompiled with CFR 0.152.
 */
package com.apple.jingle.leghorn.dolby.contentmapping;

import com.apple.jingle.g5.util.DataDiffSet;
import com.apple.jingle.g5.util.DataDiffable;
import com.apple.jingle.g5.util.DataDump;
import com.apple.jingle.g5.util.DataDumpable;
import com.apple.jingle.g5.util.JsonDataDump;
import com.apple.jingle.g5.util.MapDataDump;
import com.apple.jingle.g5.util.StringDataDump;
import com.apple.jingle.leghorn.LeghornValidationContext;
import com.apple.jingle.leghorn.beans.dolby.contentmapping.DolbyContentMappingDocument;
import com.apple.jingle.leghorn.dolby.contentmapping.DolbyCmOutput;
import com.apple.jingle.leghorn.dolby.contentmapping.DolbyCmSource;
import com.apple.jingle.leghorn.media.MediaValidationCode;
import com.apple.jingle.leghorn.media.MediaValue;
import com.apple.jingle.leghorn.media.file.MediaFileContext;
import com.apple.jingle.leghorn.media.xml.JsonMediaParser;
import com.apple.jingle.leghorn.media.xml.XmlObjectMediaParser;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.ThreadSafe;
import javax.json.Json;
import javax.json.JsonObject;
import javax.json.JsonReader;

@Immutable
@ThreadSafe
public class DolbyContentMap
implements DataDumpable,
DataDiffable<DolbyContentMap> {
    @Nonnull
    private final MediaValue<String> version;
    @Nonnull
    private final List<DolbyCmSource> sources;
    @Nonnull
    private final List<DolbyCmOutput> outputs;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DolbyContentMap(@Nonnull MediaFileContext ctx, @Nonnull DolbyContentMappingDocument.DolbyContentMapping xmlObject) {
        try (JsonReader r = Json.createReader((Reader)new StringReader(xmlObject.getData()));){
            JsonObject cm = r.readObject().getJsonObject("DolbyContentMap");
            JsonMediaParser parser = new JsonMediaParser(ctx, ctx.getMediaName(), cm);
            this.version = parser.toMediaString("version", MediaValidationCode.HDR_MAPPING_VERSION_MISSING.getBaseCode());
            Collection<JsonMediaParser> children = parser.children("sources");
            ArrayList<DolbyCmSource> sources = new ArrayList<DolbyCmSource>(children.size());
            for (JsonMediaParser source : children) {
                sources.add(new DolbyCmSource(this, ctx, source));
            }
            this.sources = Collections.unmodifiableList(sources);
            children = parser.children("outputs");
            ArrayList<DolbyCmOutput> outputs = new ArrayList<DolbyCmOutput>(children.size());
            for (JsonMediaParser output : children) {
                outputs.add(new DolbyCmOutput(this, ctx, output));
            }
            this.outputs = Collections.unmodifiableList(outputs);
        }
    }

    public DolbyContentMap(@Nonnull LeghornValidationContext ctx, @Nonnull XmlObjectMediaParser parser) {
        this.version = parser.toMediaString("@version", MediaValidationCode.HDR_MAPPING_VERSION_MISSING.getBaseCode());
        Collection<XmlObjectMediaParser> children = parser.children("SourceList/Source");
        ArrayList<DolbyCmSource> sources = new ArrayList<DolbyCmSource>(children.size());
        for (XmlObjectMediaParser source : children) {
            sources.add(new DolbyCmSource(ctx, source));
        }
        this.sources = Collections.unmodifiableList(sources);
        children = parser.children("Outputs/Output");
        ArrayList<DolbyCmOutput> outputs = new ArrayList<DolbyCmOutput>(children.size());
        for (XmlObjectMediaParser output : children) {
            outputs.add(new DolbyCmOutput(ctx, output));
        }
        this.outputs = Collections.unmodifiableList(outputs);
    }

    @Override
    public void dumpData(DataDump dump) {
        dump.write("version", this.version.tryGet()).dump("sources", this.sources).dump("outputs", this.outputs);
    }

    @Override
    public void diff(@Nonnull DataDiffSet diffs, @Nonnull String prefix, @Nonnull DolbyContentMap compareTo) {
        MapDataDump.diff(diffs, prefix, this, compareTo);
    }

    public String toString() {
        return StringDataDump.toString(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void generateDescription(@Nonnull LeghornValidationContext ctx, @Nonnull DolbyContentMappingDocument.DolbyContentMapping cm) {
        try (JsonDataDump dump = new JsonDataDump(false);){
            dump.dump("DolbyContentMap", this);
        }
        cm.setData(dump.toString());
    }

    @Nonnull
    public String version() {
        return this.version.get();
    }

    @Nonnull
    public List<DolbyCmSource> sources() {
        return this.sources;
    }

    @Nonnull
    public List<DolbyCmOutput> outputs() {
        return this.outputs;
    }
}

