/*
 * Decompiled with CFR 0.152.
 */
package com.apple.jingle.leghorn.dolby.contentmapping;

import com.apple.jingle.g5.util.DataDiffSet;
import com.apple.jingle.g5.util.DataDiffable;
import com.apple.jingle.g5.util.DataDump;
import com.apple.jingle.g5.util.DataDumpable;
import com.apple.jingle.g5.util.MapDataDump;
import com.apple.jingle.g5.util.StringDataDump;
import com.apple.jingle.leghorn.LeghornValidationContext;
import com.apple.jingle.leghorn.dolby.contentmapping.DolbyCmColorEncoding;
import com.apple.jingle.leghorn.dolby.contentmapping.DolbyCmDisplay;
import com.apple.jingle.leghorn.dolby.contentmapping.DolbyCmOutput;
import com.apple.jingle.leghorn.dolby.contentmapping.DolbyCmTrack;
import com.apple.jingle.leghorn.media.MediaUtil;
import com.apple.jingle.leghorn.media.MediaValidationCode;
import com.apple.jingle.leghorn.media.file.MediaFileContext;
import com.apple.jingle.leghorn.media.xml.JsonMediaParser;
import com.apple.jingle.leghorn.media.xml.XmlObjectMediaParser;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class DolbyCmVideoTrack
extends DolbyCmTrack
implements DataDumpable,
DataDiffable<DolbyCmVideoTrack> {
    @Nullable
    private final DolbyCmColorEncoding colorEncoding;
    @Nullable
    private final DolbyCmDisplay masteringDisplay;
    @Nonnull
    private final List<DolbyCmDisplay> targetDisplays;

    public DolbyCmVideoTrack(@Nonnull DolbyCmOutput parent, @Nonnull MediaFileContext ctx, @Nonnull JsonMediaParser parser) {
        super(parent, ctx, parser);
        parser = parser.childParser("t" + MediaUtil.coalesce("", this.uniqueId.tryGet()));
        JsonMediaParser colorEncoding = parser.child("colorEncoding");
        if (null != colorEncoding) {
            this.colorEncoding = new DolbyCmColorEncoding((DolbyCmTrack)this, ctx, colorEncoding);
        } else {
            ctx.addIssue(MediaValidationCode.HDR_MAPPING_VIDEOTRACK_COLORENCODING_MISSING, ctx.getMediaName() + "#" + this.uniqueId(), MediaUtil.dictionary);
            this.colorEncoding = null;
        }
        JsonMediaParser masteringDisplay = parser.child("masteringDisplay");
        if (null != masteringDisplay) {
            this.masteringDisplay = new DolbyCmDisplay((DolbyCmTrack)this, ctx, masteringDisplay);
        } else {
            ctx.addIssue(MediaValidationCode.HDR_MAPPING_VIDEOTRACK_MASTERINGDISPLAY_MISSING, ctx.getMediaName() + "#" + this.uniqueId(), MediaUtil.dictionary);
            this.masteringDisplay = null;
        }
        Collection<JsonMediaParser> children = parser.children("targets");
        ArrayList<DolbyCmDisplay> targetDisplays = new ArrayList<DolbyCmDisplay>(children.size());
        for (JsonMediaParser shot : children) {
            targetDisplays.add(new DolbyCmDisplay((DolbyCmTrack)this, ctx, shot));
        }
        this.targetDisplays = Collections.unmodifiableList(targetDisplays);
    }

    public DolbyCmVideoTrack(@Nonnull LeghornValidationContext ctx, @Nonnull XmlObjectMediaParser parser) {
        super(ctx, parser);
        parser = parser.childParser("t" + MediaUtil.coalesce("", this.uniqueId.tryGet()));
        XmlObjectMediaParser colorEncoding = parser.child("ColorEncoding");
        if (null != colorEncoding) {
            this.colorEncoding = new DolbyCmColorEncoding((DolbyCmTrack)this, ctx, colorEncoding);
        } else {
            ctx.addIssue(MediaValidationCode.HDR_MAPPING_VIDEOTRACK_COLORENCODING_MISSING, ctx.getMediaName() + "#" + this.uniqueId(), MediaUtil.dictionary);
            this.colorEncoding = null;
        }
        XmlObjectMediaParser masteringDisplay = parser.child("PluginNode/DolbyEDR/Characteristics/MasteringDisplay");
        if (null != masteringDisplay) {
            this.masteringDisplay = new DolbyCmDisplay((DolbyCmTrack)this, ctx, masteringDisplay);
        } else {
            ctx.addIssue(MediaValidationCode.HDR_MAPPING_VIDEOTRACK_MASTERINGDISPLAY_MISSING, ctx.getMediaName() + "#" + this.uniqueId(), MediaUtil.dictionary);
            this.masteringDisplay = null;
        }
        Collection<XmlObjectMediaParser> children = parser.children("PluginNode/DolbyEDR/Characteristics/TargetDisplay");
        ArrayList<DolbyCmDisplay> shots = new ArrayList<DolbyCmDisplay>(children.size());
        for (XmlObjectMediaParser shot : children) {
            shots.add(new DolbyCmDisplay((DolbyCmTrack)this, ctx, shot));
        }
        this.targetDisplays = Collections.unmodifiableList(shots);
    }

    @Override
    public void dumpData(@Nonnull DataDump dump) {
        super.dumpData(dump);
        dump.dump("colorEncoding", this.colorEncoding).dump("masteringDisplay", this.masteringDisplay).dump("targets", this.targetDisplays);
    }

    @Override
    public void diff(@Nonnull DataDiffSet diffs, @Nonnull String prefix, @Nonnull DolbyCmVideoTrack compareTo) {
        MapDataDump.diff(diffs, prefix, this, compareTo);
    }

    @Override
    public String toString() {
        return StringDataDump.toString(this);
    }

    @Nullable
    public DolbyCmDisplay masteringDisplay() {
        return this.masteringDisplay;
    }

    @Nonnull
    public List<DolbyCmDisplay> targetDisplays() {
        return this.targetDisplays;
    }

    @Nullable
    public DolbyCmColorEncoding colorEncoding() {
        return this.colorEncoding;
    }
}

