/*
 * Decompiled with CFR 0.152.
 */
package com.apple.jingle.leghorn.dolby.contentmapping;

import com.apple.jingle.g5.util.DataDump;
import com.apple.jingle.g5.util.DataDumpable;
import com.apple.jingle.g5.util.StringDataDump;
import com.apple.jingle.leghorn.LeghornValidationContext;
import com.apple.jingle.leghorn.dolby.contentmapping.DolbyCmOutput;
import com.apple.jingle.leghorn.dolby.contentmapping.DolbyCmShot;
import com.apple.jingle.leghorn.media.MediaUtil;
import com.apple.jingle.leghorn.media.MediaValidationCode;
import com.apple.jingle.leghorn.media.MediaValue;
import com.apple.jingle.leghorn.media.file.MediaFileContext;
import com.apple.jingle.leghorn.media.xml.JsonMediaParser;
import com.apple.jingle.leghorn.media.xml.XmlObjectMediaParser;
import com.apple.jingle.leghorn.timecode.SampleRate;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.ThreadSafe;

@Immutable
@ThreadSafe
public abstract class DolbyCmTrack
implements DataDumpable {
    @Nonnull
    protected final MediaValue<String> name;
    @Nonnull
    protected final MediaValue<BigDecimal> uniqueId;
    @Nonnull
    protected final MediaValue<SampleRate> rate;
    @Nonnull
    protected final List<DolbyCmShot> shots;

    public DolbyCmTrack(@Nonnull DolbyCmOutput parent, @Nonnull MediaFileContext ctx, @Nonnull JsonMediaParser parser) {
        this.uniqueId = parser.uuidToMediaDecimal("uid", MediaValidationCode.HDR_MAPPING_TRACK_ID_MISSING.getBaseCode());
        JsonMediaParser childParser = parser.childParser("t" + MediaUtil.coalesce("", this.uniqueId.tryGet()));
        this.name = childParser.toMediaString("name", MediaValidationCode.HDR_MAPPING_TRACK_NAME_MISSING.getBaseCode());
        this.rate = childParser.toMediaSampleRate("rate", MediaValidationCode.HDR_MAPPING_TRACK_RATE_MISSING.getBaseCode());
        Collection<JsonMediaParser> children = childParser.children("shots");
        ArrayList<DolbyCmShot> shotsList = new ArrayList<DolbyCmShot>(children.size());
        for (JsonMediaParser jsonMediaParser : children) {
            shotsList.add(new DolbyCmShot(this, ctx, jsonMediaParser));
        }
        this.shots = Collections.unmodifiableList(shotsList);
        for (int i = 0; i < this.shots.size() - 1; ++i) {
            DolbyCmShot dolbyCmShot = this.shots.get(i);
            DolbyCmShot nextShot = this.shots.get(i + 1);
            if (dolbyCmShot.startTime().add(dolbyCmShot.duration()).compareTo(nextShot.startTime()) == 0) continue;
            parser.toMediaError(MediaValidationCode.HDR_MAPPING_SHOT_DURATION_INVALID, MediaUtil.dictionary.add("start", String.format("%d", dolbyCmShot.startTime().getSampleCount())).add("duration", String.format("%d", dolbyCmShot.duration().getSampleCount())).add("nextStart", String.format("%d", nextShot.startTime().getSampleCount())).add("nextDuration", String.format("%d", nextShot.duration().getSampleCount())));
        }
    }

    public DolbyCmTrack(@Nonnull LeghornValidationContext ctx, @Nonnull XmlObjectMediaParser parser) {
        this.uniqueId = parser.uuidToMediaDecimal("UniqueID", MediaValidationCode.HDR_MAPPING_TRACK_ID_MISSING.getBaseCode());
        parser = parser.childParser("t" + MediaUtil.coalesce("", this.uniqueId.tryGet()));
        this.name = parser.toMediaString("@name", MediaValidationCode.HDR_MAPPING_TRACK_NAME_MISSING.getBaseCode());
        this.rate = parser.toMediaSampleRate("Rate/n", "Rate/d", MediaValidationCode.HDR_MAPPING_TRACK_RATE_MISSING.getBaseCode());
        Collection<XmlObjectMediaParser> children = parser.children("Shot");
        ArrayList<DolbyCmShot> shots = new ArrayList<DolbyCmShot>(children.size());
        for (XmlObjectMediaParser xmlObjectMediaParser : children) {
            shots.add(new DolbyCmShot(this, ctx, xmlObjectMediaParser));
        }
        this.shots = Collections.unmodifiableList(shots);
        for (int i = 0; i < shots.size() - 1; ++i) {
            DolbyCmShot dolbyCmShot = (DolbyCmShot)shots.get(i);
            DolbyCmShot nextShot = (DolbyCmShot)shots.get(i + 1);
            if (dolbyCmShot.startTime().add(dolbyCmShot.duration()).compareTo(nextShot.startTime()) == 0) continue;
            parser.toMediaError(MediaValidationCode.HDR_MAPPING_SHOT_DURATION_INVALID, MediaUtil.dictionary.add("start", String.format("%d", dolbyCmShot.startTime().getSampleCount())).add("duration", String.format("%d", dolbyCmShot.duration().getSampleCount())).add("nextStart", String.format("%d", nextShot.startTime().getSampleCount())).add("nextDuration", String.format("%d", nextShot.duration().getSampleCount())));
        }
    }

    @Nonnegative
    public long uniqueId() {
        return this.uniqueId.get().longValue();
    }

    @Nullable
    public SampleRate sampleRate() {
        return this.rate.tryGet();
    }

    @Nonnull
    public List<DolbyCmShot> shots() {
        return this.shots;
    }

    @Override
    public void dumpData(@Nonnull DataDump dump) {
        dump.write("uid", this.uniqueId.tryGet()).write("name", this.name.tryGet()).write("rate", this.rate.tryGet()).dump("shots", this.shots);
    }

    public String toString() {
        return StringDataDump.toString(this);
    }
}

