/*
 * Decompiled with CFR 0.152.
 */
package com.apple.jingle.leghorn.dolby.contentmapping;

import com.apple.jingle.g5.util.DataDiffSet;
import com.apple.jingle.g5.util.DataDiffable;
import com.apple.jingle.g5.util.DataDump;
import com.apple.jingle.g5.util.DataDumpable;
import com.apple.jingle.g5.util.MapDataDump;
import com.apple.jingle.leghorn.LeghornValidationContext;
import com.apple.jingle.leghorn.dolby.contentmapping.DolbyContentMap;
import com.apple.jingle.leghorn.media.MediaValidationCode;
import com.apple.jingle.leghorn.media.MediaValue;
import com.apple.jingle.leghorn.media.file.MediaFileContext;
import com.apple.jingle.leghorn.media.xml.JsonMediaParser;
import com.apple.jingle.leghorn.media.xml.XmlObjectMediaParser;
import com.apple.jingle.leghorn.timecode.SampleRate;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class DolbyCmSource
implements DataDumpable,
DataDiffable<DolbyCmSource> {
    @Nonnull
    private final MediaValue<String> assetId;
    @Nonnull
    private final MediaValue<String> uniqueId;
    @Nonnull
    private final MediaValue<String> clipName;
    @Nonnull
    private final MediaValue<SampleRate> rate;

    DolbyCmSource(@Nonnull DolbyContentMap parent, @Nonnull MediaFileContext ctx, @Nonnull JsonMediaParser parser) {
        this.assetId = parser.toMediaString("assetId", MediaValidationCode.HDR_MAPPING_SOURCE_ASSETID_MISSING.getBaseCode());
        this.uniqueId = parser.toMediaString("uid", MediaValidationCode.HDR_MAPPING_SOURCE_UNIQUEID_MISSING.getBaseCode());
        this.clipName = parser.toMediaString("clipName", MediaValidationCode.HDR_MAPPING_SOURCE_CLIPNAME_MISSING.getBaseCode());
        this.rate = parser.toMediaSampleRate("rate", MediaValidationCode.HDR_MAPPING_SOURCE_RATE_MISSING.getBaseCode());
    }

    DolbyCmSource(@Nonnull LeghornValidationContext ctx, @Nonnull XmlObjectMediaParser parser) {
        this.assetId = parser.toMediaString("AssetID", MediaValidationCode.HDR_MAPPING_SOURCE_ASSETID_MISSING.getBaseCode());
        this.uniqueId = parser.toMediaString("UniqueID", MediaValidationCode.HDR_MAPPING_SOURCE_UNIQUEID_MISSING.getBaseCode());
        this.clipName = parser.toMediaString("ClipName", MediaValidationCode.HDR_MAPPING_SOURCE_CLIPNAME_MISSING.getBaseCode());
        this.rate = parser.toMediaSampleRate("Rate/n", "Rate/d", MediaValidationCode.HDR_MAPPING_SOURCE_RATE_MISSING.getBaseCode());
    }

    @Override
    public void dumpData(@Nonnull DataDump dump) {
        dump.write("uid", this.uniqueId.tryGet()).write("assetId", this.assetId.tryGet()).write("clipName", this.clipName.tryGet()).write("rate", this.rate.tryGet());
    }

    @Override
    public void diff(@Nonnull DataDiffSet diffs, @Nonnull String prefix, @Nonnull DolbyCmSource compareTo) {
        MapDataDump.diff(diffs, prefix, this, compareTo);
    }

    public String toString() {
        return "Source[" + this.uniqueId.tryGet() + "]";
    }

    @Nullable
    public String assetId() {
        return this.assetId.tryGet();
    }

    @Nullable
    public String uniqueId() {
        return this.uniqueId.tryGet();
    }

    @Nullable
    public String clipName() {
        return this.clipName.tryGet();
    }

    @Nullable
    public SampleRate rate() {
        return this.rate.tryGet();
    }
}

