/*
 * Decompiled with CFR 0.152.
 */
package com.apple.jingle.leghorn.dolby.contentmapping;

import com.apple.jingle.g5.util.DataDump;
import com.apple.jingle.g5.util.DataDumpable;
import com.apple.jingle.g5.util.StringDataDump;
import com.apple.jingle.leghorn.LeghornValidationContext;
import com.apple.jingle.leghorn.dolby.contentmapping.DolbyCmTrack;
import com.apple.jingle.leghorn.media.MediaUtil;
import com.apple.jingle.leghorn.media.MediaValidationCode;
import com.apple.jingle.leghorn.media.MediaValue;
import com.apple.jingle.leghorn.media.file.MediaFileContext;
import com.apple.jingle.leghorn.media.xml.JsonMediaParser;
import com.apple.jingle.leghorn.media.xml.XmlObjectMediaParser;
import com.apple.jingle.leghorn.timecode.MediaTime;
import com.apple.jingle.leghorn.timecode.SampleRate;
import java.math.BigDecimal;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class DolbyCmShot
implements DataDumpable {
    @Nonnull
    private final DolbyCmTrack parent;
    @Nonnull
    private final MediaValue<BigDecimal> uniqueId;
    @Nonnull
    private final MediaValue<BigDecimal> recordIn;
    @Nonnull
    private final MediaValue<BigDecimal> recordDuration;
    @Nonnull
    private final MediaValue<BigDecimal> sourceIn;
    @Nonnull
    private final MediaValue<BigDecimal> sourceParentId;

    public DolbyCmShot(@Nonnull DolbyCmTrack parent, @Nonnull MediaFileContext ctx, @Nonnull JsonMediaParser parser) {
        this.parent = parent;
        this.uniqueId = parser.uuidToMediaDecimal("uid", MediaValidationCode.HDR_MAPPING_SHOT_ID_MISSING.getBaseCode());
        parser = parser.childParser("s" + MediaUtil.coalesce("", this.uniqueId.tryGet()));
        this.recordIn = parser.toMediaDecimal("in", null, MediaValidationCode.HDR_MAPPING_SHOT_STARTIME_MISSING.getBaseCode());
        this.recordDuration = parser.toMediaDecimal("duration", null, MediaValidationCode.HDR_MAPPING_SHOT_DURATION_MISSING.getBaseCode());
        this.sourceIn = parser.toMediaDecimal("src", BigDecimal.ZERO, MediaValidationCode.HDR_MAPPING_SHOT_SOURCEIN_MISSING.getBaseCode());
        this.sourceParentId = parser.uuidToMediaDecimal("pid", MediaValidationCode.HDR_MAPPING_SHOT_PARENTID_MISSING.getBaseCode());
    }

    public DolbyCmShot(@Nonnull DolbyCmTrack parent, @Nonnull LeghornValidationContext ctx, @Nonnull XmlObjectMediaParser parser) {
        this.parent = parent;
        this.uniqueId = parser.uuidToMediaDecimal("UniqueID", MediaValidationCode.HDR_MAPPING_SHOT_ID_MISSING.getBaseCode());
        parser = parser.childParser("s" + MediaUtil.coalesce("", this.uniqueId.tryGet()));
        this.recordIn = parser.toMediaDecimal("Record/In", MediaValidationCode.HDR_MAPPING_SHOT_STARTIME_MISSING.getBaseCode());
        this.recordDuration = parser.toMediaDecimal("Record/Duration", MediaValidationCode.HDR_MAPPING_SHOT_DURATION_MISSING.getBaseCode());
        this.sourceIn = parser.toMediaDecimal("Source/In", MediaValidationCode.HDR_MAPPING_SHOT_SOURCEIN_MISSING.getBaseCode());
        this.sourceParentId = parser.uuidToMediaDecimal("Source/ParentID", MediaValidationCode.HDR_MAPPING_SHOT_PARENTID_MISSING.getBaseCode());
    }

    @Override
    public void dumpData(DataDump dump) {
        dump.write("uid", this.uniqueId.tryGet()).write("in", this.recordIn.tryGet()).write("duration", this.recordDuration.tryGet()).write("src", this.sourceIn.tryGet() == null || this.sourceIn.tryGet().longValue() != 0L, this.sourceIn.tryGet()).write("pid", this.sourceParentId.hasNullValue() || this.sourceParentId.tryGet() != null && this.sourceParentId.tryGet().longValue() != this.parent.uniqueId(), this.sourceParentId.tryGet());
    }

    public String toString() {
        return StringDataDump.toString(this);
    }

    @Nonnegative
    public long uniqueId() {
        return this.uniqueId.get().longValue();
    }

    @Nullable
    public MediaTime startTime() {
        BigDecimal rin = this.recordIn.tryGet();
        SampleRate sampleRate = this.parent.sampleRate();
        if (null != rin && null != sampleRate) {
            return new MediaTime(rin.longValue(), sampleRate);
        }
        return null;
    }

    @Nullable
    public MediaTime duration() {
        BigDecimal rin = this.recordDuration.tryGet();
        SampleRate sampleRate = this.parent.sampleRate();
        if (null != rin && null != sampleRate) {
            return new MediaTime(rin.longValue(), sampleRate);
        }
        return null;
    }

    @Nullable
    public MediaTime endTime() {
        MediaTime start = this.startTime();
        MediaTime dur = this.duration();
        if (null != start && null != dur) {
            return start.timeByAddingTime(dur);
        }
        return null;
    }
}

