/*
 * Decompiled with CFR 0.152.
 */
package com.apple.jingle.leghorn.dolby.contentmapping;

import com.apple.jingle.g5.util.DataDump;
import com.apple.jingle.g5.util.DataDumpable;
import com.apple.jingle.g5.util.StringDataDump;
import com.apple.jingle.leghorn.LeghornValidationContext;
import com.apple.jingle.leghorn.dolby.contentmapping.DolbyCmAudioTrack;
import com.apple.jingle.leghorn.dolby.contentmapping.DolbyCmVideoTrack;
import com.apple.jingle.leghorn.dolby.contentmapping.DolbyContentMap;
import com.apple.jingle.leghorn.media.MediaUtil;
import com.apple.jingle.leghorn.media.MediaValidationCode;
import com.apple.jingle.leghorn.media.MediaValue;
import com.apple.jingle.leghorn.media.file.MediaFileContext;
import com.apple.jingle.leghorn.media.xml.JsonMediaParser;
import com.apple.jingle.leghorn.media.xml.XmlObjectMediaParser;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nonnull;

public class DolbyCmOutput
implements DataDumpable {
    @Nonnull
    private final MediaValue<String> name;
    @Nonnull
    private final MediaValue<BigDecimal> uniqueId;
    @Nonnull
    private final List<DolbyCmVideoTrack> videoTracks;
    @Nonnull
    private final List<DolbyCmAudioTrack> audioTracks;

    public DolbyCmOutput(@Nonnull DolbyContentMap parent, @Nonnull MediaFileContext ctx, @Nonnull JsonMediaParser parser) {
        this.uniqueId = parser.uuidToMediaDecimal("uid", MediaValidationCode.HDR_MAPPING_OUTPUT_ID_MISSING.getBaseCode());
        parser = parser.childParser("o" + MediaUtil.coalesce("", this.uniqueId.tryGet()));
        this.name = parser.toMediaString("name", MediaValidationCode.HDR_MAPPING_OUTPUT_NAME_MISSING.getBaseCode());
        Collection<JsonMediaParser> tracks = parser.children("videoTracks");
        ArrayList<DolbyCmVideoTrack> videoTracks = new ArrayList<DolbyCmVideoTrack>(tracks.size());
        for (JsonMediaParser track : tracks) {
            videoTracks.add(new DolbyCmVideoTrack(this, ctx, track));
        }
        this.videoTracks = Collections.unmodifiableList(videoTracks);
        tracks = parser.children("audioTracks");
        ArrayList<DolbyCmAudioTrack> audioTracks = new ArrayList<DolbyCmAudioTrack>(tracks.size());
        for (JsonMediaParser track : tracks) {
            audioTracks.add(new DolbyCmAudioTrack(this, ctx, track));
        }
        this.audioTracks = Collections.unmodifiableList(audioTracks);
    }

    public DolbyCmOutput(@Nonnull LeghornValidationContext ctx, @Nonnull XmlObjectMediaParser parser) {
        this.uniqueId = parser.uuidToMediaDecimal("UniqueID", MediaValidationCode.HDR_MAPPING_OUTPUT_ID_MISSING.getBaseCode());
        parser = parser.childParser("o" + MediaUtil.coalesce("", this.uniqueId.tryGet()));
        this.name = parser.toMediaString("@name", MediaValidationCode.HDR_MAPPING_OUTPUT_NAME_MISSING.getBaseCode());
        Collection<XmlObjectMediaParser> tracks = parser.children("Video/Track");
        this.videoTracks = new ArrayList<DolbyCmVideoTrack>(tracks.size());
        for (XmlObjectMediaParser track : tracks) {
            this.videoTracks.add(new DolbyCmVideoTrack(ctx, track));
        }
        tracks = parser.children("Audio/Track");
        this.audioTracks = new ArrayList<DolbyCmAudioTrack>(tracks.size());
        for (XmlObjectMediaParser track : tracks) {
            this.audioTracks.add(new DolbyCmAudioTrack(ctx, track));
        }
    }

    @Override
    public void dumpData(DataDump dump) {
        dump.write("uid", this.uniqueId.tryGet()).write("name", this.name.tryGet()).dump("videoTracks", this.videoTracks).dump("audioTracks", this.audioTracks);
    }

    public String toString() {
        return StringDataDump.toString(this);
    }

    @Nonnull
    public List<DolbyCmVideoTrack> videoTracks() {
        return this.videoTracks;
    }

    @Nonnull
    public List<DolbyCmAudioTrack> audioTracks() {
        return this.audioTracks;
    }
}

