/*
 * Decompiled with CFR 0.152.
 */
package com.apple.jingle.leghorn.dolby.contentmapping;

import com.apple.jingle.g5.util.DataDump;
import com.apple.jingle.g5.util.DataDumpable;
import com.apple.jingle.g5.util.StringDataDump;
import com.apple.jingle.leghorn.LeghornValidationContext;
import com.apple.jingle.leghorn.dolby.contentmapping.DolbyCmTrack;
import com.apple.jingle.leghorn.media.MediaUtil;
import com.apple.jingle.leghorn.media.MediaValidationCode;
import com.apple.jingle.leghorn.media.MediaValue;
import com.apple.jingle.leghorn.media.file.MediaFileContext;
import com.apple.jingle.leghorn.media.xml.JsonMediaParser;
import com.apple.jingle.leghorn.media.xml.XmlObjectMediaParser;
import java.math.BigDecimal;
import java.util.Collection;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class DolbyCmDisplay
implements DataDumpable {
    @Nonnull
    private final MediaValue<BigDecimal> id;
    @Nonnull
    private final MediaValue<String> name;
    @Nonnull
    private final MediaValue<BigDecimal> diagonalSize;
    @Nonnull
    private final MediaValue<BigDecimal> bitDepth;
    @Nonnull
    private final MediaValue<String> colorSpace;
    @Nonnull
    private final MediaValue<String> chromaFormat;
    @Nonnull
    private final MediaValue<String> signalRange;
    @Nonnull
    private final MediaValue<List<BigDecimal>> redPrimary;
    @Nonnull
    private final MediaValue<List<BigDecimal>> greenPrimary;
    @Nonnull
    private final MediaValue<List<BigDecimal>> bluePrimary;
    @Nonnull
    private final MediaValue<List<BigDecimal>> whitePoint;
    @Nonnull
    private final MediaValue<BigDecimal> minBrightness;
    @Nonnull
    private final MediaValue<BigDecimal> peakBrightness;
    @Nonnull
    private final MediaValue<String> encoding;
    @Nonnull
    private final MediaValue<BigDecimal> gamma;

    public DolbyCmDisplay(@Nonnull DolbyCmTrack parent, @Nonnull MediaFileContext ctx, @Nonnull JsonMediaParser parser) {
        this.id = parser.toMediaDecimal("id", null, MediaValidationCode.HDR_MAPPING_DISPLAY_ID_MISSING.getBaseCode());
        parser = parser.childParser("d" + MediaUtil.coalesce("", this.id.tryGet()));
        this.name = parser.toMediaString("name", MediaValidationCode.HDR_MAPPING_DISPLAY_NAME_MISSING.getBaseCode());
        this.diagonalSize = parser.toMediaDecimal("diagonalSize", null, MediaValidationCode.HDR_MAPPING_DISPLAY_DIAGONALSIZE_MISSING.getBaseCode());
        this.bitDepth = parser.toMediaDecimal("bitDepth", null, MediaValidationCode.HDR_MAPPING_DISPLAY_BITDEPTH_MISSING.getBaseCode());
        this.colorSpace = parser.toMediaString("colorSpace", MediaValidationCode.HDR_MAPPING_DISPLAY_COLORSPACE_MISSING.getBaseCode());
        this.chromaFormat = parser.toMediaString("chromaFormat", MediaValidationCode.HDR_MAPPING_DISPLAY_CHROMAFORMAT_MISSING.getBaseCode());
        this.signalRange = parser.toMediaString("signalRange", MediaValidationCode.HDR_MAPPING_DISPLAY_SIGNALRANGE_MISSING.getBaseCode());
        this.encoding = parser.toMediaString("encoding", MediaValidationCode.HDR_MAPPING_DISPLAY_ENCODING_MISSING.getBaseCode());
        this.whitePoint = parser.toMediaDecimalList("whitePoint", 2, 2, MediaValidationCode.HDR_MAPPING_DISPLAY_WHITEPOINT_MISSING.getBaseCode());
        this.minBrightness = parser.toMediaDecimal("minBrightness", null, MediaValidationCode.HDR_MAPPING_DISPLAY_MINBRIGHTNESS_MISSING.getBaseCode());
        this.peakBrightness = parser.toMediaDecimal("peakBrightness", null, MediaValidationCode.HDR_MAPPING_DISPLAY_PEAKBRIGHTNESS_MISSING.getBaseCode());
        this.gamma = parser.toMediaDecimal("gamma", null, MediaValidationCode.HDR_MAPPING_DISPLAY_GAMMA_INVALID.getBaseCode());
        this.redPrimary = parser.toMediaDecimalList("r", 2, 2, MediaValidationCode.HDR_MAPPING_DISPLAY_RED_PRIMARY_MISSING.getBaseCode());
        this.greenPrimary = parser.toMediaDecimalList("g", 2, 2, MediaValidationCode.HDR_MAPPING_DISPLAY_GREEN_PRIMARY_MISSING.getBaseCode());
        this.bluePrimary = parser.toMediaDecimalList("b", 2, 2, MediaValidationCode.HDR_MAPPING_DISPLAY_BLUE_PRIMARY_MISSING.getBaseCode());
    }

    public DolbyCmDisplay(@Nonnull DolbyCmTrack parent, @Nonnull LeghornValidationContext ctx, @Nonnull XmlObjectMediaParser parser) {
        this.id = parser.toMediaDecimal("ID", MediaValidationCode.HDR_MAPPING_DISPLAY_ID_MISSING.getBaseCode());
        parser = parser.childParser("d" + MediaUtil.coalesce("", this.id.tryGet()));
        this.name = parser.toMediaString("Name", MediaValidationCode.HDR_MAPPING_DISPLAY_NAME_MISSING.getBaseCode());
        this.diagonalSize = parser.toMediaDecimal("DiagonalSize", MediaValidationCode.HDR_MAPPING_DISPLAY_DIAGONALSIZE_MISSING.getBaseCode());
        this.bitDepth = parser.toMediaDecimal("BitDepth", MediaValidationCode.HDR_MAPPING_DISPLAY_BITDEPTH_MISSING.getBaseCode());
        this.colorSpace = parser.toMediaString("ColorSpace", MediaValidationCode.HDR_MAPPING_DISPLAY_COLORSPACE_MISSING.getBaseCode());
        this.chromaFormat = parser.toMediaString("ChromaFormat", MediaValidationCode.HDR_MAPPING_DISPLAY_CHROMAFORMAT_MISSING.getBaseCode());
        this.signalRange = parser.toMediaString("SignalRange", MediaValidationCode.HDR_MAPPING_DISPLAY_SIGNALRANGE_MISSING.getBaseCode());
        this.encoding = parser.toMediaString("Encoding", MediaValidationCode.HDR_MAPPING_DISPLAY_ENCODING_MISSING.getBaseCode());
        this.whitePoint = parser.toMediaDecimalList("WhitePoint", 2, 2, MediaValidationCode.HDR_MAPPING_DISPLAY_WHITEPOINT_MISSING.getBaseCode());
        this.minBrightness = parser.toMediaDecimal("MinimumBrightness", MediaValidationCode.HDR_MAPPING_DISPLAY_MINBRIGHTNESS_MISSING.getBaseCode());
        this.peakBrightness = parser.toMediaDecimal("PeakBrightness", MediaValidationCode.HDR_MAPPING_DISPLAY_PEAKBRIGHTNESS_MISSING.getBaseCode());
        this.gamma = parser.toMediaDecimal("Gamma", MediaValidationCode.HDR_MAPPING_DISPLAY_GAMMA_INVALID.getBaseCode());
        this.redPrimary = parser.toMediaDecimalList("Primaries/Red", 2, 2, MediaValidationCode.HDR_MAPPING_DISPLAY_RED_PRIMARY_MISSING.getBaseCode());
        this.greenPrimary = parser.toMediaDecimalList("Primaries/Green", 2, 2, MediaValidationCode.HDR_MAPPING_DISPLAY_GREEN_PRIMARY_MISSING.getBaseCode());
        this.bluePrimary = parser.toMediaDecimalList("Primaries/Blue", 2, 2, MediaValidationCode.HDR_MAPPING_DISPLAY_BLUE_PRIMARY_MISSING.getBaseCode());
    }

    @Override
    public void dumpData(DataDump dump) {
        dump.write("id", this.id.tryGet()).write("name", this.name.tryGet()).write("diagonalSize", this.diagonalSize.tryGet()).write("bitDepth", this.bitDepth.tryGet()).write("colorSpace", this.colorSpace.tryGet()).write("chromaFormat", this.chromaFormat.tryGet()).write("signalRange", this.signalRange.tryGet()).write("r", (Collection)this.redPrimary.tryGet()).write("g", (Collection)this.greenPrimary.tryGet()).write("b", (Collection)this.bluePrimary.tryGet()).write("gamma", this.gamma.tryGet()).write("whitePoint", (Collection)this.whitePoint.tryGet()).write("minBrightness", this.minBrightness.tryGet()).write("peakBrightness", this.peakBrightness.tryGet()).write("encoding", this.encoding.tryGet());
    }

    public String toString() {
        return StringDataDump.toString(this);
    }

    public BigDecimal getId() {
        return this.id.get();
    }

    public String getName() {
        return this.name.get();
    }

    @Nullable
    public BigDecimal diagonalSize() {
        return this.diagonalSize.tryGet();
    }

    public int bitDepth() {
        return this.bitDepth.get().intValue();
    }

    @Nullable
    public String colorSpace() {
        return this.colorSpace.tryGet();
    }

    @Nullable
    public String chromaFormat() {
        return this.chromaFormat.tryGet();
    }

    @Nullable
    public String signalRange() {
        return this.signalRange.tryGet();
    }

    @Nullable
    private static final String toString(Collection<?> c) {
        if (c != null) {
            StringBuilder sb = new StringBuilder();
            for (Object o : c) {
                if (sb.length() != 0) {
                    sb.append(',');
                }
                sb.append(o.toString());
            }
            return sb.toString();
        }
        return null;
    }

    @Nullable
    public String redPrimaryString() {
        return DolbyCmDisplay.toString((Collection)this.redPrimary.tryGet());
    }

    @Nullable
    public String greenPrimaryString() {
        return DolbyCmDisplay.toString((Collection)this.greenPrimary.tryGet());
    }

    @Nullable
    public String bluePrimaryString() {
        return DolbyCmDisplay.toString((Collection)this.bluePrimary.tryGet());
    }

    @Nullable
    public BigDecimal minBrightness() {
        return this.minBrightness.tryGet();
    }

    @Nullable
    public BigDecimal peakBrightness() {
        return this.peakBrightness.tryGet();
    }

    @Nonnull
    public MediaValue<BigDecimal> getPeakBrightness() {
        return this.peakBrightness;
    }
}

