/*
 * Decompiled with CFR 0.152.
 */
package com.apple.jingle.leghorn.cocktail.collection;

import com.apple.itunes.epubtoolkit.util.CommonsCompressZipUtil;
import com.apple.itunes.epubtoolkit.util.FileUtilities;
import com.apple.jingle.leghorn.cocktail.collection.CocktailException;
import com.apple.jingle.leghorn.cocktail.collection.beans.CocktailController;
import com.apple.jingle.leghorn.cocktail.collection.beans.CocktailControllersList;
import com.apple.jingle.leghorn.cocktail.collection.beans.CocktailDataFile;
import com.apple.jingle.leghorn.cocktail.collection.beans.CocktailDescription;
import com.apple.jingle.leghorn.cocktail.collection.beans.CocktailError;
import com.apple.jingle.leghorn.cocktail.collection.beans.CocktailErrors;
import com.apple.jingle.leghorn.cocktail.collection.beans.CocktailFile;
import com.apple.jingle.leghorn.cocktail.collection.beans.CocktailNestedDescription;
import com.apple.jingle.leghorn.cocktail.collection.beans.CocktailNestedDescriptionList;
import com.apple.jingle.leghorn.cocktail.collection.beans.CocktailReference;
import com.apple.jingle.leghorn.cocktail.collection.beans.CocktailReferenceList;
import com.apple.jingle.leghorn.cocktail.collection.beans.ObjectFactory;
import com.apple.jingle.leghorn.fileformat.ContainerDescription;
import com.apple.jingle.leghorn.fileformat.ContainerType;
import com.apple.jingle.leghorn.fileformat.ValidationInfo;
import com.apple.jingle.leghorn.fileformat.ValidationListener;
import com.apple.jingle.leghorn.fileformat.Verifier;
import com.apple.jingle.leghorn.fileformat.exceptions.DescriberNotFoundException;
import com.apple.jingle.leghorn.fileformat.exceptions.DescriptionException;
import com.apple.jingle.leghorn.fileformat.exceptions.UnknownTypeException;
import com.apple.jingle.leghorn.fileformat.impl.ContainerTypeFactory;
import com.apple.jingle.leghorn.fileformat.impl.ValidationsCollector;
import com.apple.jingle.media.foundation.util.XMLUtil;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.transform.TransformerException;
import org.apache.commons.lang3.ArrayUtils;
import org.w3c.dom.Node;

public class CocktailInformationCollector {
    private static final String INCLUDE_DESCRIPTIONS_PROPERTY_KEY = "com.apple.cocktailDescriber.describeIncludedFiles";
    private CocktailDescription result;
    private BufferedInputStream bis;
    private File tempDir;
    private ObjectFactory factory;
    private CocktailErrors errorList;
    private ContainerTypeFactory typeFactory;

    public CocktailInformationCollector(BufferedInputStream bis) {
        this.bis = bis;
        this.factory = new ObjectFactory();
        this.result = this.factory.createCocktailDescription();
        this.result.setFiles(this.factory.createCocktailFileList());
        this.result.setDataFiles(this.factory.createCocktailDataFileList());
        Verifier verifier = null;
        try {
            verifier = Verifier.getDefaultVerifier();
            this.typeFactory = verifier.getContainerTypeFactory();
        }
        catch (Exception e) {
            this.addError("container_init", "Unable to get containers for nested file validation", null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void collect() {
        try {
            this.unzip();
            this.tempDir = this.findMediaArchiveRoot(this.tempDir);
            this.recurseAllFiles(this.tempDir, "");
            this.collectDebugState();
        }
        catch (CocktailException ce) {
            this.addError(ce.getErrorType(), ce.getMessage(), null);
        }
        finally {
            this.clean();
        }
    }

    private File findMediaArchiveRoot(File tempDir) {
        File mediaArchiveRoot;
        Object[] mediaArchiveContents = tempDir.list();
        if (mediaArchiveContents.length < 1) {
            this.addError("content_missing", "Media archive zip is empty or invalid.", null);
            return null;
        }
        if (ArrayUtils.contains((Object[])mediaArchiveContents, (Object)"__MACOSX")) {
            mediaArchiveContents = (String[])ArrayUtils.remove((Object[])mediaArchiveContents, (int)ArrayUtils.indexOf((Object[])mediaArchiveContents, (Object)"__MACOSX"));
        }
        File file = mediaArchiveRoot = mediaArchiveContents.length > 1 ? tempDir : new File(tempDir, (String)mediaArchiveContents[0]);
        if (!mediaArchiveRoot.isDirectory()) {
            this.addError("content_missing", "Unable to locate manifest.xml and index.html", null);
            return null;
        }
        return mediaArchiveRoot;
    }

    private void recurseAllFiles(File dir, String root) {
        File[] files;
        if (dir == null) {
            return;
        }
        for (File ff : files = dir.listFiles()) {
            String thisFile = root + ff.getName();
            if (ff.isDirectory()) {
                this.recurseAllFiles(ff, thisFile + File.separator);
                continue;
            }
            CocktailFile cfile = this.factory.createCocktailFile();
            cfile.setValue(thisFile);
            cfile.setSize(ff.length());
            this.result.getFiles().getFile().add(cfile);
            String thisFileLower = thisFile.toLowerCase();
            if (thisFileLower.endsWith(".js")) {
                if (this.isDataFile(root, ff)) continue;
                this.checkATVNavigation(root, ff);
                continue;
            }
            if (thisFileLower.endsWith(".html") || thisFileLower.endsWith(".htm")) {
                this.checkRefs(root, ff);
                continue;
            }
            if (thisFileLower.endsWith(".css")) {
                this.checkCSSRefs(root, ff);
                continue;
            }
            if (thisFileLower.equals("manifest.xml")) {
                this.readManifest(ff);
                continue;
            }
            if (this.typeFactory == null) continue;
            try {
                ContainerType cType = this.typeFactory.getTypeForFile(ff);
                try {
                    Verifier verifier = Verifier.getDefaultVerifier();
                    ValidationsCollector listener = new ValidationsCollector();
                    if (verifier.verifyContainerType(ff.toURI(), cType, (ValidationListener)listener)) {
                        String shouldDescribe = System.getProperty(INCLUDE_DESCRIPTIONS_PROPERTY_KEY);
                        if (!"true".equalsIgnoreCase(shouldDescribe)) continue;
                        ContainerDescription desc = verifier.describe(ff.toURI(), cType);
                        String descStr = XMLUtil.nodeToString((Node)((Node)desc.getDescriptionDocument()));
                        CocktailNestedDescriptionList nestedDescs = this.result.getNestedDescriptions();
                        if (nestedDescs == null) {
                            nestedDescs = this.factory.createCocktailNestedDescriptionList();
                            this.result.setNestedDescriptions(nestedDescs);
                        }
                        CocktailNestedDescription descResult = this.factory.createCocktailNestedDescription();
                        descResult.setFile(root + ff.getName());
                        descResult.setDescriptionText(descStr);
                        nestedDescs.getDescription().add(descResult);
                        continue;
                    }
                    for (ValidationInfo info : listener.getValidations()) {
                        this.addError("nested_describer_error", "Error occurred while attempting to validate " + root + ff.getName() + "  :  " + info.getUserString(), cType.getUTITypeName());
                    }
                }
                catch (DescriberNotFoundException e) {
                }
                catch (IOException e) {
                    this.addError("nested_desriber_ioexception", "IOException attempting to describe " + root + ff.getName(), cType.getUTITypeName());
                }
                catch (DescriptionException e) {
                    this.addError("nested_describer_error", "DescriptionException " + e.getMessage() + " while attempting to describe " + root + ff.getName(), cType.getUTITypeName());
                }
                catch (TransformerException e) {
                    this.addError("nested_describer_transformer_error", "TransformerException " + e.getMessage() + " while attempting to describe " + root + ff.getName(), cType.getUTITypeName());
                }
                catch (Exception e) {
                    this.addError("nested_describer_unknown_exception", "Error occurred while attempting to describe " + root + ff.getName() + "  :  " + e.getMessage(), cType.getUTITypeName());
                }
            }
            catch (UnknownTypeException e) {
                // empty catch block
            }
        }
    }

    private void readManifest(File ff) {
        try {
            this.result.setManifest(FileUtilities.readFileAsString((File)ff));
        }
        catch (IOException e) {
            this.addError("ioexception", "IOException occured while attempting to parse manifest.xml.  Check that the file is valid and uncorrupted.", null);
        }
    }

    private boolean isDataFile(String root, File ff) {
        if (!ff.getName().endsWith(".js") || !ff.getName().contains("data")) {
            return false;
        }
        try {
            String content = FileUtilities.readFileAsString((File)ff);
            if ("data.js".equals(ff.getName()) || ff.getName().contains("data") && content.matches("var [^;]*};\\s*")) {
                CocktailDataFile dataFile = this.factory.createCocktailDataFile();
                dataFile.setPath(root + ff.getName());
                dataFile.setContents(content);
                this.result.getDataFiles().getFile().add(dataFile);
                return true;
            }
        }
        catch (IOException e) {
            this.addError("ioexception", "IOException occured while attempting to parse " + root + ff.getName() + ".  Check that the file is valid and uncorrupted.", null);
        }
        return false;
    }

    private void checkCSSRefs(String root, File ff) {
        if (!ff.getName().toLowerCase().endsWith(".css")) {
            return;
        }
        Pattern csp = Pattern.compile("(?i)url\\([\"']?(?:..\\/)+(images\\/[^)]*)\\)");
        try {
            String cssSrc = FileUtilities.readFileAsString((File)ff);
            Matcher cssM = csp.matcher(cssSrc);
            while (cssM.find()) {
                File imageFile;
                String image = cssM.group(1);
                if (image.endsWith("\"") || image.endsWith("'")) {
                    image = image.substring(0, image.length() - 1);
                }
                if ((imageFile = new File(this.tempDir, FileUtilities.decodeURIPath((String)image))).exists()) continue;
                CocktailReference missingReference = this.factory.createCocktailReference();
                missingReference.setSource(root + ff.getName());
                missingReference.setTarget(image);
                this.addMissingReferences(missingReference);
            }
        }
        catch (IOException e) {
            this.addError("ioexception", "IOException occured while attempting to parse " + root + ff.getName() + ".  Check that the file is valid and uncorrupted.", null);
        }
    }

    private void addMissingReferences(CocktailReference missingReference) {
        CocktailReferenceList rList = this.result.getMissingReferences();
        if (rList == null) {
            rList = this.factory.createCocktailReferenceList();
            this.result.setMissingReferences(rList);
        }
        rList.getFile().add(missingReference);
    }

    private void checkRefs(String root, File ff) {
        if (!ff.getName().toLowerCase().endsWith(".html") && !ff.getName().toLowerCase().endsWith(".htm")) {
            return;
        }
        Pattern img = Pattern.compile("<img\\s*src=[\"'](http)?([^\"^']*)[\"'][^>]*>");
        Pattern link = Pattern.compile("(?i)(<(?:link|a)\\s*href=[\"'])(?!http)([^\"^'^#^?]+)([^\"^']*)([\"'][^>]*>)");
        Pattern script = Pattern.compile("(?i)<script\\s*(src=[\"']([^\"^']*)[\"'])[^>]*>");
        try {
            CocktailReference missingReference;
            File theFile;
            String filePath;
            String htmlContent = FileUtilities.readFileAsString((File)ff);
            Matcher imgM = img.matcher(htmlContent);
            Matcher linkM = link.matcher(htmlContent);
            Matcher scriptM = script.matcher(htmlContent);
            while (imgM.find()) {
                filePath = imgM.group(2);
                theFile = new File(this.tempDir, FileUtilities.decodeURIPath((String)filePath));
                if (theFile.exists()) continue;
                missingReference = this.factory.createCocktailReference();
                missingReference.setSource(root + ff.getName());
                missingReference.setTarget(filePath);
                this.addMissingReferences(missingReference);
            }
            while (linkM.find()) {
                filePath = linkM.group(2);
                theFile = new File(this.tempDir, FileUtilities.decodeURIPath((String)filePath));
                if (theFile.exists()) continue;
                missingReference = this.factory.createCocktailReference();
                missingReference.setSource(root + ff.getName());
                missingReference.setTarget(filePath);
                this.addMissingReferences(missingReference);
            }
            while (scriptM.find()) {
                filePath = scriptM.group(2);
                theFile = new File(this.tempDir, FileUtilities.decodeURIPath((String)filePath));
                if (theFile.exists()) continue;
                missingReference = this.factory.createCocktailReference();
                missingReference.setSource(root + ff.getName());
                missingReference.setTarget(filePath);
                this.addMissingReferences(missingReference);
            }
        }
        catch (IOException e1) {
            this.addError("ioexception", "An IOException occurred while attempting to open " + root + ff.getName() + ".  ", null);
        }
    }

    private void checkATVNavigation(String root, File ff) {
        if (!ff.getName().toLowerCase().endsWith(".js")) {
            return;
        }
        this.result.setHasControllers(true);
        CocktailController controller = this.factory.createCocktailController();
        controller.setValue(root + ff.getName());
        try {
            controller.setHasNav(FileUtilities.containsRegex((File)ff, (String)"[.]preferredElementToHighlightInDirection", (int)-1));
            this.addController(controller);
        }
        catch (IOException e) {
            this.addError("ioexception", "Exception occured while attempting to parse controllers/" + ff.getName() + ".  Check that the file is valid.", null);
        }
    }

    private void addController(CocktailController controller) {
        CocktailControllersList controllers = this.result.getControllers();
        if (controllers == null) {
            controllers = this.factory.createCocktailControllersList();
            this.result.setControllers(controllers);
        }
        controllers.getFile().add(controller);
    }

    private void collectDebugState() {
        File tuneKit = new File(this.tempDir, "TuneKit" + File.separator + "src" + File.separator + "TuneKit.js");
        if (!tuneKit.exists()) {
            this.addError("missing_tunekit", "TuneKit.js not found in TuneKit source folder.", null);
            return;
        }
        String fileContent = null;
        try {
            fileContent = FileUtilities.readFileAsString((File)tuneKit);
        }
        catch (Exception e) {
            this.addError("ioexception", "Exception occured while attempting to parse TuneKit.js.  Check that the file is valid.", null);
            return;
        }
        Pattern p = Pattern.compile("(?i)var DEBUG = (.*);");
        Matcher m = p.matcher(fileContent);
        if (m.find()) {
            String debugLevel = m.group(1);
            this.result.setDebugLevel(!"false".equalsIgnoreCase(debugLevel));
        } else {
            this.result.setDebugLevel(false);
        }
    }

    private void unzip() throws CocktailException {
        try {
            this.tempDir = FileUtilities.createTempDirectory((String)(System.currentTimeMillis() + "."), (String)"unpacked");
            new CommonsCompressZipUtil().unzip((InputStream)this.bis, this.tempDir);
        }
        catch (IOException ioe) {
            throw new CocktailException("ioexception", "Unable to extract information from media archive.  Possible bad ZIP file.");
        }
        catch (IllegalArgumentException iae) {
            throw new CocktailException("ioexception", "Unable to extract information from media archive.  Your zip file may contain file or folder names using non-ascii characters.");
        }
        catch (Throwable t) {
            throw new CocktailException("unexpectedException", t.getMessage());
        }
    }

    private void clean() {
        if (this.tempDir != null) {
            FileUtilities.deleteRecursively((File)this.tempDir);
        }
    }

    public CocktailDescription getResult() {
        return this.result;
    }

    private void addError(String code, String errorText, String uti) {
        if (this.errorList == null) {
            this.errorList = this.factory.createCocktailErrors();
            this.result.setErrors(this.errorList);
        }
        CocktailError error = this.factory.createCocktailError();
        error.setValue(errorText);
        error.setDescriberUTI(uti);
        error.setErrorCode(code);
        this.errorList.getError().add(error);
    }

    public ObjectFactory getFactory() {
        return this.factory;
    }
}

