/*
 * Decompiled with CFR 0.152.
 */
package com.apple.jingle.leghorn.cocktail;

import com.apple.jingle.leghorn.Configuration;
import com.apple.jingle.leghorn.cocktail.collection.CocktailInformationCollector;
import com.apple.jingle.leghorn.cocktail.collection.beans.CocktailDescription;
import com.apple.jingle.leghorn.cocktail.collection.beans.ObjectFactory;
import com.apple.jingle.leghorn.fileformat.ContainerDescription;
import com.apple.jingle.leghorn.fileformat.ContainerType;
import com.apple.jingle.leghorn.fileformat.exceptions.DescriptionException;
import com.apple.jingle.leghorn.fileformat.impl.ContainerTypeImpl;
import com.apple.jingle.leghorn.fileformat.impl.InputStreamContainerDescriberBase;
import com.apple.jingle.leghorn.fileformat.impl.SimpleContainerDescription;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Collections;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public class CocktailDescriber
extends InputStreamContainerDescriberBase<Node> {
    private static final String CONTAINER_NAME = "Cocktail";
    private static final String UTI = "com.apple.media-archive-container";
    private static final String MIME_TYPE = "application/zip";
    private String schemaName;

    @Override
    public String getToolName() {
        return "Leghorn cocktail describer";
    }

    @Override
    public String getToolVersion() {
        return Configuration.getVersion();
    }

    @Override
    public ContainerDescription<Node> describe(BufferedInputStream bis, ContainerType type) throws IOException, DescriptionException {
        CocktailInformationCollector collector = new CocktailInformationCollector(bis);
        collector.collect();
        CocktailDescription info = collector.getResult();
        return this.createContainerDescription(collector.getFactory(), info);
    }

    private ContainerDescription<Node> createContainerDescription(ObjectFactory factory, CocktailDescription description) throws DescriptionException {
        Document document;
        try {
            document = this.createDocument(description, factory);
        }
        catch (JAXBException e) {
            throw new DescriptionException(e);
        }
        return this.createContainerDescription(document);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Document createDocument(CocktailDescription description, ObjectFactory factory) throws JAXBException {
        ClassLoader jaxbClassLoader;
        ClassLoader oldClassLoader = Thread.currentThread().getContextClassLoader();
        ClassLoader classLoader = jaxbClassLoader = JAXBContext.class.getClassLoader() == null ? CocktailDescription.class.getClassLoader() : JAXBContext.class.getClassLoader();
        if (jaxbClassLoader != null) {
            Thread.currentThread().setContextClassLoader(jaxbClassLoader);
        }
        try {
            ClassLoader cl = ObjectFactory.class.getClassLoader();
            JAXBContext jc = JAXBContext.newInstance((String)CocktailDescription.class.getPackage().getName(), (ClassLoader)cl);
            Marshaller m = jc.createMarshaller();
            JAXBElement<CocktailDescription> jd = factory.createCocktailDescription(description);
            m.setProperty("jaxb.formatted.output", (Object)true);
            StringWriter out = new StringWriter();
            m.marshal(jd, (Writer)out);
            Document document = this.createDocument(out.toString());
            return document;
        }
        finally {
            Thread.currentThread().setContextClassLoader(oldClassLoader);
        }
    }

    private Document createDocument(String input) {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setNamespaceAware(true);
        try {
            factory.setFeature("http://apache.org/xml/features/disallow-doctype-decl", true);
            return factory.newDocumentBuilder().parse(new ByteArrayInputStream(input.getBytes("UTF-8")));
        }
        catch (ParserConfigurationException e) {
            throw new RuntimeException("Unable to configure document builder", e);
        }
        catch (Exception e) {
            throw new RuntimeException("Unable to create document", e);
        }
    }

    private ContainerDescription<Node> createContainerDescription(Document document) {
        ContainerTypeImpl containerType = this.createContainerType();
        SimpleContainerDescription result = new SimpleContainerDescription();
        result.setHasMultipleStreams(false);
        result.setStreamIdentifiers(Collections.emptyList());
        result.setType(containerType);
        result.setDescriptionDocument(document);
        return result;
    }

    private ContainerTypeImpl createContainerType() {
        ContainerTypeImpl containerType = new ContainerTypeImpl();
        containerType.setCanHaveMultipleStreams(Boolean.FALSE.toString());
        containerType.setContainerDescriber(this);
        containerType.setContainerVerifier(null);
        containerType.setMatcher(null);
        containerType.setMIMETypeName(MIME_TYPE);
        containerType.setName(CONTAINER_NAME);
        containerType.setUTITypeName(UTI);
        return containerType;
    }

    public String getSchemaName() {
        return this.schemaName;
    }

    public void setSchemaName(String schemaName) {
        this.schemaName = schemaName;
    }
}

