/*
 * Decompiled with CFR 0.152.
 */
package com.apple.jingle.leghorn.chapters;

import com.apple.iTunes.x2009.x10.x15.contentChaptering.ChaptersDocument;
import com.apple.jingle.leghorn.chapters.BaseChaptersDocument;
import com.apple.jingle.leghorn.chapters.ChaptersDocument;
import com.apple.jingle.leghorn.chapters.ChaptersDocumentException;
import com.apple.jingle.leghorn.media.exceptions.InvalidMediaException;
import com.apple.jingle.leghorn.timecode.TimeCode;
import com.apple.jingle.leghorn.util.TimeCodeUtil;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.math.BigInteger;
import java.util.AbstractList;
import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class ChaptersDocumentV2Impl
extends BaseChaptersDocument {
    private static final long serialVersionUID = 1057177401857886973L;
    final ChaptersDocument xmlBeansDocument;
    Boolean hasChapterImages = null;

    ChaptersDocumentV2Impl(ChaptersDocument xmlBeansDoc) throws ChaptersDocumentException {
        this.xmlBeansDocument = xmlBeansDoc;
        this.validate();
    }

    private void validate() throws ChaptersDocumentException {
        if (this.getChapters().size() < 1) {
            throw new ChaptersDocumentException("Chapters document has no chapters!");
        }
        if (this.getChapters().get(0).getStartTime().getTotalMilliseconds() != 0L) {
            throw new ChaptersDocumentException("First chapter should start at 0 seconds but instead starts at " + ((ChapterList.ChapterAdaptor)this.getChapters().get(0)).getStartTimeCodeString());
        }
        TimeCode currentChapter = null;
        String previousChapterTimeCodeString = "";
        for (ChaptersDocument.Chapter chapter : this.getChapters()) {
            if (null != currentChapter) {
                if (chapter.getStartTime().compareTo(currentChapter) == 0) {
                    throw new ChaptersDocumentException("Two chapters have the same time code: " + ((ChapterList.ChapterAdaptor)chapter).getStartTimeCodeString());
                }
                if (chapter.getStartTime().compareTo(currentChapter) < 0) {
                    throw new ChaptersDocumentException("Chapter mark starting at " + ((ChapterList.ChapterAdaptor)chapter).getStartTimeCodeString() + " occurs after chapter mark starting at " + previousChapterTimeCodeString);
                }
            }
            currentChapter = chapter.getStartTime();
            previousChapterTimeCodeString = ((ChapterList.ChapterAdaptor)chapter).getStartTimeCodeString();
            if (this.hasChapterImages == null) {
                if (chapter.hasImage()) {
                    this.hasChapterImages = Boolean.TRUE;
                    continue;
                }
                this.hasChapterImages = Boolean.FALSE;
                continue;
            }
            if ((!chapter.hasImage() || this.hasChapterImages.booleanValue()) && (chapter.hasImage() || !this.hasChapterImages.booleanValue())) continue;
            throw new RuntimeException("Some chapters have artwork and others don't; either all chapters must have artwork or none may");
        }
    }

    @Override
    public List<? extends ChaptersDocument.Chapter> getChapters() {
        return new ChapterList();
    }

    @Override
    public String getTimeCodeFormat() {
        String timeCodeString = this.xmlBeansDocument.getChapters().getTimecodeFormat();
        if (null == timeCodeString) {
            timeCodeString = "qt_text";
        }
        return timeCodeString;
    }

    protected final TimeCode parseTimeCode(String timeString) {
        String timeCodeString = this.getTimeCodeFormat();
        try {
            return TimeCodeUtil.parseTimeCode(timeString, timeCodeString);
        }
        catch (RuntimeException e) {
            throw new RuntimeException(e.getMessage() + " Unable to parse timecode from chapter starting at " + ((ChapterList.ChapterAdaptor)this.getChapters().get(this.getChapters().size() - 1)).getStartTimeCodeString());
        }
    }

    @Override
    public TimeCode getFirstTimeCode() {
        return ((ChapterList.ChapterAdaptor)this.getChapters().get(0)).getStartTime();
    }

    @Override
    public TimeCode getLastTimeCode() {
        return ((ChapterList.ChapterAdaptor)this.getChapters().get(this.getChapters().size() - 1)).getStartTime();
    }

    @Override
    public int getNumberOfChapters() {
        return this.getChapters().size();
    }

    @Override
    public boolean isImagesPresent() {
        return this.hasChapterImages;
    }

    @Override
    public void pareChaptersForCompressor(File f) throws IOException {
    }

    @Override
    public void rewriteTimeCode(File f, boolean dropFrameP) throws IOException {
    }

    @Override
    public List<File> thumbnailFilesInFileList(List<File> images) {
        return null;
    }

    @Override
    public List<? extends ChaptersDocument.Chapter> toChapterList(BigInteger totalDuration) throws InvalidMediaException {
        if (totalDuration.longValue() < this.getLastTimeCode().getMediaTime().getTotalMilliseconds()) {
            throw new InvalidMediaException("Final chapter marker [" + this.getLastTimeCode() + "] extends past duration " + totalDuration + "ms");
        }
        return new ChapterList(totalDuration);
    }

    @Override
    public void validateForItmsp(File itmspPath) throws ChaptersDocumentException {
    }

    @Override
    public void writeToFile(File file) throws IOException {
        throw new RuntimeException("Writing out multi-locale chapters files is not yet supported");
    }

    public void writeOutFilteredFileForLocale(String localeString, OutputStream os) throws IOException {
    }

    private class ChapterList
    extends AbstractList<ChaptersDocument.Chapter> {
        BigInteger duration;

        private ChapterList() {
        }

        private ChapterList(BigInteger duration) {
            this.duration = duration;
        }

        @Override
        public ChaptersDocument.Chapter get(int index) {
            return new ChapterAdaptor(ChaptersDocumentV2Impl.this.xmlBeansDocument.getChapters().getChapterArray()[index], index);
        }

        @Override
        public int size() {
            return ChaptersDocumentV2Impl.this.xmlBeansDocument.getChapters().getChapterArray().length;
        }

        class ChapterAdaptor
        extends BaseChaptersDocument.BaseChapter {
            final ChaptersDocument.Chapters.Chapter chapter;
            final int index;

            private ChapterAdaptor(ChaptersDocument.Chapters.Chapter chapter, int index) {
                this.chapter = chapter;
                this.index = index;
            }

            @Override
            public String getTitleForTx3g() {
                Map<String, String> localeTitleMap = this.getLocaleTitleMap();
                if (localeTitleMap.containsKey("en")) {
                    return localeTitleMap.get("en");
                }
                return localeTitleMap.values().iterator().next();
            }

            @Override
            public BigInteger getDuration() {
                if (!this.isFinalChapter()) {
                    return BigInteger.valueOf(ChapterList.this.get(this.index + 1).getStartTime().getMediaTime().timeBySubtractingTime(this.getStartTime().getMediaTime()).getTotalMilliseconds());
                }
                if (ChapterList.this.duration != null) {
                    return BigInteger.valueOf(ChapterList.this.duration.longValue() - this.getStartTime().getTotalMilliseconds());
                }
                throw new RuntimeException("Cannot determine duration for last chapter");
            }

            @Override
            public File getImageFile() {
                if (this.chapter.getArtworkFile() != null) {
                    return new File(this.chapter.getArtworkFile().getFileName());
                }
                return null;
            }

            @Override
            public Map<String, String> getLocaleTitleMap() {
                return new LocaleTitleMap();
            }

            @Override
            public TimeCode getStartTime() {
                return ChaptersDocumentV2Impl.this.parseTimeCode(this.chapter.getStartTime());
            }

            public String getStartTimeCodeString() {
                return this.chapter.getStartTime();
            }

            @Override
            public boolean isFinalChapter() {
                return this.index >= ChaptersDocumentV2Impl.this.xmlBeansDocument.getChapters().getChapterArray().length - 1;
            }

            @Override
            public TimeCode getImageTimeCode() {
                if (this.chapter.getArtworkTime() != null) {
                    return ChaptersDocumentV2Impl.this.parseTimeCode(this.chapter.getArtworkTime());
                }
                return null;
            }

            @Override
            public boolean hasImage() {
                return super.hasImage();
            }

            public class LocaleTitleMap
            extends AbstractMap<String, String> {
                @Override
                public Set<Map.Entry<String, String>> entrySet() {
                    return new AbstractSet<Map.Entry<String, String>>(){

                        @Override
                        public Iterator<Map.Entry<String, String>> iterator() {
                            return new Iterator<Map.Entry<String, String>>(){
                                int curpos = 0;

                                @Override
                                public boolean hasNext() {
                                    return this.curpos < ChapterAdaptor.this.chapter.getTitles().getTitleArray().length;
                                }

                                @Override
                                public Map.Entry<String, String> next() {
                                    return new MyEntry(ChapterAdaptor.this.chapter.getTitles().getTitleArray()[this.curpos++]);
                                }

                                @Override
                                public void remove() {
                                    ++this.curpos;
                                }

                                class MyEntry
                                implements Map.Entry<String, String> {
                                    ChaptersDocument.Chapters.Chapter.Titles.Title title;

                                    MyEntry(ChaptersDocument.Chapters.Chapter.Titles.Title title) {
                                        this.title = title;
                                    }

                                    @Override
                                    public String getKey() {
                                        return this.title.getLocale();
                                    }

                                    @Override
                                    public String getValue() {
                                        return this.title.getStringValue();
                                    }

                                    @Override
                                    public String setValue(String value) {
                                        throw new RuntimeException("Chapter title markers are read-only");
                                    }
                                }
                            };
                        }

                        @Override
                        public int size() {
                            return ChapterAdaptor.this.chapter.getTitles().getTitleArray().length;
                        }
                    };
                }
            }
        }
    }
}

