/*
 * Decompiled with CFR 0.152.
 */
package com.apple.jingle.leghorn.chapters;

import com.apple.jingle.leghorn.chapters.BaseChaptersDocument;
import com.apple.jingle.leghorn.chapters.ChaptersDocument;
import com.apple.jingle.leghorn.chapters.ChaptersDocumentException;
import com.apple.jingle.leghorn.chapters.ChaptersDocumentParseException;
import com.apple.jingle.leghorn.chapters.ChaptersPictureFileException;
import com.apple.jingle.leghorn.media.exceptions.InvalidMediaException;
import com.apple.jingle.leghorn.timecode.MediaTime;
import com.apple.jingle.leghorn.timecode.SMPTETimeCode;
import com.apple.jingle.leghorn.timecode.TimeCode;
import com.apple.jingle.media.foundation.util.XMLUtil;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.math.BigInteger;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import noNamespace.TitleDocument;
import org.apache.xmlbeans.XmlException;
import org.apache.xmlbeans.XmlObject;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.xml.sax.SAXException;

public class ChaptersDocumentV1Impl
extends BaseChaptersDocument {
    private static final long serialVersionUID = -5806151072226000267L;
    XmlObject chaptersDomXmlObject;
    boolean imagesPresent;

    public List<ChapterImpl> toChapterList(BigInteger totalDuration) throws InvalidMediaException {
        List<ChapterImpl> chapters = this.getChapters();
        ChapterImpl lastChapter = chapters.get(chapters.size() - 1);
        BigInteger duration = totalDuration.subtract(lastChapter.startTime);
        if (duration.compareTo(new BigInteger("0")) <= 0) {
            throw new InvalidMediaException("Chapters cannot run longer than the video..  The last chapter starts at" + lastChapter.startTime.toString() + ", while the total video duration is " + totalDuration.toString() + ",");
        }
        lastChapter.duration = duration;
        return chapters;
    }

    @Override
    public void writeToFile(File file) throws IOException {
        BufferedOutputStream out = new BufferedOutputStream(new FileOutputStream(file));
        byte[] data = this.chaptersDomXmlObject.toString().getBytes();
        out.write(data, 0, data.length);
        out.flush();
        out.close();
    }

    ChaptersDocumentV1Impl(byte[] byteBuffer, boolean replaceTitles) throws IllegalArgumentException, IOException, ParserConfigurationException, SAXException, XmlException, ChaptersDocumentException {
        DocumentBuilderFactory dbf = XMLUtil.getDocumentBuilderDisabledXXE();
        dbf.setAttribute("http://java.sun.com/xml/jaxp/properties/schemaLanguage", "http://www.w3.org/2001/XMLSchema");
        dbf.setAttribute("http://java.sun.com/xml/jaxp/properties/schemaSource", ChaptersDocumentV1Impl.getSchemaFilePath());
        dbf.setNamespaceAware(true);
        dbf.setValidating(true);
        BaseChaptersDocument.ChaptersXMLErrorHandler errorHandler = new BaseChaptersDocument.ChaptersXMLErrorHandler();
        DocumentBuilder db = dbf.newDocumentBuilder();
        db.setErrorHandler(errorHandler);
        Document document = db.parse(new ByteArrayInputStream(byteBuffer));
        if (errorHandler.getExceptions().size() > 0) {
            throw new ChaptersDocumentParseException("Chapters document was not valid as per schema", errorHandler.getExceptions().get(0));
        }
        XmlObject rootNode = XmlObject.Factory.parse(document);
        XmlObject[] chapterXmlObjects = rootNode.selectPath("//chapters/chapter");
        SMPTETimeCode firstChapterTimeCode = SMPTETimeCode.parseTimeCode(chapterXmlObjects[0].getDomNode().getAttributes().getNamedItem("starttime").getNodeValue() + ":00");
        if (firstChapterTimeCode.getMediaTime().getSampleCount() > 0L) {
            throw new ChaptersDocumentParseException("First chapter encountered should begin at 00:00:00 but instead begins at " + firstChapterTimeCode);
        }
        if (replaceTitles) {
            ChaptersDocumentV1Impl.replaceChapterTitlesWithChapterNumbers(chapterXmlObjects);
        }
        BaseChaptersDocument.ChaptersXMLValidationContext context = new BaseChaptersDocument.ChaptersXMLValidationContext();
        ChaptersDocumentV1Impl.validateTitleAndPictureNames(chapterXmlObjects[0], context);
        SMPTETimeCode previousTimeCode = firstChapterTimeCode;
        for (int i = 1; i < chapterXmlObjects.length; ++i) {
            SMPTETimeCode timeCode = SMPTETimeCode.parseTimeCode(chapterXmlObjects[i].getDomNode().getAttributes().getNamedItem("starttime").getNodeValue() + ":00");
            if (previousTimeCode.getMediaTime().compareTo(timeCode.getMediaTime()) != -1) {
                throw new ChaptersDocumentParseException("Chapters are out of order.  The chapter at time code " + timeCode + " occurs earlier in the file than the chapter at time code " + previousTimeCode + ".");
            }
            ChaptersDocumentV1Impl.validateTitleAndPictureNames(chapterXmlObjects[i], context);
        }
        this.imagesPresent = context.isImagesPresent();
        this.chaptersDomXmlObject = rootNode;
    }

    public List<ChapterImpl> getChapters() {
        XmlObject rootNode = this.chaptersDomXmlObject;
        XmlObject[] chapterXmlObjects = rootNode.selectPath("//chapters/chapter");
        ArrayList<ChapterImpl> chapters = new ArrayList<ChapterImpl>();
        for (XmlObject chapXml : chapterXmlObjects) {
            ChapterImpl chapter = ChapterImpl.fromChapterXmlObject(chapXml);
            chapters.add(chapter);
        }
        for (int i = 0; i < chapters.size() - 1; ++i) {
            ChapterImpl thisChapter = (ChapterImpl)chapters.get(i);
            ChaptersDocument.Chapter nextChapter = (ChaptersDocument.Chapter)chapters.get(i + 1);
            thisChapter.setDuration(nextChapter.getStartTime().getTotalMilliseconds() - thisChapter.getStartTime().getTotalMilliseconds());
        }
        ((ChapterImpl)chapters.get(chapters.size() - 1)).setFinalChapter(true);
        return chapters;
    }

    static void replaceChapterTitlesWithChapterNumbers(XmlObject[] chapterXmlObjects) throws ChaptersDocumentParseException {
        for (int i = 0; i < chapterXmlObjects.length; ++i) {
            ChaptersDocumentV1Impl.replaceChapterTitleWithInteger(chapterXmlObjects[i], i + 1);
        }
    }

    private static void replaceChapterTitleWithInteger(XmlObject chapterXmlObject, Integer chapterNumber) throws ChaptersDocumentParseException {
        Node titleNode = chapterXmlObject.selectPath("./title")[0].getDomNode().getFirstChild();
        if (titleNode == null) {
            titleNode = (Node)TitleDocument.Factory.newInstance();
            chapterXmlObject.getDomNode().appendChild(titleNode);
        }
        titleNode.setNodeValue(chapterNumber.toString());
    }

    @Override
    public void validateForItmsp(File itmspPath) throws ChaptersDocumentException {
        XmlObject[] chapterXmlObjects = this.chaptersDomXmlObject.selectPath("/chapters/chapter[picture]");
        for (int i = 0; i < chapterXmlObjects.length; ++i) {
            Node pictureNode = chapterXmlObjects[i].selectPath("./picture")[0].getDomNode().getFirstChild();
            this.validateChaptersPictureFileContent(new File(itmspPath, pictureNode.getNodeValue()));
        }
    }

    private void validateChaptersPictureFileContent(File chaptersPictureFile) throws ChaptersPictureFileException {
        if (!chaptersPictureFile.exists()) {
            throw new ChaptersPictureFileException("Picture " + chaptersPictureFile.getName() + " referenced from chapters XML could not be found in " + chaptersPictureFile.getParent());
        }
    }

    static void validateTitleAndPictureNames(XmlObject chapterXmlObject, BaseChaptersDocument.ChaptersXMLValidationContext context) throws ChaptersDocumentException {
        Node titleNode = chapterXmlObject.selectPath("./title")[0].getDomNode().getFirstChild();
        XmlObject[] pictureNodes = chapterXmlObject.selectPath("./picture");
        Node pictureNode = null;
        if (pictureNodes.length > 0) {
            pictureNode = chapterXmlObject.selectPath("./picture")[0].getDomNode().getFirstChild();
        }
        if (titleNode == null || titleNode.getNodeValue().trim().equals("")) {
            throw new ChaptersDocumentParseException("Empty titles not allowed in chapters XML files");
        }
        if (pictureNode == null || pictureNode.getNodeValue().trim().equals("")) {
            if (context.isImagesPresent() == null) {
                context.setImagesPresent(Boolean.FALSE);
            } else if (context.isImagesPresent() == Boolean.TRUE) {
                throw new ChaptersDocumentParseException("Empty picture names not allowed in chapters XML files  when non-empty picture names were already encountered");
            }
        } else {
            if (context.isImagesPresent() == null) {
                context.setImagesPresent(Boolean.TRUE);
            } else if (context.isImagesPresent() == Boolean.FALSE) {
                throw new ChaptersDocumentParseException("Non-empty picture names not allowed in chapters XML files when empty picture names were already encountered.");
            }
            if (!pictureNode.getNodeValue().trim().endsWith(".jpg") && !pictureNode.getNodeValue().trim().endsWith(".jpeg")) {
                throw new ChaptersPictureFileException("Referenced picture \"" + pictureNode.getNodeValue().trim() + "\" does not end in \".jpg\" or \".jpeg\"");
            }
            if (pictureNode.getNodeValue().indexOf("/") != -1) {
                throw new ChaptersDocumentParseException("Picture names in chapters XML files must not contain slashes");
            }
        }
    }

    private static ClassLoader getClassLoader() {
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        if (classLoader == null) {
            classLoader = ChaptersDocumentV1Impl.class.getClassLoader();
        }
        return classLoader;
    }

    static String getSchemaFilePath() throws IOException {
        File ttXsdFile;
        String chaptersXsdLocation = System.getProperty("com.apple.jingle.contentbusinesslogic.chapters.chaptersXsdLocation");
        if (chaptersXsdLocation != null && (ttXsdFile = new File(chaptersXsdLocation, "content-chaptering.xsd")).exists()) {
            return "file:" + ttXsdFile.getCanonicalPath();
        }
        URL tmpUrl = ChaptersDocumentV1Impl.getClassLoader().getResource("schemaorg_apache_xmlbeans/src/content-chaptering.xsd");
        if (tmpUrl != null) {
            return ChaptersDocumentV1Impl.getClassLoader().getResource("schemaorg_apache_xmlbeans/src/content-chaptering.xsd").toString();
        }
        throw new IllegalStateException("content chaptering .xsd files could not be found, so I can't validate chapters XML files.  Please set system property \"com.apple.jingle.contentbusinesslogic.chapters.chaptersXsdLocation\" to the toplevel directory containing the schema file(s).");
    }

    @Override
    public SMPTETimeCode getFirstTimeCode() {
        return SMPTETimeCode.parseTimeCode("00:00:00:00");
    }

    @Override
    public SMPTETimeCode getLastTimeCode() {
        XmlObject[] chapterXmlObjects = this.chaptersDomXmlObject.selectPath("//chapters/chapter");
        XmlObject lastTimeCode = chapterXmlObjects[chapterXmlObjects.length - 1];
        return SMPTETimeCode.parseTimeCode(lastTimeCode.getDomNode().getAttributes().getNamedItem("starttime").getNodeValue() + ":00");
    }

    @Override
    public int getNumberOfChapters() {
        return this.chaptersDomXmlObject.selectPath("//chapters/chapter").length;
    }

    @Override
    public boolean isImagesPresent() {
        return this.imagesPresent;
    }

    @Override
    public void rewriteTimeCode(File f, boolean dropFrameP) throws IOException {
        XmlObject newChaptersXml = this.chaptersDomXmlObject.copy();
        XmlObject[] chapterXmlObjects = newChaptersXml.selectPath("//chapters/chapter");
        for (int i = 0; i < chapterXmlObjects.length; ++i) {
            Node n = chapterXmlObjects[i].getDomNode().getAttributes().getNamedItem("starttime");
            n.setNodeValue(n.getNodeValue() + (dropFrameP ? ";" : ":") + "00");
        }
        newChaptersXml.save(f);
    }

    @Override
    public void pareChaptersForCompressor(File f) throws IOException {
        XmlObject newChaptersXml = this.chaptersDomXmlObject.copy();
        XmlObject[] chapterXmlObjects = newChaptersXml.selectPath("//chapters/chapter");
        for (int i = 0; i < chapterXmlObjects.length; ++i) {
            Node title = chapterXmlObjects[i].selectPath("./title")[0].getDomNode();
            title.getFirstChild().setNodeValue("chapter " + (i + 1));
            Node chapterNode = chapterXmlObjects[i].getDomNode();
            XmlObject[] nodesToRemove = chapterXmlObjects[i].selectPath("./picture");
            for (int j = 0; j < nodesToRemove.length; ++j) {
                chapterNode.removeChild(nodesToRemove[j].getDomNode());
            }
        }
        newChaptersXml.save(f);
    }

    @Override
    public String getTimeCodeFormat() {
        return "qt_text";
    }

    @Override
    public List<File> thumbnailFilesInFileList(List<File> images) {
        ArrayList<File> thumbnails = new ArrayList<File>();
        block0: for (ChaptersDocument.Chapter chapter : this.getChapters()) {
            for (File imageFile : images) {
                if (!chapter.isCorrectChapterImageFile(imageFile)) continue;
                thumbnails.add(imageFile);
                continue block0;
            }
        }
        return thumbnails;
    }

    public static String hoursMinutesSecondsString(SMPTETimeCode t) {
        return String.format("%02d:%02d:%02d", t.getHoursComponent(), t.getMinutesComponent(), t.getSecondsComponent());
    }

    public static class ChapterImpl
    extends BaseChaptersDocument.BaseChapter {
        private BigInteger startTime;
        private BigInteger duration;
        private String title;
        private File imageFile;
        public boolean finalChapter = false;

        @Override
        public File getImageFile() {
            return this.imageFile;
        }

        public void setImageFile(File newImageFile) {
            this.imageFile = newImageFile;
        }

        @Override
        public boolean isFinalChapter() {
            return this.finalChapter;
        }

        public void setFinalChapter(boolean lastChapter) {
            this.finalChapter = lastChapter;
        }

        @Override
        public TimeCode getStartTime() {
            return new SMPTETimeCode(new MediaTime(this.startTime.longValue(), 1000L).timeByScalingSampleRate(SMPTETimeCode.getDefaultFrameRate()), SMPTETimeCode.Mode.nonDrop);
        }

        @Override
        public TimeCode getImageTimeCode() {
            return null;
        }

        public void setStartTime(BigInteger startTime) {
            this.startTime = startTime;
        }

        @Override
        public BigInteger getDuration() {
            return this.duration;
        }

        public void setDuration(long duration) {
            this.duration = BigInteger.valueOf(duration);
        }

        public void setDuration(BigInteger duration) {
            this.duration = duration;
        }

        public String getTitle() {
            return this.title;
        }

        public void setTitle(String title) {
            this.title = title;
        }

        public static ChapterImpl fromChapterXmlObject(XmlObject thisChap) {
            String filename;
            Node pictureNode;
            XmlObject[] pictureNodes;
            Node titleNode;
            ChapterImpl chapter = new ChapterImpl();
            String thisStart = thisChap.getDomNode().getAttributes().getNamedItem("starttime").getNodeValue();
            chapter.setStartTime(BaseChaptersDocument.parseTimeString(thisStart));
            XmlObject[] titleNodes = thisChap.selectPath("./title");
            if (titleNodes.length > 0 && (titleNode = titleNodes[0].getDomNode().getFirstChild()) != null) {
                String title = titleNode.getNodeValue();
                chapter.setTitle(title != null ? title : "");
            }
            if ((pictureNodes = thisChap.selectPath("./picture")).length > 0 && (pictureNode = pictureNodes[0].getDomNode().getFirstChild()) != null && (filename = pictureNode.getNodeValue()) != null && !filename.equals("")) {
                chapter.setImageFile(new File(filename));
            }
            return chapter;
        }

        @Override
        public String getTitleForTx3g() {
            return this.getTitle();
        }

        @Override
        public Map<String, String> getLocaleTitleMap() {
            return Collections.singletonMap("en", this.getTitle());
        }
    }
}

