/*
 * Decompiled with CFR 0.152.
 */
package com.apple.jingle.leghorn.chapters;

import com.apple.iTunes.x2009.x10.x15.contentChaptering.ChaptersDocument;
import com.apple.jingle.leghorn.chapters.ChaptersDocument;
import com.apple.jingle.leghorn.chapters.ChaptersDocumentException;
import com.apple.jingle.leghorn.chapters.ChaptersDocumentParseException;
import com.apple.jingle.leghorn.chapters.ChaptersDocumentV1Impl;
import com.apple.jingle.leghorn.chapters.ChaptersDocumentV2Impl;
import com.apple.jingle.leghorn.media.exceptions.InvalidMediaException;
import com.apple.jingle.leghorn.timecode.SMPTETimeCode;
import com.apple.jingle.leghorn.timecode.TimeCode;
import com.apple.jingle.media.foundation.io.SeekableDataInput;
import com.apple.jingle.media.foundation.util.XMLUtil;
import com.google.common.base.Charsets;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.math.BigInteger;
import java.util.LinkedList;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerException;
import org.apache.log4j.Logger;
import org.apache.xmlbeans.XmlException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.ProcessingInstruction;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public abstract class BaseChaptersDocument
implements ChaptersDocument {
    private static final long serialVersionUID = -5018032070558219493L;
    public static final String DEFAULT_LOCALE_CODE = "eng";
    public static final BigInteger ONE_SECOND = new BigInteger("1000");
    public static final BigInteger ONE_MINUTE = ONE_SECOND.multiply(new BigInteger("60"));
    public static final BigInteger ONE_HOUR = ONE_MINUTE.multiply(new BigInteger("60"));
    private static final Logger logger = Logger.getLogger(ChaptersDocumentV1Impl.class);

    public static BigInteger parseTimeString(String timeString) {
        String[] hms = timeString.split(":");
        BigInteger parsedTime = new BigInteger(hms[0]).multiply(ONE_HOUR);
        parsedTime = parsedTime.add(new BigInteger(hms[1]).multiply(ONE_MINUTE));
        parsedTime = parsedTime.add(new BigInteger(hms[2]).multiply(ONE_SECOND));
        return parsedTime;
    }

    public static ChaptersDocument createWithNumericTitlesFromChaptersXML(File f) throws IOException, ChaptersDocumentException {
        return BaseChaptersDocument.createWithNumericTitlesFromChaptersXML(new FileInputStream(f));
    }

    public static ChaptersDocument createWithNumericTitlesFromChaptersXML(InputStream is) throws IOException, ChaptersDocumentException {
        return BaseChaptersDocument.createFromChaptersXML(is, true);
    }

    public static ChaptersDocument createFromChaptersXML(File f) throws IOException, ChaptersDocumentException {
        return BaseChaptersDocument.createFromChaptersXML(new FileInputStream(f));
    }

    public static ChaptersDocument createFromChaptersXML(InputStream is) throws IOException, ChaptersDocumentException {
        return BaseChaptersDocument.createFromChaptersXML(is, false);
    }

    public static ChaptersDocument createFromChaptersXML(SeekableDataInput sdi) throws IOException, ChaptersDocumentException {
        return BaseChaptersDocument.createFromChaptersXML(sdi, false);
    }

    public static ChaptersDocument createFromChaptersXML(SeekableDataInput sdi, boolean replaceTitles) throws IOException, ChaptersDocumentException {
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            int byteBufferSize = 8192;
            byte[] byteBuffer = new byte[byteBufferSize];
            while (sdi.getFilePointer() < sdi.length()) {
                long bytesLeft = sdi.length() - sdi.getFilePointer();
                if (bytesLeft > (long)byteBufferSize) {
                    sdi.readFully(byteBuffer);
                    baos.write(byteBuffer, 0, byteBufferSize);
                    continue;
                }
                sdi.readFully(byteBuffer, 0, (int)bytesLeft);
                baos.write(byteBuffer, 0, (int)bytesLeft);
            }
            byteBuffer = baos.toByteArray();
            try {
                com.apple.iTunes.x2009.x10.x15.contentChaptering.ChaptersDocument v2Document = ChaptersDocument.Factory.parse((String)new String(byteBuffer, "UTF-8"));
                if (v2Document.validate()) {
                    return new ChaptersDocumentV2Impl(v2Document);
                }
            }
            catch (Exception e) {
                logger.info((Object)"Failed to parse chapters using v2 template", (Throwable)e);
            }
            return new ChaptersDocumentV1Impl(byteBuffer, replaceTitles);
        }
        catch (SAXException saxException) {
            throw new ChaptersDocumentParseException("General exception parsing chapters document", saxException);
        }
        catch (ParserConfigurationException pce) {
            throw new RuntimeException("Caught ParserConfigurationException while parsing chapters document", pce);
        }
        catch (XmlException xe) {
            throw new ChaptersDocumentParseException("General exception parsing chapters document", xe);
        }
    }

    private static ChaptersDocument createFromChaptersXML(InputStream is, boolean replaceTitles) throws IOException, ChaptersDocumentException {
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            byte[] byteBuffer = new byte[8192];
            int nRead = 0;
            while ((nRead = is.read(byteBuffer)) > 0) {
                baos.write(byteBuffer, 0, nRead);
            }
            byteBuffer = baos.toByteArray();
            try {
                com.apple.iTunes.x2009.x10.x15.contentChaptering.ChaptersDocument v2Document = ChaptersDocument.Factory.parse((String)new String(byteBuffer, "UTF-8"));
                if (v2Document.validate()) {
                    return new ChaptersDocumentV2Impl(v2Document);
                }
            }
            catch (Exception e) {
                // empty catch block
            }
            return new ChaptersDocumentV1Impl(byteBuffer, replaceTitles);
        }
        catch (SAXException saxException) {
            throw new ChaptersDocumentParseException("General exception parsing chapters document", saxException);
        }
        catch (ParserConfigurationException pce) {
            throw new RuntimeException("Caught ParserConfigurationException while parsing chapters document", pce);
        }
        catch (XmlException xe) {
            throw new ChaptersDocumentParseException("General exception parsing chapters document", xe);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void writeToText3gFile(File file, BigInteger totalDuration) throws IOException, InvalidMediaException, ParserConfigurationException, TransformerException {
        try (FileOutputStream stream = new FileOutputStream(file);){
            OutputStreamWriter outputStreamWriter = new OutputStreamWriter((OutputStream)stream, Charsets.UTF_8);
            XMLUtil.serializeNode((Node)this.toText3gTrackDocument(totalDuration), (int)0, (Writer)outputStreamWriter);
            outputStreamWriter.close();
        }
    }

    @Override
    public String toText3gString(BigInteger totalDuration) throws InvalidMediaException, ParserConfigurationException, IOException, TransformerException {
        return XMLUtil.nodeToString((Node)this.toText3gTrackDocument(totalDuration), (int)0);
    }

    @Override
    public Document toText3gTrackDocument(BigInteger totalDuration) throws InvalidMediaException, ParserConfigurationException {
        return this.toText3gTrackDocument(totalDuration, DEFAULT_LOCALE_CODE);
    }

    @Override
    public Document toText3gTrackDocument(BigInteger totalDuration, String localeCode) throws InvalidMediaException, ParserConfigurationException {
        DocumentBuilderFactory documentBuilderFactory = XMLUtil.getDocumentBuilderDisabledXXE();
        DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
        Document text3G = documentBuilder.newDocument();
        ProcessingInstruction qtProcessingInstruction = text3G.createProcessingInstruction("quicktime", "type=\"application/x-quicktime-tx3g\"");
        text3G.appendChild(qtProcessingInstruction);
        Element root = text3G.createElement("text3GTrack");
        text3G.appendChild(root);
        root.setAttribute("trackWidth", "0.0");
        root.setAttribute("trackHeight", "0.0");
        root.setAttribute("timeScale", "1000");
        root.setAttribute("language", localeCode);
        for (ChaptersDocument.Chapter chapter : this.toChapterList(totalDuration)) {
            root.appendChild(((BaseChapter)chapter).toSampleElement(text3G));
        }
        return text3G;
    }

    public static String getGeneratedArtworkName(String timeCode) {
        return "GenerateChapter-" + timeCode + ".jpg";
    }

    @Override
    public String getFrameRateFormatString() {
        TimeCode tc = this.getFirstTimeCode();
        SMPTETimeCode smpteTC = null;
        smpteTC = tc instanceof SMPTETimeCode ? (SMPTETimeCode)tc : SMPTETimeCode.parseTimeCode(tc.toUserString(), "qt_text");
        return smpteTC.getFrameRateFormatString();
    }

    public static void main(String[] args) {
        try {
            ChaptersDocument chaptersDocument = BaseChaptersDocument.createFromChaptersXML(new File(args[0]));
            chaptersDocument.writeToText3gFile(new File(args[0] + ".texml"), BigInteger.valueOf(10625000L));
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    protected static class ChaptersXMLValidationContext {
        public Boolean imagesPresent = null;

        protected ChaptersXMLValidationContext() {
        }

        public Boolean isImagesPresent() {
            return this.imagesPresent;
        }

        public void setImagesPresent(Boolean imagesPresent) {
            this.imagesPresent = imagesPresent;
        }
    }

    protected static class ChaptersXMLErrorHandler
    implements ErrorHandler {
        private List<SAXParseException> exceptions = new LinkedList<SAXParseException>();

        protected ChaptersXMLErrorHandler() {
        }

        @Override
        public void error(SAXParseException exception) throws SAXException {
            this.exceptions.add(exception);
        }

        @Override
        public void fatalError(SAXParseException exception) throws SAXException {
            this.exceptions.add(exception);
        }

        @Override
        public void warning(SAXParseException exception) throws SAXException {
        }

        public List<SAXParseException> getExceptions() {
            return this.exceptions;
        }
    }

    public static abstract class BaseChapter
    implements ChaptersDocument.Chapter {
        protected Element toSampleElement(Document text3G) {
            Element sample = text3G.createElement("sample");
            sample.setAttribute("duration", this.getDuration().toString());
            sample.setAttribute("keyframe", "true");
            sample.appendChild(this.childDescriptionElement(text3G));
            sample.appendChild(this.childSampleDataElement(text3G));
            return sample;
        }

        private Element childSampleDataElement(Document text3G) {
            Element sampleData = text3G.createElement("sampleData");
            sampleData.setAttribute("targetEncoding", "utf8");
            sampleData.appendChild(this.childTextElement(text3G));
            return sampleData;
        }

        private Element childDescriptionElement(Document text3G) {
            Element description = text3G.createElement("description");
            description.setAttribute("horizontalJustification", "Left");
            description.setAttribute("verticalJustification", "Top");
            description.setAttribute("backgroundColor", "100%, 100%, 100%, 100%");
            description.setAttribute("format", "tx3g");
            description.appendChild(this.childDefaultTextBoxElement(text3G));
            description.appendChild(this.childFontTableElement(text3G));
            description.appendChild(this.childSharedStylesElement(text3G));
            return description;
        }

        private Element childSharedStylesElement(Document text3G) {
            Element sharedStyles = text3G.createElement("sharedStyles");
            sharedStyles.appendChild(this.childStyleElement(text3G));
            return sharedStyles;
        }

        private Element childStyleElement(Document text3G) {
            Element style = text3G.createElement("style");
            style.setAttribute("id", "1");
            style.setTextContent("{font-table: 1}{font-size: 13}{font-style: normal}{font-weight: normal}{text-decoration: normal}{color: 0%, 0%, 0%, 100%}");
            return style;
        }

        private Element childDefaultTextBoxElement(Document text3G) {
            Element defaultTextBox = text3G.createElement("defaultTextBox");
            defaultTextBox.setAttribute("width", "0");
            defaultTextBox.setAttribute("height", "0");
            return defaultTextBox;
        }

        private Element childFontTableElement(Document text3G) {
            Element fontTable = text3G.createElement("fontTable");
            fontTable.appendChild(this.childFontElement(text3G));
            return fontTable;
        }

        private Element childFontElement(Document text3g) {
            Element font = text3g.createElement("font");
            font.setAttribute("id", "1");
            font.setAttribute("name", "Lucida Grande");
            return font;
        }

        private Element childTextElement(Document text3G) {
            Element text = text3G.createElement("text");
            text.setAttribute("styleID", "1");
            text.setTextContent(this.getTitleForTx3g());
            return text;
        }

        public abstract String getTitleForTx3g();

        @Override
        public boolean isCorrectChapterImageFile(File candidate) {
            return candidate != null && candidate.getName() != null && !candidate.getName().equals("") && this.getImageFile() != null && this.getImageFile().getName() != null && candidate.getName().equals(this.getImageFile().getName());
        }

        @Override
        public boolean hasImage() {
            return this.getImageFile() != null || this.getImageTimeCode() != null;
        }
    }
}

