/*
 * Decompiled with CFR 0.152.
 */
package com.apple.jingle.leghorn.bitstream.prores;

import com.apple.jingle.leghorn.bitstream.prores.ProresPicture;
import com.apple.jingle.leghorn.quicktime.BitstreamReader;
import com.apple.jingle.media.foundation.io.SeekableDataInput;
import java.io.IOException;

public class ProresSlice {
    ProresPicture _picture;
    int _ii;
    int _jj;
    int _headerSize;
    byte _reserved0;
    int _quantization_index;
    int _coded_size_y_data = 0;
    int _coded_size_cb_data = 0;
    int _coded_size_cr_data = 0;

    ProresSlice(ProresPicture picture, int ii, int jj) {
        this._picture = picture;
        this._ii = ii;
        this._jj = jj;
    }

    void parse(SeekableDataInput bits) throws IOException {
        int tmp = BitstreamReader.readU8(bits);
        this._headerSize = tmp >> 3 & 0x1F;
        this._reserved0 = (byte)(tmp & 7);
        this._quantization_index = BitstreamReader.readU8(bits);
        this._coded_size_y_data = BitstreamReader.readU16(bits);
        this._coded_size_cb_data = BitstreamReader.readU16(bits);
        if (this._picture.alpha_channel_type() != 0) {
            this._coded_size_cr_data = BitstreamReader.readU16(bits);
        }
        int numYBlocks = 4 * this._picture.slice_size_in_mb(this._jj);
        int numCBlocks = 0;
        numCBlocks = this._picture.chroma_format() == 3 ? 4 * this._picture.slice_size_in_mb(this._jj) : 2 * this._picture.slice_size_in_mb(this._jj);
        int codedYDataSize = this._coded_size_y_data;
        int codedCBDataSize = this._coded_size_cb_data;
        int codedCRDataSize = 0;
        codedCRDataSize = this._picture.alpha_channel_type() != 0 ? this._coded_size_cr_data : this._picture.coded_size_of_slice(this._ii, this._jj) - this._headerSize - codedYDataSize - codedCBDataSize;
        this.scannedCoef(bits, numYBlocks, codedYDataSize);
        this.scannedCoef(bits, numCBlocks, codedCBDataSize);
        this.scannedCoef(bits, numCBlocks, codedCRDataSize);
        if (this._picture.alpha_channel_type() != 0) {
            int sliceVerticalSize = 0;
            sliceVerticalSize = this._ii < this._picture.heightInMB() - 1 ? 16 : this._picture.vsize() - 16 * (this._picture.heightInMB() - 1);
            int numAlphaValues = 16 * this._picture.slice_size_in_mb(this._jj) * sliceVerticalSize;
            this.scannedAlpha(bits, numAlphaValues);
        }
    }

    void scannedCoef(SeekableDataInput bits, int numBlocks, int dataSize) {
    }

    void scannedAlpha(SeekableDataInput bits, int numValues) {
    }

    public String toString() {
        return "ProresSlice{, _ii=" + this._ii + ", _jj=" + this._jj + ", _headerSize=" + this._headerSize + ", _reserved0=" + this._reserved0 + ", _quantization_index=" + this._quantization_index + ", _coded_size_y_data=" + this._coded_size_y_data + ", _coded_size_cb_data=" + this._coded_size_cb_data + ", _coded_size_cr_data=" + this._coded_size_cr_data + '}';
    }
}

