/*
 * Decompiled with CFR 0.152.
 */
package com.apple.jingle.leghorn.bitstream.prores;

import com.apple.jingle.leghorn.bitstream.prores.ProresFrame;
import com.apple.jingle.leghorn.bitstream.prores.ProresSlice;
import com.apple.jingle.leghorn.quicktime.BitstreamReader;
import com.apple.jingle.media.foundation.io.SeekableDataInput;
import com.google.common.primitives.Ints;
import java.io.DataInput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;

public class ProresPicture {
    ProresFrame _frame;
    int _headerSize;
    byte _reserved0;
    long _picture_size;
    int _deprecated_number_of_slices;
    byte _reserved1;
    byte _log2_desired_slice_size_in_mb;
    byte _reserved2;
    int[][] _coded_size_of_slice;
    ProresSlice[][] _slices;
    int _heightInMB;
    int _widthInMB;
    int _slicesPerMBrow;
    int[] _slice_size_in_mb;

    ProresPicture(ProresFrame frame) {
        this._frame = frame;
    }

    void parse(SeekableDataInput bits) throws IOException {
        int jj;
        int ii;
        int tmp = BitstreamReader.readU8(bits);
        this._headerSize = tmp >> 3 & 0x1F;
        this._reserved0 = (byte)(tmp & 7);
        this._picture_size = BitstreamReader.readU32((DataInput)bits);
        this._deprecated_number_of_slices = BitstreamReader.readU16(bits);
        tmp = BitstreamReader.readU8(bits);
        this._reserved2 = (byte)(tmp & 0xF);
        this._log2_desired_slice_size_in_mb = (byte)((tmp >>= 4) & 3);
        this._reserved1 = (byte)((tmp >>= 2) & 3);
        tmp >>= 2;
        this._heightInMB = (int)Math.ceil((double)this._frame.hsize() / 16.0);
        this._widthInMB = (int)Math.ceil((double)this._frame.vsize() / 16.0);
        int desiredLineSizeInMB = 1 << this._log2_desired_slice_size_in_mb;
        int remaining = this._widthInMB;
        ArrayList<Integer> working = new ArrayList<Integer>();
        this._slicesPerMBrow = 0;
        do {
            int cur = remaining / desiredLineSizeInMB;
            for (int ii2 = 0; ii2 < cur; ++ii2) {
                working.add(desiredLineSizeInMB);
            }
            this._slicesPerMBrow += cur;
        } while ((remaining %= (desiredLineSizeInMB >>= 1)) != 0);
        this._slice_size_in_mb = Ints.toArray(working);
        this._coded_size_of_slice = new int[this._heightInMB][this._slicesPerMBrow];
        for (ii = 0; ii < this._heightInMB; ++ii) {
            for (jj = 0; jj < this._slicesPerMBrow; ++jj) {
                this._coded_size_of_slice[ii][jj] = BitstreamReader.readU16(bits);
            }
        }
        this._slices = new ProresSlice[this._heightInMB][this._slicesPerMBrow];
        for (ii = 0; ii < this._heightInMB; ++ii) {
            for (jj = 0; jj < this._slicesPerMBrow; ++jj) {
                this._slices[ii][jj] = new ProresSlice(this, ii, jj);
                this._slices[ii][jj].parse(bits);
            }
        }
    }

    public byte alpha_channel_type() {
        return this._frame.alpha_channel_type();
    }

    public byte chroma_format() {
        return this._frame.chroma_format();
    }

    public int slice_size_in_mb(int idx) {
        return this._slice_size_in_mb[idx];
    }

    public int coded_size_of_slice(int i, int j) {
        return this._coded_size_of_slice[i][j];
    }

    public int heightInMB() {
        return this._heightInMB;
    }

    public int vsize() {
        return this._frame.vsize();
    }

    public String toString() {
        return "ProresPicture{headerSize=" + this._headerSize + ", reserved0=" + this._reserved0 + ", picture_size=" + this._picture_size + ", deprecated_number_of_slices=" + this._deprecated_number_of_slices + ", reserved1=" + this._reserved1 + ", log2_desired_slice_size_in_mb=" + this._log2_desired_slice_size_in_mb + ", reserved2=" + this._reserved2 + ", _heightInMB=" + this._heightInMB + ",\n_slices=" + Arrays.toString((Object[])this._slices) + '}';
    }
}

