/*
 * Decompiled with CFR 0.152.
 */
package com.apple.jingle.leghorn.bitstream.prores;

import com.apple.jingle.leghorn.bitstream.prores.ProresPicture;
import com.apple.jingle.leghorn.quicktime.BitstreamReader;
import com.apple.jingle.media.foundation.io.SeekableDataInput;
import java.io.DataInput;
import java.io.IOException;
import java.util.Arrays;

public class ProresFrame {
    long _size;
    String _type;
    long _sizeHeader;
    int _reserved0;
    int _bitstream_version;
    String _encoder_id;
    int _hsize;
    int _vsize;
    byte _chroma_format;
    byte _reserved1;
    byte _interlace_mode;
    byte _reserved2;
    byte _aspect_ratio_information;
    byte _frame_rate_code;
    int _color_primaries;
    int _transfer_characteristics;
    int _matrix_coef;
    byte _reserved3;
    byte _alpha_channel_type;
    int _reserved4;
    boolean _load_luma_quantization_matrix;
    boolean _load_chroma_quantization_matrix;
    byte[] _luma_quantization_matrix = new byte[64];
    byte[] _chroma_quantization_matrix = new byte[64];
    ProresPicture[] _picture = new ProresPicture[2];

    public void parse(SeekableDataInput movieFile) throws IOException {
        this._size = BitstreamReader.readU32((DataInput)movieFile);
        this._type = BitstreamReader.readFourCC((DataInput)movieFile);
        this._sizeHeader = BitstreamReader.readU16(movieFile);
        this._reserved0 = BitstreamReader.readU8(movieFile);
        this._bitstream_version = BitstreamReader.readU8(movieFile);
        this._encoder_id = BitstreamReader.readFourCC((DataInput)movieFile);
        this._hsize = BitstreamReader.readU16(movieFile);
        this._vsize = BitstreamReader.readU16(movieFile);
        int tmp = BitstreamReader.readU8(movieFile);
        this._reserved2 = (byte)(tmp & 3);
        this._interlace_mode = (byte)((tmp >>= 2) & 3);
        this._reserved1 = (byte)((tmp >>= 2) & 3);
        this._chroma_format = (byte)((tmp >>= 2) & 3);
        tmp = BitstreamReader.readU8(movieFile);
        this._frame_rate_code = (byte)(tmp & 0xF);
        this._aspect_ratio_information = (byte)((tmp >>= 4) & 0xF);
        this._color_primaries = BitstreamReader.readU8(movieFile);
        this._transfer_characteristics = BitstreamReader.readU8(movieFile);
        this._matrix_coef = BitstreamReader.readU8(movieFile);
        tmp = BitstreamReader.readU8(movieFile);
        this._alpha_channel_type = (byte)(tmp & 0xF);
        this._reserved3 = (byte)((tmp >>= 4) & 0xF);
        int tmp2 = BitstreamReader.readU16(movieFile);
        this._reserved4 = tmp2 >> 14 & 0x3FFF;
        this._load_luma_quantization_matrix = (tmp2 & 1) != 0;
        boolean bl = this._load_chroma_quantization_matrix = (tmp2 & 2) != 0;
        if (this._load_luma_quantization_matrix) {
            movieFile.readFully(this._luma_quantization_matrix);
        }
        if (this._load_chroma_quantization_matrix) {
            movieFile.readFully(this._chroma_quantization_matrix);
        }
        this._picture[0] = new ProresPicture(this);
        this._picture[0].parse(movieFile);
        if (this._interlace_mode == 1 | this._interlace_mode == 2) {
            this._picture[1] = new ProresPicture(this);
            this._picture[1].parse(movieFile);
        }
    }

    public int hsize() {
        return this._hsize;
    }

    public int vsize() {
        return this._vsize;
    }

    public byte alpha_channel_type() {
        return this._alpha_channel_type;
    }

    public byte chroma_format() {
        return this._chroma_format;
    }

    public String toString() {
        return "ProresFrame{size=" + this._size + ", type='" + this._type + '\'' + ", sizeHeader=" + this._sizeHeader + ", reserved0=" + this._reserved0 + ", bitstream_version=" + this._bitstream_version + ", encoder_id='" + this._encoder_id + '\'' + ", hsize=" + this._hsize + ", vsize=" + this._vsize + ", chroma_format=" + this._chroma_format + ", reserved1=" + this._reserved1 + ", interlace_mode=" + this._interlace_mode + ", reserved2=" + this._reserved2 + ", aspect_ratio_information=" + this._aspect_ratio_information + ", frame_rate_code=" + this._frame_rate_code + ", color_primaries=" + this._color_primaries + ", transfer_characteristics=" + this._transfer_characteristics + ", matrix_coef=" + this._matrix_coef + ", reserved3=" + this._reserved3 + ", alpha_channel_type=" + this._alpha_channel_type + ", reserved4=" + this._reserved4 + ", load_luma_quantization_matrix=" + this._load_luma_quantization_matrix + ", load_chroma_quantization_matrix=" + this._load_chroma_quantization_matrix + ", luma_quantization_matrix=" + Arrays.toString(this._luma_quantization_matrix) + ", chroma_quantization_matrix=" + Arrays.toString(this._chroma_quantization_matrix) + ", picture=" + Arrays.toString(this._picture) + '}';
    }
}

