/*
 * Decompiled with CFR 0.152.
 */
package com.apple.jingle.leghorn.bitstream.hevc;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nonnull;

public interface HevcNalUnitType {
    public int getCode();

    public static enum Defined implements HevcNalUnitType
    {
        TRAIL_N(0),
        TRAIL_R(1),
        TSA_N(2),
        TSA_R(3),
        STSA_N(4),
        STSA_R(5),
        RADL_N(6),
        RADL_R(7),
        RASL_N(8),
        RASL_R(9),
        RSV_VCL_N10(10),
        RSV_VCL_N12(12),
        RSV_VCL_N14(14),
        RSV_VCL_N11(11),
        RSV_VCL_N13(13),
        RSV_VCL_N15(15),
        BLA_W_LP(16),
        BLA_W_RADL(17),
        BLA_N_LP(18),
        IDR_W_RADL(19),
        IDR_N_LP(20),
        CRA(21),
        RSV_IRAP_VCL22(22),
        RSV_IRAP_VCL23(23),
        RSV_VCL24(24),
        RSV_VCL25(25),
        RSV_VCL26(26),
        RSV_VCL27(27),
        RSV_VCL28(28),
        RSV_VCL29(29),
        RSV_VCL30(30),
        RSV_VCL31(31),
        VPS(32),
        SPS(33),
        PPS(34),
        AUD(35),
        EOS(36),
        EOB(37),
        FD(38),
        PREFIX_SEI(39),
        SUFFIX_SEI(40),
        RSV_NVCL41(41),
        RSV_NVCL42(42),
        RSV_NVCL43(43),
        RSV_NVCL44(44),
        RSV_NVCL45(45),
        RSV_NVCL46(46),
        RSV_NVCL47(47),
        UNSPEC48(48),
        UNSPEC49(49),
        UNSPEC50(50),
        UNSPEC51(51),
        UNSPEC52(52),
        UNSPEC53(53),
        UNSPEC54(54),
        UNSPEC55(55),
        UNSPEC56(56),
        UNSPEC57(57),
        UNSPEC58(58),
        UNSPEC59(59),
        UNSPEC60(60),
        UNSPEC61(61),
        UNSPEC62(62),
        UNSPEC63(63);

        private final int code;
        static Map<Integer, HevcNalUnitType> valueMap;

        private Defined(int code) {
            this.code = code;
        }

        @Override
        public int getCode() {
            return this.code;
        }

        private static Map<Integer, HevcNalUnitType> createCodeMap() {
            Defined[] values = Defined.values();
            HashMap<Integer, Defined> map = new HashMap<Integer, Defined>(values.length);
            for (Defined v : values) {
                map.put(v.getCode(), v);
            }
            return Collections.unmodifiableMap(map);
        }

        @Nonnull
        public static HevcNalUnitType forCode(int code) {
            HevcNalUnitType unitType = valueMap.get(code);
            if (null != unitType) {
                return unitType;
            }
            return new Undefined(code);
        }

        static {
            valueMap = Defined.createCodeMap();
        }
    }

    public static class Undefined
    implements HevcNalUnitType {
        private final int code;

        private Undefined(int code) {
            this.code = code;
        }

        @Override
        public int getCode() {
            return this.code;
        }

        public int hashCode() {
            return this.code;
        }

        public boolean equals(Object obj) {
            return obj instanceof Undefined && ((Undefined)obj).code == this.code;
        }

        public String toString() {
            return "NalUnitType[" + this.code + "]";
        }
    }
}

