/*
 * Decompiled with CFR 0.152.
 */
package com.apple.jingle.leghorn.bitstream.hevc;

import com.apple.jingle.leghorn.bitstream.avc.RawByteSequencePayloadReader;
import com.apple.jingle.leghorn.bitstream.hevc.HevcNalUnitType;
import com.apple.jingle.media.foundation.io.ByteArraySeekableDataInput;
import com.apple.jingle.media.foundation.io.SeekableDataInput;
import java.io.IOException;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;

public class HevcNalUnitHeader {
    @Nonnull
    private final boolean forbiddenZeroBit;
    @Nonnull
    private final HevcNalUnitType unitType;
    private final int layerId;
    private final int temporalId;
    private final int numBytesInNalUnit;
    private final byte[] rbsp;

    public HevcNalUnitHeader(@Nonnull SeekableDataInput reader, @Nonnegative int numBytesInNalUnit) throws IOException {
        this.numBytesInNalUnit = numBytesInNalUnit;
        int data = reader.readUnsignedShort();
        this.forbiddenZeroBit = (data & 0x80) != 0;
        this.unitType = HevcNalUnitType.Defined.forCode(data >>> 9 & 0x3F);
        this.layerId = data >>> 3 & 0x3F;
        this.temporalId = (data >>> 3 & 7) - 1;
        if ((numBytesInNalUnit -= 2) < 0) {
            this.rbsp = new byte[0];
        } else {
            byte[] rbspData = new byte[numBytesInNalUnit];
            int lastData = 0;
            int pos = 0;
            while (numBytesInNalUnit-- > 0) {
                int b = reader.readUnsignedByte();
                lastData <<= 8;
                if (pos >= 2 && ((lastData |= b) & 0xFFFFFF) == 3) continue;
                rbspData[pos++] = (byte)b;
            }
            this.rbsp = new byte[pos];
            System.arraycopy(rbspData, 0, this.rbsp, 0, pos);
        }
    }

    public int layerId() {
        return this.layerId;
    }

    @Nonnull
    public HevcNalUnitType unitType() {
        return this.unitType;
    }

    @Nonnull
    public ByteArraySeekableDataInput payloadDataInput() {
        return new ByteArraySeekableDataInput(this.rbsp, (long)this.rbsp.length);
    }

    @Nonnull
    public RawByteSequencePayloadReader payloadReader() throws IOException {
        return new RawByteSequencePayloadReader(this.rbsp);
    }

    @Nonnegative
    public int numBytesInNalUnit() {
        return this.numBytesInNalUnit;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[" + "unitType=" + this.unitType + ", " + "layerId=" + this.layerId + ", " + "temporalId=" + this.temporalId + "]";
    }
}

