/*
 * Decompiled with CFR 0.152.
 */
package com.apple.jingle.leghorn.bitstream.avc.vui;

import com.apple.jingle.g5.util.DataDiffSet;
import com.apple.jingle.g5.util.DataDiffable;
import com.apple.jingle.g5.util.DataDump;
import com.apple.jingle.g5.util.DataDumpable;
import com.apple.jingle.g5.util.MapDataDump;
import com.apple.jingle.g5.util.StringDataDump;
import com.apple.jingle.leghorn.bitstream.avc.RawByteSequencePayloadReader;
import com.apple.jingle.leghorn.bitstream.avc.vui.AspectRatio;
import com.apple.jingle.leghorn.bitstream.avc.vui.BitStreamRestriction;
import com.apple.jingle.leghorn.bitstream.avc.vui.ChromaLocInfo;
import com.apple.jingle.leghorn.bitstream.avc.vui.HrdParameters;
import com.apple.jingle.leghorn.bitstream.avc.vui.OverscanInfo;
import com.apple.jingle.leghorn.bitstream.avc.vui.TimeInfo;
import com.apple.jingle.leghorn.bitstream.avc.vui.VideoSignalType;
import java.io.IOException;
import javax.annotation.Nonnull;

public class VideoUsabilityInformationParameters
implements DataDumpable,
DataDiffable<VideoUsabilityInformationParameters> {
    public static final VideoUsabilityInformationParameters defaultValues = new VideoUsabilityInformationParameters();
    @Nonnull
    private final AspectRatio aspectRatio;
    private OverscanInfo overscanInfo;
    @Nonnull
    private final VideoSignalType videoSignalType;
    private TimeInfo timeInfo;
    private ChromaLocInfo chromaSampleLoc;
    private BitStreamRestriction bitStreamRestriction;
    private HrdParameters nalHrdParameters;
    private HrdParameters vclHrdParameters;
    private Boolean lowDelayHrd;
    private boolean pictureStructure;

    private VideoUsabilityInformationParameters() {
        this.aspectRatio = AspectRatio.Defined.unspecified;
        this.videoSignalType = VideoSignalType.defaultValue;
    }

    public VideoUsabilityInformationParameters(@Nonnull RawByteSequencePayloadReader reader) throws IOException {
        this.aspectRatio = reader.readBoolean() ? AspectRatio.Defined.read(reader) : AspectRatio.Defined.unspecified;
        if (reader.readBoolean()) {
            this.overscanInfo = new OverscanInfo(reader);
        }
        this.videoSignalType = reader.readBoolean() ? new VideoSignalType(reader) : VideoSignalType.defaultValue;
        if (reader.readBoolean()) {
            this.chromaSampleLoc = new ChromaLocInfo(reader);
        }
        if (reader.readBoolean()) {
            this.timeInfo = new TimeInfo(reader);
        }
        if (reader.readBoolean()) {
            this.nalHrdParameters = new HrdParameters(reader);
        }
        if (reader.readBoolean()) {
            this.vclHrdParameters = new HrdParameters(reader);
        }
        if (null != this.nalHrdParameters || null != this.vclHrdParameters) {
            this.lowDelayHrd = reader.readBoolean();
        }
        this.pictureStructure = reader.readBoolean();
        if (reader.readBoolean()) {
            this.bitStreamRestriction = new BitStreamRestriction(reader);
        }
    }

    public boolean hasPictureStructure() {
        return this.pictureStructure;
    }

    public boolean hasNalHrdParameters() {
        return this.nalHrdParameters != null;
    }

    public boolean hasVclHrdParameters() {
        return this.vclHrdParameters != null;
    }

    @Nonnull
    public VideoSignalType videoSignalType() {
        return this.videoSignalType;
    }

    public String toString() {
        return StringDataDump.toString(this);
    }

    @Override
    public void diff(@Nonnull DataDiffSet diffs, @Nonnull String prefix, @Nonnull VideoUsabilityInformationParameters compareTo) {
        MapDataDump.diff(diffs, prefix, this, compareTo);
    }

    @Override
    public void dumpData(@Nonnull DataDump dump) {
        dump.write("aspectRatio", this.aspectRatio).write("overscanInfo", this.overscanInfo).dump("videoSignalType", this.videoSignalType).write("chromaSampleLoc", this.chromaSampleLoc).dump("timeInfo", this.timeInfo).dump("bitStreamRestriction", this.bitStreamRestriction).write("nalHrdParameters", this.nalHrdParameters).write("vclHrdParameters", this.vclHrdParameters).write("lowDelayHrd", this.lowDelayHrd);
    }
}

