/*
 * Decompiled with CFR 0.152.
 */
package com.apple.jingle.leghorn.bitstream.avc.vui;

import com.apple.jingle.g5.util.DataDiffSet;
import com.apple.jingle.g5.util.DataDiffable;
import com.apple.jingle.g5.util.DataDump;
import com.apple.jingle.g5.util.DataDumpable;
import com.apple.jingle.g5.util.MapDataDump;
import com.apple.jingle.g5.util.StringDataDump;
import com.apple.jingle.leghorn.bitstream.avc.RawByteSequencePayloadReader;
import com.apple.jingle.leghorn.bitstream.avc.vui.ColorDescription;
import com.apple.jingle.leghorn.bitstream.avc.vui.VideoFormat;
import java.io.IOException;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.Immutable;

@Immutable
public class VideoSignalType
implements DataDumpable,
DataDiffable<VideoSignalType> {
    public static final VideoSignalType defaultValue = new VideoSignalType();
    @Nonnull
    private final VideoFormat videoFormat;
    private final boolean videoFullRange;
    private final ColorDescription colorDescription;

    private VideoSignalType() {
        this.videoFormat = VideoFormat.Defined.unspecified;
        this.videoFullRange = false;
        this.colorDescription = null;
    }

    public VideoSignalType(@Nonnull RawByteSequencePayloadReader reader) throws IOException {
        this.videoFormat = VideoFormat.Defined.read(reader);
        this.videoFullRange = reader.readBoolean();
        this.colorDescription = reader.readBoolean() ? new ColorDescription(reader) : null;
    }

    @Nonnull
    public VideoFormat videoFormat() {
        return this.videoFormat;
    }

    public String toString() {
        return StringDataDump.toString(this);
    }

    @Override
    public void diff(@Nonnull DataDiffSet diffs, @Nonnull String prefix, @Nonnull VideoSignalType compareTo) {
        MapDataDump.diff(diffs, prefix, this, compareTo);
    }

    @Override
    public void dumpData(@Nonnull DataDump dump) {
        dump.dump("colorDescription", this.colorDescription).write("videoFormat", this.videoFormat.getCode()).write("videoFullRange", this.videoFullRange);
    }
}

