/*
 * Decompiled with CFR 0.152.
 */
package com.apple.jingle.leghorn.bitstream.avc.vui;

import com.apple.jingle.leghorn.bitstream.avc.RawByteSequencePayloadReader;
import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nonnull;

public interface VideoFormat {
    public int getCode();

    public static enum Defined implements VideoFormat
    {
        component(0),
        pal(1),
        ntsc(2),
        secam(3),
        mac(4),
        unspecified(5),
        reserved6(6),
        reserved7(7);

        private final int code;
        static Map<Integer, VideoFormat> valueMap;

        private Defined(int code) {
            this.code = code;
        }

        @Override
        public int getCode() {
            return this.code;
        }

        private static Map<Integer, VideoFormat> map() {
            Defined[] values = Defined.values();
            HashMap<Integer, VideoFormat> map = new HashMap<Integer, VideoFormat>(values.length);
            for (Defined v : values) {
                map.put(v.getCode(), v);
            }
            return map;
        }

        @Nonnull
        public static VideoFormat read(@Nonnull RawByteSequencePayloadReader reader) throws IOException {
            int code = reader.readBits(3);
            VideoFormat unitType = valueMap.get(code);
            if (null != unitType) {
                return unitType;
            }
            return new Undefined(code);
        }

        static {
            valueMap = Collections.unmodifiableMap(Defined.map());
        }
    }

    public static class Undefined
    implements VideoFormat {
        private final int code;

        private Undefined(int code) {
            this.code = code;
        }

        @Override
        public int getCode() {
            return this.code;
        }

        public int hashCode() {
            return this.code;
        }

        public boolean equals(Object obj) {
            return obj instanceof Undefined && ((Undefined)obj).code == this.code;
        }

        public String toString() {
            return "VideoFormat[" + this.code + "]";
        }
    }
}

