/*
 * Decompiled with CFR 0.152.
 */
package com.apple.jingle.leghorn.bitstream.avc.vui;

import com.apple.jingle.leghorn.bitstream.avc.RawByteSequencePayloadReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;

public class HrdParameters {
    private final List<Cpb> cpbs;
    private int bitRateScale;
    private int cpbSizeScale;
    private final int initialCpbRemovalDelayLength;
    private final int cpbRemovalDelayLength;
    private final int dpbOutputDelayLength;
    private final int timeOffsetLength;

    public HrdParameters(@Nonnull RawByteSequencePayloadReader reader) throws IOException {
        int cpbCount = reader.readUnsignedExponentialGolomb() + 1;
        this.bitRateScale = reader.readBits(4);
        this.cpbSizeScale = reader.readBits(4);
        this.cpbs = new ArrayList<Cpb>(cpbCount);
        for (int schedSelIdx = 0; schedSelIdx < cpbCount; ++schedSelIdx) {
            this.cpbs.add(new Cpb(reader, schedSelIdx));
        }
        this.initialCpbRemovalDelayLength = reader.readBits(5) + 1;
        this.cpbRemovalDelayLength = reader.readBits(5) + 1;
        this.dpbOutputDelayLength = reader.readBits(5) + 1;
        this.timeOffsetLength = reader.readBits(5);
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[" + "cpbs=" + this.cpbs + ", " + "bitRateScale=" + this.bitRateScale + ", " + "cpbSizeScale=" + this.cpbSizeScale + ", " + "initialCpbRemovalDelayLength=" + this.initialCpbRemovalDelayLength + ", " + "cpbRemovalDelayLength=" + this.cpbRemovalDelayLength + ", " + "dpbOutputDelayLength=" + this.dpbOutputDelayLength + ", " + "timeOffsetLength=" + this.timeOffsetLength + "]";
    }

    public class Cpb {
        private int bitRate;
        private int cpbSize;
        private final boolean cbr;

        Cpb(RawByteSequencePayloadReader reader, int index) throws IOException {
            this.bitRate = reader.readUnsignedExponentialGolomb();
            this.cpbSize = reader.readUnsignedExponentialGolomb();
            this.cbr = reader.readBoolean();
        }

        public String toString() {
            return this.getClass().getSimpleName() + "[" + "bitRate=" + this.bitRate + ", " + "cpbSize=" + this.cpbSize + ", " + "cbr=" + this.cbr + "]";
        }
    }
}

