/*
 * Decompiled with CFR 0.152.
 */
package com.apple.jingle.leghorn.bitstream.avc.vui;

import com.apple.jingle.leghorn.bitstream.avc.RawByteSequencePayloadReader;
import java.io.IOException;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;

public interface ChromaFormat {
    public int formatIdc();

    public boolean separateColorPlane();

    public static enum Defined implements ChromaFormat
    {
        monochrome(0, false, "monochrome"),
        _4_2_0(1, false, "4:2:0"),
        _4_2_2(2, false, "4:2:2"),
        _4_4_4(3, false, "4:4:4"),
        _4_4_4_s(4, true, "4:4:4 w/separaeColorPlane"),
        _4_0_0(183, false, "4:0:0");

        private final int formatIdc;
        private final boolean separateColorPlane;
        private final String str;

        private Defined(int formatIdc, boolean separateColorPlane, String str) {
            this.formatIdc = formatIdc;
            this.separateColorPlane = separateColorPlane;
            this.str = str;
        }

        @Override
        public int formatIdc() {
            return this.formatIdc;
        }

        @Override
        public boolean separateColorPlane() {
            return this.separateColorPlane;
        }

        public String toString() {
            return this.str;
        }

        @Nonnull
        public static ChromaFormat forCode(@Nonnegative int chromaFormatId, boolean separateColorPlane) {
            switch (chromaFormatId) {
                case 0: {
                    return monochrome;
                }
                case 1: {
                    return _4_2_0;
                }
                case 2: {
                    return _4_2_2;
                }
                case 3: {
                    if (separateColorPlane) {
                        return _4_4_4_s;
                    }
                    return _4_4_4;
                }
                case 183: {
                    return _4_0_0;
                }
            }
            return new Undefined(chromaFormatId);
        }

        @Nonnull
        public static ChromaFormat read(@Nonnull RawByteSequencePayloadReader reader) throws IOException {
            int chromaFormatIdc = reader.readUnsignedExponentialGolomb();
            switch (chromaFormatIdc) {
                case 0: {
                    return monochrome;
                }
                case 1: {
                    return _4_2_0;
                }
                case 2: {
                    return _4_2_2;
                }
                case 3: {
                    if (reader.readBoolean()) {
                        return _4_4_4_s;
                    }
                    return _4_4_4;
                }
                case 183: {
                    return _4_0_0;
                }
            }
            return new Undefined(chromaFormatIdc);
        }
    }

    public static class Undefined
    implements ChromaFormat {
        private final int formatIdc;

        private Undefined(int formatIdc) {
            this.formatIdc = formatIdc;
        }

        @Override
        public int formatIdc() {
            return this.formatIdc;
        }

        public String toString() {
            return "VideoFormat[" + this.formatIdc + "]";
        }

        @Override
        public boolean separateColorPlane() {
            return false;
        }
    }
}

