/*
 * Decompiled with CFR 0.152.
 */
package com.apple.jingle.leghorn.bitstream.avc.vui;

import com.apple.jingle.leghorn.bitstream.avc.RawByteSequencePayloadReader;
import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nonnull;

public interface AspectRatio {
    public int getCode();

    public static enum Defined implements AspectRatio
    {
        unspecified(0, "Unspecified"),
        _1x1(1, "1:1"),
        _12x11(2, "12:11"),
        _10x11(3, "10:11"),
        _16x11(4, "16:11"),
        _40x33(5, "40:33"),
        _24x11(6, "24:11"),
        _20x11(7, "20:11"),
        extended(255, "Extended_SAR");

        private final int code;
        private final String humanReadable;
        static Map<Integer, AspectRatio> valueMap;

        private Defined(int code, String humanReadable) {
            this.code = code;
            this.humanReadable = humanReadable;
        }

        @Override
        public int getCode() {
            return this.code;
        }

        public String toString() {
            return this.humanReadable;
        }

        private static Map<Integer, AspectRatio> map() {
            Defined[] values = Defined.values();
            HashMap<Integer, AspectRatio> map = new HashMap<Integer, AspectRatio>(values.length);
            for (Defined v : values) {
                map.put(v.getCode(), v);
            }
            return map;
        }

        @Nonnull
        public static AspectRatio read(@Nonnull RawByteSequencePayloadReader reader) throws IOException {
            int code = reader.readBits(8);
            if (code == 255) {
                return new Extended(255, reader.readBits(16), reader.readBits(16));
            }
            AspectRatio unitType = valueMap.get(code);
            if (null != unitType) {
                return unitType;
            }
            return new Undefined(code);
        }

        static {
            valueMap = Collections.unmodifiableMap(Defined.map());
        }
    }

    public static class Extended
    implements AspectRatio {
        private final int code;
        private final int w;
        private final int h;

        private Extended(int code, int w, int h) {
            this.code = code;
            this.w = w;
            this.h = h;
        }

        @Override
        public int getCode() {
            return this.code;
        }

        public int hashCode() {
            return this.code;
        }

        public boolean equals(Object obj) {
            return obj instanceof Undefined && ((Undefined)obj).code == this.code;
        }

        public String toString() {
            return this.w + ":" + this.h;
        }

        public int getWidth() {
            return this.w;
        }

        public int getHeight() {
            return this.h;
        }
    }

    public static class Undefined
    implements AspectRatio {
        private final int code;

        private Undefined(int code) {
            this.code = code;
        }

        @Override
        public int getCode() {
            return this.code;
        }

        public int hashCode() {
            return this.code;
        }

        public boolean equals(Object obj) {
            return obj instanceof Undefined && ((Undefined)obj).code == this.code;
        }

        public String toString() {
            return "AspectRatio[" + this.code + "]";
        }
    }
}

