/*
 * Decompiled with CFR 0.152.
 */
package com.apple.jingle.leghorn.bitstream.avc.sei;

import com.apple.jingle.leghorn.bitstream.avc.SequenceParameterSet;
import com.apple.jingle.leghorn.bitstream.avc.sei.SEIMessage;
import com.apple.jingle.leghorn.bitstream.avc.vui.VideoUsabilityInformationParameters;
import com.apple.jingle.media.foundation.io.SeekableDataInput;
import com.apple.jingle.media.foundation.util.BitReader;
import java.io.IOException;

public class PicTiming
extends SEIMessage {
    public final int[] numClockTSTable = new int[]{1, 1, 1, 2, 2, 3, 3, 2, 3};
    private long cpbRemovalDelay;
    private long dpbOutputDelay;
    private int picStruct;
    private int[] clockTimeStampFlag;
    private long ctType;
    private long nuitFieldBasedFlag;
    private long countingType;
    private long fullTimestampFlag;
    private long discontinuityFlag;
    private long cntDroppedFlag;
    private long nFrames;
    private long secondsValue;
    private long minutesValue;
    private long hoursValue;
    private long secondsFlag;
    private long minutesFlag;
    private long hoursFlag;

    @Override
    public void parse(SeekableDataInput sdi) throws IOException {
        super.parse(sdi);
        SequenceParameterSet sps = this.naluByteStream.getSPS();
        VideoUsabilityInformationParameters vui = sps.vui();
        byte[] buffer = new byte[this.payloadSize];
        sdi.readFully(buffer);
        BitReader bitReader = new BitReader(buffer);
        if (vui.hasNalHrdParameters() || vui.hasVclHrdParameters()) {
            this.cpbRemovalDelay = bitReader.readUBits(5);
            this.dpbOutputDelay = bitReader.readUBits(5);
        }
        if (vui.hasPictureStructure()) {
            this.picStruct = (int)bitReader.readUBits(4);
            this.clockTimeStampFlag = new int[this.numClockTSTable[this.picStruct]];
            for (int i = 0; i < this.numClockTSTable[this.picStruct]; ++i) {
                this.clockTimeStampFlag[i] = (int)bitReader.readUBits(1);
                if (this.clockTimeStampFlag[i] != 1) continue;
                this.ctType = bitReader.readUBits(2);
                this.nuitFieldBasedFlag = bitReader.readUBits(1);
                this.countingType = bitReader.readUBits(5);
                this.fullTimestampFlag = bitReader.readUBits(1);
                this.discontinuityFlag = bitReader.readUBits(1);
                this.cntDroppedFlag = bitReader.readUBits(1);
                this.nFrames = bitReader.readUBits(8);
                if (this.fullTimestampFlag == 1L) {
                    this.secondsValue = bitReader.readUBits(6);
                    this.minutesValue = bitReader.readUBits(6);
                    this.hoursValue = bitReader.readUBits(6);
                    continue;
                }
                this.secondsFlag = bitReader.readUBits(1);
                if (this.secondsFlag != 1L) continue;
                this.secondsValue = bitReader.readUBits(6);
                this.minutesFlag = bitReader.readUBits(1);
                if (this.minutesFlag != 1L) continue;
                this.minutesValue = bitReader.readUBits(6);
                this.hoursFlag = bitReader.readUBits(6);
                if (this.hoursFlag != 1L) continue;
                this.hoursValue = bitReader.readUBits(6);
            }
        }
    }

    public int getPicStruct() {
        return this.picStruct;
    }
}

