/*
 * Decompiled with CFR 0.152.
 */
package com.apple.jingle.leghorn.bitstream.avc;

import com.apple.jingle.leghorn.bitstream.avc.NALUByteStream;
import com.apple.jingle.leghorn.bitstream.avc.NALUnit;
import com.apple.jingle.leghorn.bitstream.avc.sei.PicTiming;
import com.apple.jingle.leghorn.bitstream.avc.sei.SEIMessage;
import com.apple.jingle.leghorn.bitstream.avc.sei.SubSeqLayerCharacteristics;
import com.apple.jingle.media.foundation.io.SeekableDataInput;
import com.apple.jingle.media.foundation.util.BitReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class SupplementalEnhancementInformation
extends NALUnit {
    List<SEIMessage> seiMessages = new ArrayList<SEIMessage>();
    public static final Map<Long, Class<? extends SEIMessage>> MAP_OF_SEI_TYPE_TO_CLASS = new HashMap<Long, Class<? extends SEIMessage>>();

    @Override
    public void parse(NALUByteStream naluByteStream, SeekableDataInput sdi) throws IOException {
        do {
            SEIMessage newMessage;
            byte[] buffer = new byte[1];
            sdi.readFully(buffer);
            int payloadType = 0;
            int payloadSize = 0;
            while (buffer[0] == 255) {
                sdi.readFully(buffer);
                payloadType += 255;
            }
            BitReader bitReader = new BitReader(buffer);
            payloadType = (int)((long)payloadType + bitReader.readUBits(8));
            payloadSize = 0;
            sdi.readFully(buffer);
            while (buffer[0] == 255) {
                sdi.readFully(buffer);
                payloadSize += 255;
            }
            bitReader = new BitReader(buffer);
            payloadSize = (int)((long)payloadSize + bitReader.readUBits(8));
            if (MAP_OF_SEI_TYPE_TO_CLASS.containsKey(payloadType)) {
                try {
                    newMessage = MAP_OF_SEI_TYPE_TO_CLASS.get(this.nalUType).newInstance();
                }
                catch (Exception e) {
                    newMessage = new SEIMessage();
                }
            } else {
                newMessage = new SEIMessage();
            }
            newMessage.setAttributes(naluByteStream, payloadType, payloadSize);
            newMessage.parse(sdi);
            this.seiMessages.add(newMessage);
        } while (sdi.getFilePointer() < sdi.length() - 1L);
    }

    static {
        MAP_OF_SEI_TYPE_TO_CLASS.put(1L, PicTiming.class);
        MAP_OF_SEI_TYPE_TO_CLASS.put(11L, SubSeqLayerCharacteristics.class);
    }
}

