/*
 * Decompiled with CFR 0.152.
 */
package com.apple.jingle.leghorn.bitstream.avc;

import com.apple.jingle.foghorn.media.FrameGeometry;
import com.apple.jingle.g5.util.DataDiffSet;
import com.apple.jingle.g5.util.DataDiffable;
import com.apple.jingle.g5.util.DataDump;
import com.apple.jingle.g5.util.DataDumpable;
import com.apple.jingle.g5.util.MapDataDump;
import com.apple.jingle.g5.util.StringDataDump;
import com.apple.jingle.leghorn.bitstream.avc.NALUnit;
import com.apple.jingle.leghorn.bitstream.avc.NalUnitHeader;
import com.apple.jingle.leghorn.bitstream.avc.RawByteSequencePayloadReader;
import com.apple.jingle.leghorn.bitstream.avc.vui.ChromaFormat;
import com.apple.jingle.leghorn.bitstream.avc.vui.VideoUsabilityInformationParameters;
import java.io.IOException;
import java.util.Arrays;
import java.util.logging.Level;
import javax.annotation.Nonnull;

public class SequenceParameterSet
extends NALUnit
implements DataDumpable,
DataDiffable<SequenceParameterSet> {
    private final int profileIdc;
    private final int constraintSets;
    private final int levelIdc;
    private final int seqParameterSetId;
    @Nonnull
    private final ChromaFormat chromaFormat;
    private final int lumaBitDepth;
    private final int chromaBitDepth;
    private final boolean qpPrimeYZeroTransformBypass;
    @Nonnull
    private final VideoUsabilityInformationParameters vui;
    private final Integer[][] scalingList = new Integer[12][];
    private final Boolean[] useDefaultScalingMatrix = new Boolean[12];
    private int log2MaxFrameNum;
    private int pictureOrderCountType;
    private int log2MaxPictureOrderCountLsb;
    private boolean deltaPictureAlwaysZero;
    private int offsetForNonReferencePicture;
    private int offsetForTopToBottomField;
    private int numRefFramesInPictureOrderCountCycle;
    private int[] offsetForRefFrame;
    private final int maxNumberOfReferenceFrames;
    private final boolean gapsInFrameNumValueAllowed;
    private final int picWidthInMbs;
    private final int pictureHeightInMapUnits;
    private final boolean frameMbsOnly;
    private final boolean mbAdaptiveFrameField;
    private final boolean direct8x8Inference;
    @Nonnull
    private final FrameGeometry.CropRectangle frameCrop;
    private static final int[] profilesWithChroma = SequenceParameterSet.profilesWithChroma();
    public static final int[] ZZ_SCAN = new int[]{0, 1, 4, 8, 5, 2, 3, 6, 9, 12, 13, 10, 7, 11, 14, 15};
    public static final int[] ZZ_SCAN8 = new int[]{0, 1, 8, 16, 9, 2, 3, 10, 17, 24, 32, 25, 18, 11, 4, 5, 12, 19, 26, 33, 40, 48, 41, 34, 27, 20, 13, 6, 7, 14, 21, 28, 35, 42, 49, 56, 57, 50, 43, 36, 29, 22, 15, 23, 30, 37, 44, 51, 58, 59, 52, 45, 38, 31, 39, 46, 53, 60, 61, 54, 47, 55, 62, 63};

    private static final int[] profilesWithChroma() {
        int[] data = new int[]{100, 110, 122, 244, 44, 83, 86, 118, 128, 139, 139, 134};
        Arrays.sort(data);
        return data;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SequenceParameterSet(@Nonnull NalUnitHeader nalUnitHeader) throws IOException {
        super(nalUnitHeader);
        try (RawByteSequencePayloadReader reader = nalUnitHeader.payloadReader();){
            this.profileIdc = reader.readBits(8);
            this.constraintSets = reader.readBits(8);
            this.levelIdc = reader.readBits(8);
            this.seqParameterSetId = reader.readUnsignedExponentialGolomb();
            if (Arrays.binarySearch(profilesWithChroma, this.profileIdc) >= 0) {
                this.chromaFormat = ChromaFormat.Defined.read(reader);
                this.lumaBitDepth = reader.readUnsignedExponentialGolomb() + 8;
                this.chromaBitDepth = reader.readUnsignedExponentialGolomb() + 8;
                this.qpPrimeYZeroTransformBypass = reader.readBoolean();
                if (reader.readBoolean()) {
                    int entries = this.chromaFormat.formatIdc() != 3 ? 8 : 12;
                    for (int seqScalingMatrixId = 0; seqScalingMatrixId < entries; ++seqScalingMatrixId) {
                        if (!reader.readBoolean()) continue;
                        int sizeOfScalingList = seqScalingMatrixId < 6 ? 16 : 64;
                        int[] zzScan = seqScalingMatrixId < 6 ? ZZ_SCAN : ZZ_SCAN8;
                        Integer[] scalingLine = new Integer[64];
                        this.scalingList[seqScalingMatrixId] = scalingLine;
                        int lastScale = 8;
                        int nextScale = 8;
                        for (int j = 0; j < sizeOfScalingList; ++j) {
                            int scanj = zzScan[j];
                            if (0 != nextScale) {
                                int deltaScale = reader.readSignedExponentialGolomb();
                                nextScale = (lastScale + deltaScale + 256) % 256;
                                this.useDefaultScalingMatrix[seqScalingMatrixId] = scanj == 0 && nextScale == 0;
                            }
                            scalingLine[scanj] = nextScale == 0 ? lastScale : nextScale;
                            lastScale = scalingLine[scanj];
                        }
                    }
                }
            } else {
                this.chromaFormat = ChromaFormat.Defined._4_2_0;
                this.lumaBitDepth = 8;
                this.chromaBitDepth = 8;
                this.qpPrimeYZeroTransformBypass = false;
            }
            this.log2MaxFrameNum = reader.readUnsignedExponentialGolomb() + 4;
            this.pictureOrderCountType = reader.readUnsignedExponentialGolomb();
            if (this.pictureOrderCountType == 0) {
                this.log2MaxPictureOrderCountLsb = reader.readUnsignedExponentialGolomb() + 4;
            } else if (this.pictureOrderCountType == 1) {
                this.deltaPictureAlwaysZero = reader.readBoolean();
                this.offsetForNonReferencePicture = reader.readSignedExponentialGolomb();
                this.offsetForTopToBottomField = reader.readSignedExponentialGolomb();
                this.numRefFramesInPictureOrderCountCycle = reader.readUnsignedExponentialGolomb();
                this.offsetForRefFrame = new int[this.numRefFramesInPictureOrderCountCycle];
                for (int refFrameId = 0; refFrameId < this.numRefFramesInPictureOrderCountCycle; ++refFrameId) {
                    this.offsetForRefFrame[refFrameId] = reader.readSignedExponentialGolomb();
                }
            }
            this.maxNumberOfReferenceFrames = reader.readUnsignedExponentialGolomb();
            this.gapsInFrameNumValueAllowed = reader.readBoolean();
            this.picWidthInMbs = reader.readUnsignedExponentialGolomb() + 1;
            this.pictureHeightInMapUnits = reader.readUnsignedExponentialGolomb() + 1;
            this.frameMbsOnly = reader.readBoolean();
            this.mbAdaptiveFrameField = !this.frameMbsOnly ? reader.readBoolean() : false;
            this.direct8x8Inference = reader.readBoolean();
            if (reader.readBoolean()) {
                int frameCropLeftOffset = reader.readUnsignedExponentialGolomb();
                int frameCropRightOffset = reader.readUnsignedExponentialGolomb();
                int frameCropTopOffset = reader.readUnsignedExponentialGolomb();
                int frameCropBottomOffset = reader.readUnsignedExponentialGolomb();
                this.frameCrop = new FrameGeometry.CropRectangle(frameCropTopOffset, frameCropBottomOffset, frameCropLeftOffset, frameCropRightOffset);
            } else {
                this.frameCrop = new FrameGeometry.CropRectangle(0L, 0L, 0L, 0L);
            }
            this.vui = reader.readBoolean() ? new VideoUsabilityInformationParameters(reader) : VideoUsabilityInformationParameters.defaultValues;
        }
    }

    public int getProfileIdc() {
        return this.profileIdc;
    }

    public int getLevelIdc() {
        return this.levelIdc;
    }

    public long getSeqParameterSetId() {
        return this.seqParameterSetId;
    }

    public int getChromaFormatIdc() {
        return this.chromaFormat.formatIdc();
    }

    public int getLumaBitDepth() {
        return this.lumaBitDepth;
    }

    public int getChromaBitDepth() {
        return this.chromaBitDepth;
    }

    public boolean getQpPrimeYZeroTransformBypass() {
        return this.qpPrimeYZeroTransformBypass;
    }

    public int getLog2MaxFrameNum() {
        return this.log2MaxFrameNum;
    }

    public long getMaxFrameNum() {
        return 1 << this.log2MaxFrameNum;
    }

    public int getPictureOrderCountType() {
        return this.pictureOrderCountType;
    }

    public int getLog2MaxPictureOrderCountLsb() {
        return this.log2MaxPictureOrderCountLsb;
    }

    public boolean getDeltaPictureOrderAlwaysZero() {
        return this.deltaPictureAlwaysZero;
    }

    public int getOffsetForNonReferencePicture() {
        return this.offsetForNonReferencePicture;
    }

    public int getOffsetForTopToBottomField() {
        return this.offsetForTopToBottomField;
    }

    public int getNumRefFramesInPictureOrderCounttCycle() {
        return this.numRefFramesInPictureOrderCountCycle;
    }

    public int[] getOffsetForRefFrame() {
        return this.offsetForRefFrame;
    }

    public int getMaxNumberOfReferenceFrames() {
        return this.maxNumberOfReferenceFrames;
    }

    public boolean getGapsInFrameNumberValueAllowed() {
        return this.gapsInFrameNumValueAllowed;
    }

    public int pictureWidthInMbs() {
        return this.picWidthInMbs;
    }

    public int pictureHeightInMapUnits() {
        return this.pictureHeightInMapUnits;
    }

    public boolean onlyContainsFrameMacroblocks() {
        return this.frameMbsOnly;
    }

    public boolean adaptiveFrameAndFieldMacroblocks() {
        return this.mbAdaptiveFrameField;
    }

    public boolean direct8x8Inference() {
        return this.direct8x8Inference;
    }

    @Nonnull
    public FrameGeometry.CropRectangle frameCrop() {
        return this.frameCrop;
    }

    @Nonnull
    public VideoUsabilityInformationParameters vui() {
        return this.vui;
    }

    public String toString() {
        return StringDataDump.toString(this);
    }

    @Override
    public void diff(@Nonnull DataDiffSet diffs, @Nonnull String prefix, @Nonnull SequenceParameterSet compareTo) {
        MapDataDump.diff(diffs, prefix, this, compareTo);
    }

    @Override
    public void dumpData(@Nonnull DataDump dump) {
        dump.write("profileIdc", this.profileIdc).write("constraintSets", this.constraintSets != 0, String.format("%02x", this.constraintSets)).write("levelIdc", this.levelIdc).write("seqParameterSetId", this.seqParameterSetId).write("log2MaxFrameNum", this.log2MaxFrameNum).write("picOrderCntType", this.pictureOrderCountType).write("log2MaxPicOrderCountLsb", this.log2MaxPictureOrderCountLsb).write("deltaPictureAlwaysZero", this.deltaPictureAlwaysZero).write("offsetForNonrefPic", this.offsetForNonReferencePicture).write("offsetForTopToBottomField", this.offsetForTopToBottomField).write("numRefFramesInPicorderCntCycle", this.numRefFramesInPictureOrderCountCycle).write("offsetForRefFrame", this.offsetForRefFrame).write("numRefFrames", this.maxNumberOfReferenceFrames).write("gapsInFrameNumValueAllowedFlag", this.gapsInFrameNumValueAllowed).write("picWidthInMbs", this.picWidthInMbs).write("picHeightInMapUnits", this.pictureHeightInMapUnits).write("frameMbsOnly", this.frameMbsOnly).write("mbAdaptiveFrameField", this.mbAdaptiveFrameField).write("direct8x8Inference", this.direct8x8Inference).write("frameCrop", !this.frameCrop.isIdentity() && dump.level().intValue() >= Level.INFO.intValue(), this.frameCrop.toString()).dump("frameCrop", !this.frameCrop.isIdentity() && dump.level().intValue() < Level.INFO.intValue(), this.frameCrop).dump("vui", this.vui);
    }
}

