/*
 * Decompiled with CFR 0.152.
 */
package com.apple.jingle.leghorn.bitstream.avc;

import java.io.Closeable;
import java.io.EOFException;
import java.io.IOException;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;

public class RawByteSequencePayloadReader
implements Closeable {
    private final byte[] rbsp;
    private final long rbspBitLength;
    private int byteOffset = 0;
    private int bitOffset = 0;

    public RawByteSequencePayloadReader(@Nonnull byte[] rbsp) {
        int length;
        this.rbsp = rbsp;
        int bitLength = length * 8;
        boolean foundEndBit = false;
        for (length = rbsp.length; length > 0 && !foundEndBit; --length) {
            int lastByte = rbsp[length - 1];
            int bitsRemaining = 8;
            while (bitsRemaining > 0 && !foundEndBit) {
                if ((lastByte & 1) != 0) {
                    foundEndBit = true;
                }
                lastByte >>>= 1;
                --bitsRemaining;
                --bitLength;
            }
        }
        this.rbspBitLength = bitLength;
    }

    public boolean hasMoreRbspData() {
        return this.bitOffset() < this.rbspBitLength;
    }

    @Nonnegative
    private long bitOffset() {
        long offset = (long)this.byteOffset * 8L;
        if (this.bitOffset >= 0) {
            offset = offset - 1L + (long)this.bitOffset;
        }
        return offset;
    }

    @Override
    public void close() {
    }

    public boolean readBoolean() throws IOException {
        return this.readBits(1) == 1;
    }

    public int readBits(@Nonnegative int bitCount) throws IOException {
        if (this.bitOffset() + (long)bitCount > this.rbspBitLength) {
            throw new EOFException("Cannot read " + bitCount + " bit(s), only " + (this.rbspBitLength - this.bitOffset()) + " bit(s) remaining");
        }
        int returnValue = 0;
        byte data = this.rbsp[this.byteOffset];
        while (bitCount > 0) {
            returnValue <<= 1;
            returnValue |= data >>> 7 - this.bitOffset & 1;
            ++this.bitOffset;
            --bitCount;
            if (this.bitOffset <= 7) continue;
            data = this.rbsp[++this.byteOffset];
            this.bitOffset = 0;
        }
        return returnValue;
    }

    private int countZeroBits() throws IOException {
        int bitCount = 0;
        while (!this.readBoolean()) {
            ++bitCount;
        }
        return bitCount;
    }

    public int readUnsignedExponentialGolomb() throws IOException {
        int bitCount = this.countZeroBits();
        if (bitCount > 0) {
            return this.readBits(bitCount) + (1 << bitCount) - 1;
        }
        return 0;
    }

    public int readSignedExponentialGolomb() throws IOException {
        int value = this.readUnsignedExponentialGolomb();
        if ((value & 1) == 1) {
            value = -value;
        }
        return value >>= 2;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[" + this.bitOffset() + " of " + this.rbspBitLength + "]";
    }
}

