/*
 * Decompiled with CFR 0.152.
 */
package com.apple.jingle.leghorn.bitstream.avc;

import com.apple.jingle.g5.util.DataDiffSet;
import com.apple.jingle.g5.util.DataDiffable;
import com.apple.jingle.g5.util.DataDump;
import com.apple.jingle.g5.util.DataDumpable;
import com.apple.jingle.g5.util.MapDataDump;
import com.apple.jingle.g5.util.StringDataDump;
import com.apple.jingle.leghorn.bitstream.avc.NALUnit;
import com.apple.jingle.leghorn.bitstream.avc.NalUnitHeader;
import com.apple.jingle.leghorn.bitstream.avc.RawByteSequencePayloadReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;

public class PictureParameterSet
extends NALUnit
implements DataDumpable,
DataDiffable<PictureParameterSet> {
    private final int pspId;
    private final int spsId;
    private boolean entropyCodingMode;
    private boolean bottomFieldPictureOrderInFramePresent;
    private int sliceGroupMapType;
    private int numRefIdx10DefaultActive;
    private int numRefIdx11DefaultActive;
    private boolean explicitWeightedPrediction;
    private int weightedBiPredIdc;
    private int initialSliceQpyValue;
    private int initialSliceQsyValue;
    private int chromaQpIndexOffset;
    private boolean deblockingFilterControlPresent;
    private boolean constrainedIntraPrediction;
    private boolean redundantPicCountElementPresent;
    private boolean transform8x8Mode;
    private SliceGroupMap sliceGroupMap;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PictureParameterSet(@Nonnull NalUnitHeader nalUnitHeader) throws IOException {
        super(nalUnitHeader);
        try (RawByteSequencePayloadReader reader = nalUnitHeader.payloadReader();){
            this.pspId = reader.readUnsignedExponentialGolomb();
            this.spsId = reader.readUnsignedExponentialGolomb();
            this.entropyCodingMode = reader.readBoolean();
            this.bottomFieldPictureOrderInFramePresent = reader.readBoolean();
            this.sliceGroupMap = new SliceGroupMap(reader);
            this.numRefIdx10DefaultActive = reader.readUnsignedExponentialGolomb() + 1;
            this.numRefIdx11DefaultActive = reader.readUnsignedExponentialGolomb() + 1;
            this.explicitWeightedPrediction = reader.readBoolean();
            this.weightedBiPredIdc = reader.readBits(2);
            this.initialSliceQpyValue = reader.readSignedExponentialGolomb() + 26;
            this.initialSliceQsyValue = reader.readSignedExponentialGolomb() + 26;
            this.chromaQpIndexOffset = reader.readSignedExponentialGolomb();
            this.deblockingFilterControlPresent = reader.readBoolean();
            this.constrainedIntraPrediction = reader.readBoolean();
            this.redundantPicCountElementPresent = reader.readBoolean();
            if (reader.hasMoreRbspData()) {
                this.transform8x8Mode = reader.readBoolean();
            }
        }
    }

    public String toString() {
        return StringDataDump.toString(this);
    }

    @Override
    public void diff(@Nonnull DataDiffSet diffs, @Nonnull String prefix, @Nonnull PictureParameterSet compareTo) {
        MapDataDump.diff(diffs, prefix, this, compareTo);
    }

    @Override
    public void dumpData(@Nonnull DataDump dump) {
        dump.write("ppsId", this.pspId).write("spsId", this.spsId).write("entropyCodingMode", this.entropyCodingMode).write("sliceGroupMapType", this.sliceGroupMapType).write("bottomFieldPictureOrderInFramePresent", this.bottomFieldPictureOrderInFramePresent).write("numRefIdx10DefaultActive", this.numRefIdx10DefaultActive != 1, this.numRefIdx10DefaultActive).write("numRefIdx11DefaultActive", this.numRefIdx11DefaultActive != 1, this.numRefIdx11DefaultActive).write("explicitWeightedPrediction", this.explicitWeightedPrediction).write("weightedBiPredIdc", this.weightedBiPredIdc).write("initialSliceQpyValue", this.initialSliceQpyValue != 26, this.initialSliceQpyValue).write("initialSliceQsyValue", this.initialSliceQsyValue != 26, this.initialSliceQsyValue).write("chromaQpIndexOffset", this.chromaQpIndexOffset).write("deblockingFilterControlPresent", this.deblockingFilterControlPresent).write("constrainedIntraPrediction", this.constrainedIntraPrediction).write("redundantPicCountElementPresent", this.redundantPicCountElementPresent).write("transform8x8Mode", this.transform8x8Mode);
    }

    @Nonnegative
    public int pspId() {
        return this.pspId;
    }

    @Nonnegative
    public int spsId() {
        return this.spsId;
    }

    public boolean entropyCodingMode() {
        return this.entropyCodingMode;
    }

    public boolean bottomFieldPictureOrderInFramePresent() {
        return this.bottomFieldPictureOrderInFramePresent;
    }

    public int getSliceGroupMapType() {
        return this.sliceGroupMapType;
    }

    @Nonnegative
    public int numRefIdx10DefaultActive() {
        return this.numRefIdx10DefaultActive;
    }

    @Nonnegative
    public int numRefIdx11DefaultActive() {
        return this.numRefIdx11DefaultActive;
    }

    public boolean explicitWeightedPrediction() {
        return this.explicitWeightedPrediction;
    }

    public int getWeightBiPredIdc() {
        return this.weightedBiPredIdc;
    }

    public int initialSliceQpyValue() {
        return this.initialSliceQpyValue;
    }

    public int initialSliceQsyValue() {
        return this.initialSliceQsyValue;
    }

    public int chromaQpIndexOffset() {
        return this.chromaQpIndexOffset;
    }

    public boolean deblockingFilterControlPresent() {
        return this.deblockingFilterControlPresent;
    }

    public boolean constrainedIntraPrediction() {
        return this.constrainedIntraPrediction;
    }

    public boolean redundantPicCountElementPresent() {
        return this.redundantPicCountElementPresent;
    }

    public static class SliceGroupMap {
        private int type;
        private final List<SliceInfo> sliceInfo;

        public SliceGroupMap(@Nonnull RawByteSequencePayloadReader reader) throws IOException {
            block8: {
                block7: {
                    int groups = reader.readUnsignedExponentialGolomb() + 1;
                    if (groups <= 1) break block7;
                    this.type = reader.readUnsignedExponentialGolomb();
                    switch (this.type) {
                        case 0: {
                            this.sliceInfo = new ArrayList<SliceInfo>(groups);
                            for (int groupId = 0; groupId < groups; ++groupId) {
                                this.sliceInfo.add(new SliceGroupRunLength(reader, groupId));
                            }
                            break block8;
                        }
                        case 2: {
                            this.sliceInfo = new ArrayList<SliceInfo>(groups);
                            for (int groupId = 0; groupId < groups; ++groupId) {
                                this.sliceInfo.add(new SliceGroupPosition(reader, groupId));
                            }
                            break block8;
                        }
                        case 3: 
                        case 4: 
                        case 5: {
                            this.sliceInfo = new ArrayList<SliceInfo>(1);
                            this.sliceInfo.add(new SliceGroupChangeData(reader));
                            break;
                        }
                        default: {
                            this.sliceInfo = Collections.emptyList();
                            break;
                        }
                    }
                    break block8;
                }
                this.sliceInfo = Collections.emptyList();
            }
        }

        public String toString() {
            return this.getClass().getSimpleName() + "[" + "type=" + this.type + ", " + this.sliceInfo + "]";
        }

        public static class SliceGroupChangeData
        implements SliceInfo {
            private final boolean changeDirection;
            private final long changeRate;

            public SliceGroupChangeData(@Nonnull RawByteSequencePayloadReader reader) throws IOException {
                this.changeDirection = reader.readBoolean();
                this.changeRate = reader.readUnsignedExponentialGolomb() + 1;
            }

            public String toString() {
                return this.getClass().getSimpleName() + "[changeDirection=" + this.changeDirection + ", changeRate=" + this.changeRate + "]";
            }
        }

        public static class SliceGroupPosition
        implements SliceInfo {
            private final int groupId;
            private final long topLeft;
            private final long bottomRight;

            public SliceGroupPosition(@Nonnull RawByteSequencePayloadReader reader, int groupId) throws IOException {
                this.groupId = groupId;
                this.topLeft = reader.readUnsignedExponentialGolomb();
                this.bottomRight = reader.readUnsignedExponentialGolomb();
            }

            public String toString() {
                return this.getClass().getSimpleName() + "[groupId=" + this.groupId + ", topLeft=" + this.topLeft + ", bottomRight=" + this.bottomRight + "]";
            }
        }

        public static class SliceGroupRunLength
        implements SliceInfo {
            private final int groupId;
            private final long runLength;

            public SliceGroupRunLength(@Nonnull RawByteSequencePayloadReader reader, int groupId) throws IOException {
                this.groupId = groupId;
                this.runLength = reader.readUnsignedExponentialGolomb();
            }

            public String toString() {
                return this.getClass().getSimpleName() + "[groupId=" + this.groupId + ", runLength=" + this.runLength + "]";
            }
        }

        public static interface SliceInfo {
        }
    }
}

