/*
 * Decompiled with CFR 0.152.
 */
package com.apple.jingle.leghorn.bitstream.avc;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nonnull;

public interface NalUnitType {
    public int getCode();

    public static enum Defined implements NalUnitType
    {
        unspecified(0),
        slice(1),
        dpa(2),
        dpb(3),
        dpc(4),
        idrSlice(5),
        sei(6),
        sps(7),
        pps(8),
        aud(9),
        endOfSequence(10),
        endOfStream(11),
        fillerData(12),
        spsExtension(13),
        prefixNalUnitRbsp(14),
        subsetSeqParameterSetRbsp(15),
        reserved16(16),
        reserved17(17),
        reserved18(18),
        auxiliarySlice(19),
        codedSliceInScalableExtension(20),
        reserved21(21),
        reserved22(22),
        reserved23(23),
        unspecified24(24),
        unspecified25(25),
        unspecified26(26),
        unspecified27(27),
        unspecified28(28),
        unspecified29(29),
        aggregator(30),
        extractor(31);

        private final int code;
        static Map<Integer, NalUnitType> valueMap;

        private Defined(int code) {
            this.code = code;
        }

        @Override
        public int getCode() {
            return this.code;
        }

        private static Map<Integer, NalUnitType> map() {
            Defined[] values = Defined.values();
            HashMap<Integer, NalUnitType> map = new HashMap<Integer, NalUnitType>(values.length);
            for (Defined v : values) {
                map.put(v.getCode(), v);
            }
            return map;
        }

        @Nonnull
        public static NalUnitType forCode(int code) {
            NalUnitType unitType = valueMap.get(code);
            if (null != unitType) {
                return unitType;
            }
            return new Undefined(code);
        }

        static {
            valueMap = Collections.unmodifiableMap(Defined.map());
        }
    }

    public static class Undefined
    implements NalUnitType {
        private final int code;

        private Undefined(int code) {
            this.code = code;
        }

        @Override
        public int getCode() {
            return this.code;
        }

        public int hashCode() {
            return this.code;
        }

        public boolean equals(Object obj) {
            return obj instanceof Undefined && ((Undefined)obj).code == this.code;
        }

        public String toString() {
            return "NalUnitType[" + this.code + "]";
        }
    }
}

