/*
 * Decompiled with CFR 0.152.
 */
package com.apple.jingle.leghorn.bitstream.avc;

import com.apple.jingle.leghorn.bitstream.avc.NalUnitType;
import com.apple.jingle.leghorn.bitstream.avc.RawByteSequencePayloadReader;
import com.apple.jingle.media.foundation.io.ByteArraySeekableDataInput;
import com.apple.jingle.media.foundation.io.SeekableDataInput;
import java.io.IOException;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;

public class NalUnitHeader {
    @Nonnull
    private final int forbiddenZeroBit;
    @Nonnull
    private final int refIdc;
    @Nonnull
    private final NalUnitType unitType;
    private final int numBytesInNalUnit;
    private final byte[] svcExtension;
    private final byte[] avc3dExtension;
    private final byte[] mvcExtension;
    private final byte[] rbsp;

    public NalUnitHeader(@Nonnull SeekableDataInput reader, @Nonnegative int numBytesInNalUnit) throws IOException {
        this.numBytesInNalUnit = numBytesInNalUnit--;
        int data = reader.readUnsignedByte();
        this.forbiddenZeroBit = data >> 7 & 1;
        this.refIdc = data >> 5 & 3;
        this.unitType = NalUnitType.Defined.forCode(data & 0x1F);
        int unitTypeCode = this.unitType.getCode();
        boolean svcExtensionFlag = false;
        boolean avc3dExtensionFlag = false;
        boolean mvcExtensionFlag = false;
        byte[] svcExtension = null;
        byte[] avc3dExtension = null;
        byte[] mvcExtension = null;
        switch (unitTypeCode) {
            case 14: {
                svcExtensionFlag = reader.readBoolean();
                mvcExtensionFlag = !svcExtensionFlag;
                break;
            }
            case 20: {
                svcExtensionFlag = reader.readBoolean();
                mvcExtensionFlag = !svcExtensionFlag;
                break;
            }
            case 21: {
                avc3dExtensionFlag = reader.readBoolean();
                boolean bl = mvcExtensionFlag = !avc3dExtensionFlag;
            }
        }
        if (svcExtensionFlag) {
            svcExtension = new byte[3];
            reader.readFully(svcExtension);
            numBytesInNalUnit -= svcExtension.length;
        } else if (avc3dExtensionFlag) {
            avc3dExtension = new byte[2];
            reader.readFully(avc3dExtension);
            numBytesInNalUnit -= avc3dExtension.length;
        } else if (mvcExtensionFlag) {
            mvcExtension = new byte[3];
            reader.readFully(mvcExtension);
            numBytesInNalUnit -= mvcExtension.length;
        }
        this.svcExtension = svcExtension;
        this.avc3dExtension = avc3dExtension;
        this.mvcExtension = mvcExtension;
        if (numBytesInNalUnit < 0) {
            this.rbsp = new byte[0];
        } else {
            byte[] rbspData = new byte[numBytesInNalUnit];
            int lastData = 0;
            int pos = 0;
            while (numBytesInNalUnit-- > 0) {
                int b = reader.readUnsignedByte();
                lastData <<= 8;
                if (pos >= 2 && ((lastData |= b) & 0xFFFFFF) == 3) continue;
                rbspData[pos++] = (byte)b;
            }
            this.rbsp = new byte[pos];
            System.arraycopy(rbspData, 0, this.rbsp, 0, pos);
        }
    }

    public int refIdc() {
        return this.refIdc;
    }

    @Nonnull
    public NalUnitType unitType() {
        return this.unitType;
    }

    @Nonnull
    public ByteArraySeekableDataInput payloadDataInput() {
        return new ByteArraySeekableDataInput(this.rbsp, (long)this.rbsp.length);
    }

    @Nonnull
    public RawByteSequencePayloadReader payloadReader() throws IOException {
        return new RawByteSequencePayloadReader(this.rbsp);
    }

    @Nonnegative
    public int numBytesInNalUnit() {
        return this.numBytesInNalUnit;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[" + "unitType=" + this.unitType + ", " + "refIdc=" + this.refIdc + "]";
    }
}

