/*
 * Decompiled with CFR 0.152.
 */
package com.apple.jingle.leghorn.bitstream.avc;

import com.apple.jingle.leghorn.LeghornValidationContext;
import com.apple.jingle.leghorn.bitstream.avc.AccessUnitDelimeter;
import com.apple.jingle.leghorn.bitstream.avc.NALUnit;
import com.apple.jingle.leghorn.bitstream.avc.NalUnitHeader;
import com.apple.jingle.leghorn.bitstream.avc.NalUnitType;
import com.apple.jingle.leghorn.bitstream.avc.PictureParameterSet;
import com.apple.jingle.leghorn.bitstream.avc.SequenceParameterSet;
import com.apple.jingle.leghorn.bitstream.avc.SupplementalEnhancementInformation;
import com.apple.jingle.leghorn.bitstream.avc.sei.PicTiming;
import com.apple.jingle.media.foundation.io.SeekableDataInput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;

public class NALUByteStream {
    public static final byte[] BEGINNING_OF_AVC_BITSTREAM = new byte[]{0, 0, 0, 1};
    public static final byte[] THREE_BYTE_SEQUENCE_1 = new byte[]{0, 0, 0};
    public static final byte[] THREE_BYTE_SEQUENCE_2 = new byte[]{0, 0, 1};
    public List<byte[]> nalUnits = new ArrayList<byte[]>();
    public List<NALUnit> parsedNalUnits = new ArrayList<NALUnit>();
    public SequenceParameterSet currentSPS = null;
    public static final Map<Long, Class<? extends NALUnit>> MAP_OF_NAL_U_TYPE_TO_CLASS = new HashMap<Long, Class<? extends NALUnit>>();

    public void parse(@Nonnull LeghornValidationContext ctx, SeekableDataInput sdi) throws IOException {
        byte[] naluBuffer = new byte[4];
        sdi.readFully(naluBuffer);
        while (!Arrays.equals(naluBuffer, BEGINNING_OF_AVC_BITSTREAM)) {
            sdi.seek(sdi.getFilePointer() - 3L);
            sdi.readFully(naluBuffer);
        }
        sdi.seek(sdi.getFilePointer() - 3L);
        naluBuffer = new byte[3];
        while (sdi.getFilePointer() < sdi.length()) {
            sdi.readFully(naluBuffer);
            while (!Arrays.equals(naluBuffer, THREE_BYTE_SEQUENCE_2)) {
                sdi.seek(sdi.getFilePointer() - 2L);
                sdi.readFully(naluBuffer);
            }
            int naluStart = (int)sdi.getFilePointer();
            sdi.readFully(naluBuffer);
            while (!Arrays.equals(naluBuffer, THREE_BYTE_SEQUENCE_1) && !Arrays.equals(naluBuffer, THREE_BYTE_SEQUENCE_2)) {
                sdi.seek(sdi.getFilePointer() - 2L);
                sdi.readFully(naluBuffer);
            }
            int naluEnd = (int)sdi.getFilePointer() - 4;
            sdi.seek((long)naluStart);
            NalUnitHeader nalUnitHeader = new NalUnitHeader(sdi, naluEnd - naluStart + 1);
            long nalRefIDC = nalUnitHeader.refIdc();
            NalUnitType nalUnitType = nalUnitHeader.unitType();
            NALUnit currentNalUnit = null;
            if (nalUnitType instanceof NalUnitType.Defined) {
                switch ((NalUnitType.Defined)nalUnitType) {
                    case sps: {
                        currentNalUnit = new SequenceParameterSet(nalUnitHeader);
                        break;
                    }
                    case pps: {
                        currentNalUnit = new PictureParameterSet(nalUnitHeader);
                        break;
                    }
                }
            }
            if (null == currentNalUnit) {
                currentNalUnit = new NALUnit();
                long nalUType = nalUnitType.getCode();
                if (MAP_OF_NAL_U_TYPE_TO_CLASS.containsKey(nalUType)) {
                    try {
                        currentNalUnit = MAP_OF_NAL_U_TYPE_TO_CLASS.get(nalUType).newInstance();
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                }
                currentNalUnit.setAttributes(nalRefIDC, nalUType, nalUnitHeader.numBytesInNalUnit(), this);
                currentNalUnit.parse(this, (SeekableDataInput)nalUnitHeader.payloadDataInput());
            }
            this.parsedNalUnits.add(currentNalUnit);
            if (!(currentNalUnit instanceof SequenceParameterSet)) continue;
            this.currentSPS = (SequenceParameterSet)currentNalUnit;
        }
    }

    public PictureParameterSet getPPS() {
        for (NALUnit nalUnit : this.parsedNalUnits) {
            if (!(nalUnit instanceof PictureParameterSet)) continue;
            return (PictureParameterSet)nalUnit;
        }
        return null;
    }

    public SequenceParameterSet getSPS() {
        for (NALUnit nalUnit : this.parsedNalUnits) {
            if (!(nalUnit instanceof SequenceParameterSet)) continue;
            return (SequenceParameterSet)nalUnit;
        }
        return null;
    }

    public PicTiming getPicTiming() {
        for (NALUnit nalUnit : this.parsedNalUnits) {
            if (!(nalUnit instanceof SequenceParameterSet)) continue;
            return (PicTiming)nalUnit;
        }
        return null;
    }

    static {
        MAP_OF_NAL_U_TYPE_TO_CLASS.put(6L, SupplementalEnhancementInformation.class);
        MAP_OF_NAL_U_TYPE_TO_CLASS.put(7L, SequenceParameterSet.class);
        MAP_OF_NAL_U_TYPE_TO_CLASS.put(8L, PictureParameterSet.class);
        MAP_OF_NAL_U_TYPE_TO_CLASS.put(9L, AccessUnitDelimeter.class);
    }
}

