/*
 * Decompiled with CFR 0.152.
 */
package com.apple.jingle.leghorn.bitstream.aac;

import com.apple.jingle.media.foundation.io.SeekableDataInput;
import com.apple.jingle.media.foundation.util.BitReader;
import java.io.IOException;

public class ADTSByteStream {
    boolean doneParsing = false;
    long id;
    long layer;
    long protectionAbsent;
    long profile;
    long samplingFreqeuncyIndex;
    long privateBit;
    long channelConfiguration;
    long originalCopy;
    long home;
    long copyrightIdentificationBit;
    long copyrightIdentificationStart;
    long frameLength;
    long adtsBufferFullness;
    long numberOfRawDataBlocksInFrame;

    public void parse(SeekableDataInput sdi) throws IOException {
        if (!this.doneParsing) {
            byte[] buffer = new byte[2];
            sdi.readFully(buffer);
            BitReader bitReader = new BitReader(buffer);
            long possibleSyncWord = bitReader.readUBits(12);
            while (possibleSyncWord != 4095L) {
                sdi.seek(sdi.getFilePointer() - 1L);
                sdi.readFully(buffer);
                bitReader = new BitReader(buffer);
                possibleSyncWord = bitReader.readUBits(12);
            }
            sdi.seek(sdi.getFilePointer() - 2L);
            buffer = new byte[9];
            sdi.readFully(buffer);
            bitReader = new BitReader(buffer);
            bitReader.readUBits(12);
            this.id = bitReader.readUBits(1);
            this.layer = bitReader.readUBits(2);
            this.protectionAbsent = bitReader.readUBits(1);
            this.profile = bitReader.readUBits(2);
            this.samplingFreqeuncyIndex = bitReader.readUBits(4);
            this.privateBit = bitReader.readUBits(1);
            this.channelConfiguration = bitReader.readUBits(3);
            this.originalCopy = bitReader.readUBits(1);
            this.home = bitReader.readUBits(1);
            this.copyrightIdentificationBit = bitReader.readUBits(1);
            this.copyrightIdentificationStart = bitReader.readUBits(1);
            this.frameLength = bitReader.readUBits(13);
            this.adtsBufferFullness = bitReader.readUBits(11);
            this.numberOfRawDataBlocksInFrame = bitReader.readUBits(2);
            this.doneParsing = true;
        }
    }

    public long getId() {
        return this.id;
    }

    public long getLayer() {
        return this.layer;
    }

    public long getProtectionAbsent() {
        return this.protectionAbsent;
    }

    public long getProfile() {
        return this.profile;
    }

    public long getSamplingFreqeuncyIndex() {
        return this.samplingFreqeuncyIndex;
    }

    public long getPrivateBit() {
        return this.privateBit;
    }

    public long getChannelConfiguration() {
        return this.channelConfiguration;
    }

    public long getOriginalCopy() {
        return this.originalCopy;
    }

    public long getHome() {
        return this.home;
    }

    public long getCopyrightIdentificationBit() {
        return this.copyrightIdentificationBit;
    }

    public long getCopyrightIdentificationStart() {
        return this.copyrightIdentificationStart;
    }

    public long getFrameLength() {
        return this.frameLength;
    }

    public long getAdtsBufferFullness() {
        return this.adtsBufferFullness;
    }

    public long getNumberOfRawDataBlocksInFrame() {
        return this.numberOfRawDataBlocksInFrame;
    }

    public String toString() {
        return "ADTSByteStream{id=" + this.id + ", layer=" + this.layer + ", protectionAbsent=" + this.protectionAbsent + ", profile=" + this.profile + ", samplingFreqeuncyIndex=" + this.samplingFreqeuncyIndex + ", privateBit=" + this.privateBit + ", channelConfiguration=" + this.channelConfiguration + ", originalCopy=" + this.originalCopy + ", home=" + this.home + ", copyrightIdentificationBit=" + this.copyrightIdentificationBit + ", copyrightIdentificationStart=" + this.copyrightIdentificationStart + ", frameLength=" + this.frameLength + ", adtsBufferFullness=" + this.adtsBufferFullness + ", numberOfRawDataBlocksInFrame=" + this.numberOfRawDataBlocksInFrame + '}';
    }
}

