/*
 * Decompiled with CFR 0.152.
 */
package com.apple.jingle.leghorn.audio.wav;

import com.apple.jingle.leghorn.audio.describe.WavDescriptionWriter;
import com.apple.jingle.leghorn.audio.helpers.AudioDescriptionException;
import com.apple.jingle.leghorn.audio.helpers.ValidationService;
import com.apple.jingle.leghorn.audio.provide.Provider;
import com.apple.jingle.leghorn.media.MediaValidationCode;
import java.io.IOException;
import org.apache.log4j.Logger;

public class WavValidator {
    private static final Logger log = Logger.getLogger(WavValidator.class);
    private static final int PCM = 1;
    private static final int FLOAT = 3;
    private static final int FMT_BYTES_READ = 18;
    private Provider provider;
    private ValidationService service;
    private WavDescriptionWriter writer;
    private int channels;
    private int blockAlign;
    private int bitsPerSample;
    private int formatCode;
    private int sampleRate;
    private int aveBytesPerSec;
    private int riffChunkSize;
    private boolean isPCM;
    private boolean isExtensible;
    private boolean isFloat;
    private String format;
    private String subFormat;

    public WavValidator(Provider provider, ValidationService service) {
        this.provider = provider;
        this.service = service;
        this.writer = (WavDescriptionWriter)service.getWriter();
        this.isPCM = false;
        this.isExtensible = false;
        this.isFloat = false;
    }

    public void validate() throws AudioDescriptionException, IOException {
        int chunkID_RIFF = this.provider.bigEndianBytesAsInt(4);
        this.service.failOn(chunkID_RIFF != 1380533830, "Missing or invalid RIFF header. Found: " + chunkID_RIFF + ", should be " + 1380533830 + ". File: " + this.service.getFileName(), MediaValidationCode.AUD_CONTAINER_INCOMPATIBLE);
        log.trace((Object)"RIFF header found");
        this.checkRIFFChunk();
        while (!this.service.isEof()) {
            this.checkChunk();
        }
    }

    private void checkRIFFChunk() throws IOException, AudioDescriptionException {
        log.debug((Object)"Checking RIFF information");
        this.riffChunkSize = this.provider.littleEndianBytesAsInt(4);
        int waveID = this.provider.bigEndianBytesAsInt(4);
        this.service.failOn(waveID != 1463899717, "Missing or invalid WAVE header. Found " + waveID + ", should be 0x57415645. File: " + this.service.getFileName(), MediaValidationCode.AUD_CONTAINER_INCOMPATIBLE);
        log.trace((Object)"WAVE header found");
        this.writer.writeRiffChunk("RIFF", this.riffChunkSize, "WAVE");
    }

    private void checkFormatChunk() throws IOException, AudioDescriptionException {
        log.trace((Object)"Checking format chunk");
        int formatChunkSize = this.wordBoundary(this.provider.littleEndianBytesAsInt(4));
        this.formatCode = this.provider.littleEndianBytesAsInt(2);
        if (this.formatCode == 1) {
            this.isPCM = true;
        } else if (this.formatCode == 3) {
            this.isFloat = true;
        } else if (this.formatCode == 65534) {
            this.isExtensible = true;
        } else {
            this.service.failOn(true, "Invalid audio data format found. Wave audio data format should be PCM or in IEEE floating point format. Other audio data formats are not supported at this time. File: " + this.service.getFileName(), MediaValidationCode.AUD_APPEARS_CORRUPT);
        }
        this.format = this.isPCM ? "PCM" : (this.isFloat ? "IEEE floating point" : "Extensible");
        this.writer.writeFormatHeader("fmt", formatChunkSize, this.formatCode, this.format);
        this.commonFormatData();
        if (formatChunkSize > 16) {
            int extensionSize = this.provider.littleEndianBytesAsInt(2);
            if (this.isExtensible) {
                this.checkExtensibleFormat(extensionSize);
            } else {
                this.service.errorOn(extensionSize != 0, "Invalid format chunk extension size: " + extensionSize + ". Extension size must be 0 unless extensible format is used. File: " + this.service.getFileName());
                this.provider.skipBytes(formatChunkSize - 18);
            }
        }
    }

    private void commonFormatData() throws IOException, AudioDescriptionException {
        this.channels = this.provider.littleEndianBytesAsInt(2);
        this.sampleRate = this.provider.littleEndianBytesAsInt(4);
        this.aveBytesPerSec = this.provider.littleEndianBytesAsInt(4);
        this.blockAlign = this.provider.littleEndianBytesAsInt(2);
        this.bitsPerSample = this.provider.littleEndianBytesAsInt(2);
        this.writer.writeCommonData(this.channels, this.sampleRate, this.aveBytesPerSec, this.blockAlign, this.bitsPerSample);
    }

    private void checkExtensibleFormat(int extensionSize) throws IOException, AudioDescriptionException {
        this.service.errorOn(extensionSize != 22, "For Extensible Format the extension size should be 22. Found " + extensionSize);
        int validBPS = this.provider.littleEndianBytesAsInt(2);
        this.service.errorOn(validBPS > this.bitsPerSample, "Valid bits per sample, " + validBPS + " cannot exceed sample size: " + this.bitsPerSample + ". File: " + this.service.getFileName());
        int channelMask = this.provider.littleEndianBytesAsInt(4);
        int subFormatCode = this.provider.littleEndianBytesAsInt(2);
        this.service.failOn(subFormatCode != 1 && subFormatCode != 3, "Invalid audio data sub-format type. Extensible audio data should be in PCM or IEEE floating point format. Other audio data formats are not supported at this time. File: " + this.service.getFileName(), MediaValidationCode.AUD_APPEARS_CORRUPT);
        this.subFormat = "PCM";
        long extension1 = this.provider.bigEndianBytesAsLong(7);
        this.service.errorOn(extension1 != 0x100080L, "First 7 bytes after the subformat are " + extension1 + ", should be " + 0x100080L + ". File: " + this.service.getFileName());
        long extension2 = this.provider.bigEndianBytesAsLong(7);
        this.service.errorOn(extension2 != 730148150129L, "Second 7 bytes after the subformat are " + extension2 + ", should be " + 730148150129L + ". File: " + this.service.getFileName());
        this.writer.writeExtensible(validBPS, channelMask, this.subFormat);
    }

    private void checkDataChunk() throws IOException {
        log.trace((Object)"Checking data chunk");
        int audioDataSize = this.wordBoundary(this.provider.littleEndianBytesAsInt(4));
        if (audioDataSize > 0) {
            this.provider.skipBytes(audioDataSize);
        }
        this.writer.writeData("data", audioDataSize);
    }

    private void checkChunk() throws IOException, AudioDescriptionException {
        int chunkID = this.provider.bigEndianBytesAsInt(4);
        switch (chunkID) {
            case 1380533830: {
                this.checkRIFFChunk();
                break;
            }
            case 1718449184: {
                this.checkFormatChunk();
                break;
            }
            case 1684108385: {
                this.checkDataChunk();
                break;
            }
            case 1667788385: {
                this.hasChannelAllocations();
                break;
            }
            case 1635282284: {
                this.hasADMXml();
                break;
            }
            default: {
                this.checkNewChunk();
            }
        }
    }

    private void hasChannelAllocations() throws IOException {
        this.writer.setChannelAllocations(true);
        this.checkNewChunk();
    }

    private void hasADMXml() throws IOException {
        this.writer.setADMXml(true);
        this.checkNewChunk();
    }

    private void checkNewChunk() throws IOException {
        int chunkSize = this.wordBoundary(this.provider.littleEndianBytesAsInt(4));
        if (chunkSize > 0) {
            this.provider.skipBytes(chunkSize);
        }
    }

    private int wordBoundary(int chunkSize) {
        return chunkSize % 2 == 0 ? chunkSize : chunkSize + 1;
    }
}

