/*
 * Decompiled with CFR 0.152.
 */
package com.apple.jingle.leghorn.audio.wav;

import com.apple.jingle.leghorn.audio.describe.WavDescriptionWriter;
import com.apple.jingle.leghorn.audio.helpers.AudioDescriptionException;
import com.apple.jingle.leghorn.audio.helpers.DescriptionSetter;
import com.apple.jingle.leghorn.audio.helpers.ValidationService;
import com.apple.jingle.leghorn.audio.wav.WavValidator;
import com.apple.jingle.leghorn.fileformat.ValidationListener;
import com.apple.jingle.media.foundation.io.SeekableDataInput;
import java.io.IOException;
import org.apache.log4j.Logger;

public class WavValidationService
extends ValidationService {
    private static final Logger log = Logger.getLogger(WavValidationService.class);
    private WavValidator validator;

    @Override
    public WavDescriptionWriter getWriter() {
        return (WavDescriptionWriter)this.writer;
    }

    public void setWriter(WavDescriptionWriter wavWriter) {
        this.writer = wavWriter;
    }

    public void writeFileSize(long byteCount) {
        this.getWriter().writeFileSize(byteCount);
    }

    public WavValidationService(SeekableDataInput sdi, ValidationListener listener, boolean locality, String uti, String type) {
        super(sdi, listener, locality, uti, type);
        this.setWriter((WavDescriptionWriter)DescriptionSetter.setWriter(uti, type));
        this.attachToProvider();
        this.validator = new WavValidator(this.getProvider(), this);
    }

    private void attachToProvider() {
        this.getProvider().attach(this);
    }

    @Override
    public void eofReached() {
        this.setEof(true);
        this.getWriter().writeFileSize(this.getFileSize());
        this.finishUp();
    }

    @Override
    public void finishUp() {
        super.finishUp();
        try {
            this.getWriter().writeValidationReport(this.getErrors(), this.getWarnings());
            if (this.isLocal()) {
                this.getWriter().writeFile(this.getOutputFileName());
            } else {
                this.getWriter().writeFile();
            }
        }
        catch (IOException e) {
            log.error((Object)"Could not write description document.", (Throwable)e);
        }
    }

    @Override
    public void validate() throws AudioDescriptionException, IOException {
        this.validator.validate();
    }

    @Override
    public int getFrame() {
        return 0;
    }
}

