/*
 * Decompiled with CFR 0.152.
 */
package com.apple.jingle.leghorn.audio.provide;

import com.apple.jingle.leghorn.audio.helpers.AudioDescriptionException;
import com.apple.jingle.leghorn.audio.helpers.CRC_Checker;
import com.apple.jingle.leghorn.audio.helpers.ValidationService;
import com.apple.jingle.leghorn.audio.provide.Provider;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import org.apache.log4j.Logger;

public class BitReader
implements Provider {
    private static final Logger log = Logger.getLogger(BitReader.class);
    private static final int[][] offsetMap = new int[][]{{0}, {0, 1}, {0, 2, 3}, {0, 4, 6, 7}, {0, 8, 12, 14, 15}, {0, 16, 24, 28, 30, 31}, {0, 32, 48, 56, 60, 62, 63}, {0, 64, 96, 112, 120, 124, 126, 127}, {0, 128, 192, 224, 240, 248, 252, 254, 255}};
    protected InputStream stream;
    private int offset;
    private int currentByte;
    private int bytesRead;
    private ByteArrayOutputStream recording;
    private boolean recordButtonOn;
    private ValidationService validator;

    public BitReader(InputStream stream) {
        this.stream = stream;
        this.recordButtonOn = false;
        this.bytesRead = 0;
    }

    @Override
    public long bitsAsLong(int bits) throws IOException {
        if (bits <= 0) {
            return 0L;
        }
        this.fillIfEmpty();
        if (bits <= this.offset) {
            return this.bitReader(bits);
        }
        int remaining = bits - this.offset;
        int bytes = remaining >> 3;
        if ((remaining %= 8) > 0) {
            long part = (this.bitReader(this.offset) << (bytes << 3) + remaining) + (this.bigEndianByteReader(bytes) << remaining);
            this.fillIfEmpty();
            return part + this.bitReader(remaining);
        }
        return (this.bitReader(this.offset) << (bytes << 3)) + this.bigEndianByteReader(bytes);
    }

    @Override
    public int bitsAsInt(int bits) throws IOException {
        return (int)this.bitsAsLong(bits);
    }

    @Override
    public long bigEndianBytesAsLong(int bytes) throws IOException {
        if (bytes <= 0) {
            return 0L;
        }
        if (this.offset == 0) {
            return this.bigEndianByteReader(bytes);
        }
        return this.bitsAsLong(bytes << 3);
    }

    @Override
    public long littleEndianBytesAsLong(int bytes) throws IOException {
        if (bytes <= 0) {
            return 0L;
        }
        long result = 0L;
        for (int i = 0; i < bytes; ++i) {
            result += (long)(this.getByte(false) << (i << 3));
        }
        return result;
    }

    @Override
    public int bigEndianBytesAsInt(int bytes) throws IOException {
        return (int)this.bigEndianBytesAsLong(bytes);
    }

    @Override
    public int littleEndianBytesAsInt(int bytes) throws IOException {
        return (int)this.littleEndianBytesAsLong(bytes);
    }

    protected long bitReader(int bits) throws IOException {
        assert (bits < 8);
        int result = (this.currentByte & offsetMap[this.offset][bits]) >> this.offset - bits;
        this.offset -= bits;
        return result;
    }

    protected long bigEndianByteReader(int bytes) throws IOException {
        if (bytes <= 0) {
            return 0L;
        }
        assert (this.offset == 0);
        long result = 0L;
        for (int i = 0; i < bytes; ++i) {
            result <<= 8;
            result += (long)this.getByte(false);
        }
        return result;
    }

    @Override
    public void skipBits(int bits) throws IOException {
        if (bits <= 0) {
            return;
        }
        this.fillIfEmpty();
        if (bits <= this.offset) {
            this.bitSkip(bits);
        } else {
            int remaining = bits - this.offset;
            int bytes = remaining >> 3;
            this.bitSkip(this.offset);
            this.byteSkip(bytes);
            if ((remaining %= 8) > 0) {
                this.fillIfEmpty();
                this.bitSkip(remaining);
            }
        }
    }

    @Override
    public void skipBytes(int bytes) throws IOException {
        if (bytes <= 0) {
            return;
        }
        if (this.offset == 0) {
            this.byteSkip(bytes);
        } else {
            this.skipBits(bytes << 3);
        }
    }

    protected void bitSkip(int bits) throws IOException {
        this.offset -= bits;
    }

    protected void byteSkip(int bytes) throws IOException {
        assert (this.offset == 0);
        for (int i = 0; i < bytes; ++i) {
            this.getByte(false);
        }
    }

    private void fillIfEmpty() throws IOException {
        if (this.offset == 0) {
            this.getByte(true);
        }
    }

    private int getByte(boolean reset) throws IOException {
        try {
            this.currentByte = this.stream.read();
            if (this.currentByte < 0) {
                throw new HitEndOfFileException();
            }
            if (this.recordButtonOn) {
                this.record((byte)this.currentByte);
            }
            ++this.bytesRead;
            this.offset = reset ? 8 : this.offset;
        }
        catch (IOException e) {
            this.notifyValidator();
            this.close();
            throw e;
        }
        return this.currentByte;
    }

    private void record(byte bite) {
        this.recording.write(bite);
    }

    @Override
    public void startRecording() {
        this.recordButtonOn = true;
        this.recording = new ByteArrayOutputStream();
    }

    @Override
    public void stopRecording() {
        this.recordButtonOn = false;
    }

    @Override
    public void processCRC(int footer) throws IOException, AudioDescriptionException {
        new CRC_Checker(this.recording.toByteArray(), this.validator, footer).run();
    }

    public void close() {
        try {
            this.stream.close();
        }
        catch (IOException e) {
            log.fatal((Object)"Internal memory error occured closing file stream");
        }
    }

    @Override
    public void attach(ValidationService validator) {
        this.validator = validator;
    }

    private void notifyValidator() {
        if (this.validator != null) {
            this.validator.eofReached();
        }
    }

    @Override
    public void pad() throws IOException {
        this.offset = 0;
    }

    @Override
    public int getBytesRead() {
        return this.bytesRead;
    }

    public static class HitEndOfFileException
    extends IOException {
        private static final long serialVersionUID = -1290688851529922457L;
    }
}

