/*
 * Decompiled with CFR 0.152.
 */
package com.apple.jingle.leghorn.audio.helpers;

import com.apple.jingle.leghorn.audio.helpers.AudioDescriptionException;
import com.apple.jingle.leghorn.audio.helpers.DescriptionWriter;
import com.apple.jingle.leghorn.audio.provide.GetAProvider;
import com.apple.jingle.leghorn.audio.provide.Provider;
import com.apple.jingle.leghorn.fileformat.ValidationError;
import com.apple.jingle.leghorn.fileformat.ValidationListener;
import com.apple.jingle.leghorn.fileformat.ValidationWarning;
import com.apple.jingle.leghorn.fileformat.impl.ValidationsCollector;
import com.apple.jingle.leghorn.media.MediaValidationCode;
import com.apple.jingle.media.foundation.io.SeekableDataInput;
import com.apple.jingle.media.foundation.io.SeekableInputStream;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.log4j.Logger;

public abstract class ValidationService {
    private static final Logger log = Logger.getLogger(ValidationService.class);
    protected List<String> errors = new ArrayList<String>();
    protected List<String> warnings = new ArrayList<String>();
    protected ValidationListener validationListener;
    protected Provider provider;
    protected boolean eof;
    protected boolean local;
    protected SeekableDataInput sdi;
    protected String path;
    protected DescriptionWriter writer;

    protected ValidationService(SeekableDataInput sdi, ValidationListener listener, boolean locality, String uti, String assetType) {
        this.sdi = sdi;
        this.provider = GetAProvider.getProvider(new BufferedInputStream((InputStream)new SeekableInputStream(sdi)));
        this.local = locality;
        this.validationListener = listener == null ? new ValidationsCollector() : listener;
    }

    protected void setValidationListener(ValidationListener listener) {
        this.validationListener = listener;
    }

    public List<String> getErrors() {
        return Collections.unmodifiableList(this.errors);
    }

    public void addError(String errorString) {
        this.errors.add(errorString);
        this.validationListener.error(new ValidationError(errorString));
    }

    public void addError(ValidationError error) {
        assert (error != null);
        this.validationListener.error(error);
        this.errors.add(error.getUserString());
    }

    public List<String> getWarnings() {
        return Collections.unmodifiableList(this.warnings);
    }

    public void addWarning(String errorString) {
        this.warnings.add(errorString);
        this.validationListener.warning(new ValidationWarning(errorString));
    }

    public void addWarning(ValidationWarning warning) {
        assert (warning != null);
        this.validationListener.warning(warning);
        this.warnings.add(warning.getUserString());
    }

    public String getOutputFileName() {
        return this.sdi.hashCode() + "_description.xml";
    }

    public String getFileName() {
        return this.sdi.getFileName();
    }

    public long getFileSize() {
        try {
            return this.sdi.length();
        }
        catch (IOException e) {
            return -1L;
        }
    }

    public Provider getProvider() {
        return this.provider;
    }

    public void setProvider(Provider provider) {
        this.provider = provider;
    }

    public boolean isLocal() {
        return this.local;
    }

    public boolean isEof() {
        return this.eof;
    }

    public void setEof(boolean value) {
        this.eof = value;
    }

    public void setPath(String path) {
        this.path = path;
        this.writer.setPath(path);
    }

    protected String getPath() {
        return this.path;
    }

    public abstract void validate() throws AudioDescriptionException, IOException;

    public ValidationService() {
    }

    public void showWarnings() {
        List<String> warnings = this.getWarnings();
        log.debug((Object)("No. of warnings " + warnings.size()));
        for (String warning : warnings) {
            log.warn((Object)warning);
        }
    }

    public void showErrors() {
        List<String> errors = this.getErrors();
        log.debug((Object)("No. of errors " + errors.size()));
        for (String thisError : errors) {
            log.error((Object)thisError);
        }
    }

    public void failOn(boolean condition, String message, MediaValidationCode errorCode) throws AudioDescriptionException {
        if (condition) {
            throw new AudioDescriptionException(message, errorCode);
        }
    }

    public void errorOn(boolean condition, String message) {
        if (condition) {
            this.addError(message);
        }
    }

    public void warnOn(boolean condition, String message) {
        if (condition) {
            this.addWarning(message);
        }
    }

    public void finishUp() {
        log.debug((Object)"File processed");
        this.showWarnings();
        this.showErrors();
    }

    public void eofReached() {
        this.setEof(true);
        this.finishUp();
    }

    public void report(String report) {
        this.addError(report);
    }

    public abstract int getFrame();

    public DescriptionWriter getWriter() {
        return this.writer;
    }
}

