/*
 * Decompiled with CFR 0.152.
 */
package com.apple.jingle.leghorn.audio.helpers;

import java.io.BufferedOutputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.log4j.Logger;
import org.apache.xmlbeans.XmlObject;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class DescriptionWriter {
    private static final Logger log = Logger.getLogger(DescriptionWriter.class);
    private Node assetDescription;
    private String path = "";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeFile(String fileName, XmlObject description) throws IOException {
        try (BufferedOutputStream out = new BufferedOutputStream(new FileOutputStream(this.path + fileName));){
            log.info((Object)"Writing description");
            ((OutputStream)out).write(description.toString().getBytes());
        }
    }

    public void writeFile(XmlObject description) {
        Document flacDescription = (Document)description.newDomNode();
        DocumentBuilder descriptionBuilder = null;
        try {
            descriptionBuilder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
        }
        catch (ParserConfigurationException e) {
            System.err.println("Internal error generating description document");
        }
        Document descriptor = descriptionBuilder.newDocument();
        Element describerRoot = (Element)descriptor.importNode(flacDescription.getDocumentElement(), true);
        descriptor.appendChild(describerRoot);
        this.setAssetDescription(descriptor);
    }

    private void setAssetDescription(Document descriptor) {
        this.assetDescription = descriptor;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public Node getDescriptor() {
        return this.assetDescription;
    }
}

