/*
 * Decompiled with CFR 0.152.
 */
package com.apple.jingle.leghorn.audio.flac.metadata.blocks;

import com.apple.jingle.leghorn.audio.describe.FlacDescriptionWriter;
import com.apple.jingle.leghorn.audio.flac.metadata.Metadata;
import com.apple.jingle.leghorn.audio.helpers.ValidationService;
import com.apple.jingle.leghorn.audio.provide.Provider;
import java.io.IOException;
import org.apache.log4j.Logger;

class VorbisComment
implements Metadata {
    private static final Logger log = Logger.getLogger(VorbisComment.class);
    private final int VENDOR_NAME_LENGTH_BYTES = 4;
    private final int COMMENT_LENGTH_BYTES = 4;
    private int comments;
    private int vendorNameLength;
    private String vendor = "";
    private ValidationService service;
    private FlacDescriptionWriter writer;

    public VorbisComment(ValidationService service) {
        this.service = service;
        this.writer = (FlacDescriptionWriter)service.getWriter();
    }

    @Override
    public void checkBlock(Provider provider) throws IOException {
        log.trace((Object)"Vorbis comment bock. Checking data");
        this.vendorNameLength = provider.littleEndianBytesAsInt(4);
        for (int i = 0; i < this.vendorNameLength; ++i) {
            int letter = provider.littleEndianBytesAsInt(1);
            this.vendor = this.vendor + (char)letter;
        }
        log.trace((Object)("Vendor: " + this.vendor));
        this.comments = provider.littleEndianBytesAsInt(4);
        log.trace((Object)("Number of comments " + this.comments));
        String[] vorbisComments = new String[this.comments];
        for (int i = 0; i < this.comments; ++i) {
            String comment = "";
            int commentLength = provider.littleEndianBytesAsInt(4);
            for (int j = 0; j < commentLength; ++j) {
                int letter = provider.littleEndianBytesAsInt(1);
                comment = comment + (char)letter;
            }
            log.trace((Object)("Comment length in bytes: " + commentLength));
            log.trace((Object)("Comment " + (i + 1) + ": " + comment));
            vorbisComments[i] = comment;
        }
        this.writer.writeVorbisComments(this.vendor, this.comments, vorbisComments);
    }
}

