/*
 * Decompiled with CFR 0.152.
 */
package com.apple.jingle.leghorn.audio.flac.metadata.blocks;

import com.apple.jingle.leghorn.audio.describe.FlacDescriptionWriter;
import com.apple.jingle.leghorn.audio.flac.FlacValidationService;
import com.apple.jingle.leghorn.audio.flac.StreamInformation;
import com.apple.jingle.leghorn.audio.flac.metadata.Metadata;
import com.apple.jingle.leghorn.audio.helpers.AudioDescriptionException;
import com.apple.jingle.leghorn.audio.provide.Provider;
import com.apple.jingle.leghorn.media.MediaValidationCode;
import java.io.IOException;

class StreamInfo
implements Metadata {
    private static final int MIN_BLOCK_SIZE = 2;
    private static final int MAX_BLOCK_SIZE = 2;
    private static final int MIN_FRAME_SIZE = 3;
    private static final int MAX_FRAME_SIZE = 3;
    private static final int SAMPLE_RATE = 20;
    private static final int CHANNEL_COUNT = 3;
    private static final int BITS_PER_SAMPLE = 5;
    private static final int TOTAL_SAMPLES = 36;
    private static final int MD_5_BYTES = 16;
    private int minBlock;
    private int maxBlock;
    private int minFrame;
    private int maxFrame;
    private int sampleRate;
    private int channels;
    private int bitDepth;
    private long samples;
    private String MD5;
    private FlacValidationService service;
    private FlacDescriptionWriter writer;

    public StreamInfo(FlacValidationService service) {
        this.service = service;
        this.writer = service.getWriter();
    }

    private void init(Provider provider) throws IOException {
        this.minBlock = provider.bigEndianBytesAsInt(2);
        this.maxBlock = provider.bigEndianBytesAsInt(2);
        this.minFrame = provider.bigEndianBytesAsInt(3);
        this.maxFrame = provider.bigEndianBytesAsInt(3);
        this.sampleRate = provider.bitsAsInt(20);
        this.channels = provider.bitsAsInt(3) + 1;
        this.bitDepth = provider.bitsAsInt(5) + 1;
        this.samples = provider.bitsAsLong(36);
        this.MD5 = "";
        for (int i = 0; i < 16; ++i) {
            String nextByteAsHexString = Integer.toHexString(provider.bigEndianBytesAsInt(1));
            if (nextByteAsHexString.length() < 2) {
                nextByteAsHexString = "0" + nextByteAsHexString;
            }
            this.MD5 = this.MD5 + nextByteAsHexString;
        }
    }

    @Override
    public void checkBlock(Provider provider) throws IOException, AudioDescriptionException {
        this.init(provider);
        String blockError = "StreamInfo metadata block shows invalid";
        this.service.errorOn(this.minBlock < 16 || this.minBlock > 65535, "Invalid minimum block size: " + this.minBlock + ". Minimum block size should be between 16 and 65535");
        this.service.errorOn(this.maxBlock < 16 || this.maxBlock > 65535, "Invalid maximum block size: " + this.maxBlock + ". Maximum block size should be between 16 and 65535");
        this.service.errorOn(this.sampleRate == 0, blockError + " sample rate: 0");
        this.service.errorOn(this.channels > 8 || this.channels < 1, blockError + " channel count: " + this.channels + " FLAC suports 1 through 8 channels");
        this.service.errorOn(this.bitDepth < 4 || this.bitDepth > 32, blockError + " bits per sample value: " + this.bitDepth + " FLAC supports 4 through 32  bits per sample");
        this.writeStreamInfo();
        this.writer.writeStreamInfo(this.maxBlock, this.minBlock, this.maxFrame, this.minFrame, this.sampleRate, "samples", "bytes", "Hz", this.channels, this.bitDepth, this.samples, this.MD5);
    }

    private void writeStreamInfo() throws AudioDescriptionException {
        if (this.service.getStreamInfo() != null) {
            throw new AudioDescriptionException("Audio encoding contains multiple stream_info block, please check the audio encoder.", MediaValidationCode.AUD_CONTAINED_MULTIPLE_STREAM_INFO);
        }
        this.service.setStreamInfo(new StreamInformation(this.minBlock, this.maxBlock, this.minFrame, this.maxFrame, this.sampleRate, this.channels, this.bitDepth, this.samples, this.MD5));
    }
}

