/*
 * Decompiled with CFR 0.152.
 */
package com.apple.jingle.leghorn.audio.flac.metadata.blocks;

import com.apple.jingle.leghorn.audio.describe.FlacDescriptionWriter;
import com.apple.jingle.leghorn.audio.flac.metadata.Metadata;
import com.apple.jingle.leghorn.audio.helpers.ValidationService;
import com.apple.jingle.leghorn.audio.provide.Provider;
import java.io.IOException;
import java.util.TreeSet;
import org.apache.log4j.Logger;

public class SeekTable
implements Metadata {
    private static final Logger log = Logger.getLogger(SeekTable.class);
    private static final int LENGTH = 8;
    private static final int SAMPLES_IN_FRAME = 2;
    private int sizeInBytes;
    ValidationService service;
    FlacDescriptionWriter writer;

    public SeekTable(int sizeInBytes, ValidationService service) {
        this.sizeInBytes = sizeInBytes;
        this.service = service;
        this.writer = (FlacDescriptionWriter)service.getWriter();
    }

    @Override
    public void checkBlock(Provider provider) throws IOException {
        log.trace((Object)"Seek Table block: Checking data");
        this.service.errorOn(this.sizeInBytes % 18 != 0, "Invalid Seek Table block length:" + this.sizeInBytes + ". Length in bytes must be a multiple of 18 (18 bytes per seek point)");
        int points = this.sizeInBytes / 18;
        log.trace((Object)("Points in Seek Table: " + points));
        long lastSample = 0L;
        int placeHolders = 0;
        int notInOrder = 0;
        boolean noDuplSampleNums = false;
        boolean misplacedHolders = false;
        long[][] seekPoints = new long[points][3];
        TreeSet<Long> sampleNumbers = new TreeSet<Long>();
        for (int i = 0; i < points; ++i) {
            long sampleNumber = provider.bigEndianBytesAsLong(8);
            long offset = provider.bigEndianBytesAsLong(8);
            int samplesInFrame = provider.bigEndianBytesAsInt(2);
            if (lastSample > sampleNumber) {
                ++notInOrder;
            }
            if (sampleNumber == -1L) {
                ++placeHolders;
            } else {
                misplacedHolders = placeHolders > 0;
                noDuplSampleNums = sampleNumbers.add(sampleNumber);
            }
            lastSample = sampleNumber;
            log.trace((Object)("Seek point " + (i + 1) + " - Sample number: " + sampleNumber + ", Offset: " + offset + ", Samples in frame: " + samplesInFrame));
            seekPoints[i][0] = sampleNumber;
            seekPoints[i][1] = offset;
            seekPoints[i][2] = samplesInFrame;
        }
        this.service.warnOn(notInOrder > 0, "Seek points in a table must be sorted in ascending order by sample number");
        this.service.warnOn(misplacedHolders, "Placeholder points should be at the end of the seek table");
        this.service.warnOn(!noDuplSampleNums, "Seek points (except placeholders) in a table must be unique by sample number");
        this.writer.writeSeekTable(points, seekPoints);
    }
}

