/*
 * Decompiled with CFR 0.152.
 */
package com.apple.jingle.leghorn.audio.flac.metadata.blocks;

import com.apple.jingle.leghorn.audio.describe.FlacDescriptionWriter;
import com.apple.jingle.leghorn.audio.flac.metadata.Metadata;
import com.apple.jingle.leghorn.audio.helpers.ValidationService;
import com.apple.jingle.leghorn.audio.provide.Provider;
import java.io.IOException;
import org.apache.log4j.Logger;

class Picture
implements Metadata {
    private static final Logger log = Logger.getLogger(Picture.class);
    private static final String[] pictureTypes = new String[]{"Other", "32x32 pixels 'file icon' (PNG only", "Other file icon", "Cover (front)", "Cover (back)", "Leaflet page", "Media (e.g. label side of CD)", "Lead artist/lead performer/soloist", "Artist/performer", "Conductor", "Band/Orchestra", "Composer", "Lyricist/text writer', Recording Location", "During recording", "During performance", "Movie/video screen capture", "A bright coloured fish", "Illustration", "Band/artist logotype", "Publisher/Studio logotype"};
    private static final int PICTURE_TYPE = 4;
    private static final int MIME_LENGTH = 4;
    private static final int DESCRIPTION_LENGTH = 4;
    private static final int PICTURE_WIDTH = 4;
    private static final int PICTURE_HEIGHT = 4;
    private static final int NUMBER_OF_COLORS = 4;
    private static final int COLOR_DEPTH = 4;
    private static final int PICTURE_SIZE = 4;
    private ValidationService service;
    private FlacDescriptionWriter writer;

    public Picture(ValidationService service) {
        this.service = service;
        this.writer = (FlacDescriptionWriter)service.getWriter();
    }

    @Override
    public void checkBlock(Provider provider) throws IOException {
        log.trace((Object)"Picture block: Checking data");
        int pictureType = provider.bigEndianBytesAsInt(4);
        try {
            log.trace((Object)("Picture type: " + pictureTypes[pictureType]));
        }
        catch (ArrayIndexOutOfBoundsException e) {
            this.service.errorOn(true, "Invalid picture type. Picture type should be in the range 0-20");
        }
        int mimeLength = provider.bigEndianBytesAsInt(4);
        log.trace((Object)("Skipping MIME type info of length: " + mimeLength));
        provider.skipBytes(mimeLength);
        int descrLength = provider.bigEndianBytesAsInt(4);
        log.trace((Object)("Skipping picture description of length: " + descrLength));
        provider.skipBytes(descrLength);
        int pictureWidth = provider.bigEndianBytesAsInt(4);
        log.trace((Object)("Picture width: " + pictureWidth + " in pixels"));
        int pictureHeight = provider.bigEndianBytesAsInt(4);
        log.trace((Object)("Picture height: " + pictureHeight + " in pixels"));
        int colorDepth = provider.bigEndianBytesAsInt(4);
        log.trace((Object)("color depth of the picture in bits-per-pixel: " + colorDepth));
        int numberOfColors = provider.bigEndianBytesAsInt(4);
        log.trace((Object)("Number of colors used (0 for non-indexed pictures): " + numberOfColors));
        int picSize = provider.bigEndianBytesAsInt(4);
        log.trace((Object)("Piture size in bytes: " + picSize));
        log.trace((Object)"Skipping over picture data");
        provider.skipBytes(picSize);
        this.writer.writePicture(mimeLength, null, descrLength, null, pictureWidth, pictureHeight, colorDepth, numberOfColors, picSize);
    }
}

