/*
 * Decompiled with CFR 0.152.
 */
package com.apple.jingle.leghorn.audio.flac.metadata.blocks;

import com.apple.jingle.leghorn.audio.describe.FlacDescriptionWriter;
import com.apple.jingle.leghorn.audio.flac.metadata.Metadata;
import com.apple.jingle.leghorn.audio.helpers.ValidationService;
import com.apple.jingle.leghorn.audio.provide.Provider;
import java.io.IOException;
import org.apache.log4j.Logger;

class Padding
implements Metadata {
    private static final Logger log = Logger.getLogger(Padding.class);
    private int sizeInBytes;
    private ValidationService service;
    private FlacDescriptionWriter writer;

    public Padding(int sizeInBytes, ValidationService service) {
        this.sizeInBytes = sizeInBytes;
        this.service = service;
        this.writer = (FlacDescriptionWriter)service.getWriter();
    }

    @Override
    public void checkBlock(Provider provider) throws IOException {
        log.trace((Object)"Padding block: skipping");
        provider.skipBytes(this.sizeInBytes);
        this.writer.writePadding(this.sizeInBytes);
        log.trace((Object)("Skipped " + this.sizeInBytes + " bytes"));
    }
}

