/*
 * Decompiled with CFR 0.152.
 */
package com.apple.jingle.leghorn.audio.flac.metadata.blocks;

import com.apple.jingle.leghorn.audio.describe.FlacDescriptionWriter;
import com.apple.jingle.leghorn.audio.flac.metadata.Metadata;
import com.apple.jingle.leghorn.audio.helpers.ValidationService;
import com.apple.jingle.leghorn.audio.provide.Provider;
import java.io.IOException;
import java.util.LinkedHashSet;
import java.util.TreeSet;
import org.apache.log4j.Logger;

class CueSheet
implements Metadata {
    private static final Logger log = Logger.getLogger(CueSheet.class);
    private static final int OFFSET = 8;
    private static final int LEAD_IN_SAMPLES = 8;
    ValidationService service;
    FlacDescriptionWriter writer;
    private static final String PROP_LOG_VERBOSE_ERROR = "com.apple.jingle.leghorn.audio.flac.cuesheet.logVerboseError";

    public CueSheet(ValidationService service) {
        this.service = service;
        this.writer = (FlacDescriptionWriter)service.getWriter();
    }

    @Override
    public void checkBlock(Provider provider) throws IOException {
        log.trace((Object)"Cue sheet block: Checking data");
        String catalogNum = "";
        for (int i = 0; i < 128; ++i) {
            int letter = provider.bigEndianBytesAsInt(1);
            if (letter == 0) continue;
            catalogNum = catalogNum + (char)letter;
        }
        long leadInSamples = provider.bigEndianBytesAsLong(8);
        int cdFlag = provider.bitsAsInt(1);
        this.service.warnOn(cdFlag == 0 && leadInSamples != 0L, "Lead in samples may not be used for non-CD audiodata");
        provider.skipBytes(258);
        provider.skipBits(7);
        int tracks = provider.bigEndianBytesAsInt(1);
        this.service.warnOn(tracks < 1, "Number of tracks should be at least one");
        this.service.warnOn(cdFlag == 1 && tracks > 100, "CD-DA cannot have more than 100 tracks (99 + 1 leadout track");
        TreeSet<Integer> trackNumbers = new TreeSet<Integer>();
        boolean trackReservedBlockHasNonZeroBit = false;
        boolean indexPointReservedBlockHasNonZeroBit = false;
        boolean hasTrackNumberZero = false;
        boolean isCDTrackOffetWrong = false;
        boolean isCDTrackNumberWrong = false;
        boolean isNonCDLastTrackNumberWrong = false;
        boolean leadOutTrackHasIndexPoints = false;
        boolean nonLeadOutTrackHasZeroIndexPoints = false;
        boolean firstIndexPointIsNotZeroOrOne = false;
        boolean indexPointDoesNotIncreaseByOne = false;
        boolean hasDuplicateIndexPoint = false;
        boolean hasDuplicateTrackNumber = false;
        LinkedHashSet<Integer> tracksWithNonZeroBitInReservedBlock = new LinkedHashSet<Integer>();
        LinkedHashSet<Integer> tracksIndexPointsWithNonZeroBitInReservedBlock = new LinkedHashSet<Integer>();
        for (int i = 0; i < tracks; ++i) {
            int trackNumber;
            long offSet = provider.bigEndianBytesAsLong(8);
            if (cdFlag == 1 && offSet % 588L != 0L) {
                isCDTrackOffetWrong = true;
            }
            if ((trackNumber = provider.bigEndianBytesAsInt(1)) == 0) {
                hasTrackNumberZero = true;
            }
            if (!trackNumbers.add(trackNumber)) {
                hasDuplicateTrackNumber = true;
            }
            if (cdFlag == 1) {
                if (trackNumber > 99 && (trackNumber != 170 || i != tracks - 1)) {
                    isCDTrackNumberWrong = true;
                }
            } else if (i == tracks - 1 && trackNumber != 255) {
                isNonCDLastTrackNumberWrong = true;
            }
            provider.skipBytes(12);
            provider.skipBits(2);
            boolean thisTrackReservedBlockHasNonZeroBit = false;
            for (int j = 0; j < 110; ++j) {
                if (provider.bitsAsInt(1) != 1) continue;
                trackReservedBlockHasNonZeroBit = true;
                thisTrackReservedBlockHasNonZeroBit = true;
            }
            if (thisTrackReservedBlockHasNonZeroBit) {
                tracksWithNonZeroBitInReservedBlock.add(trackNumber);
            }
            int indexPoints = provider.bigEndianBytesAsInt(1);
            if ((trackNumber == 170 || trackNumber == 255) && indexPoints != 0) {
                leadOutTrackHasIndexPoints = true;
            }
            if ((trackNumber != 170 || trackNumber != 255) && indexPoints == 0) {
                nonLeadOutTrackHasZeroIndexPoints = true;
            }
            TreeSet<Integer> pointNumbers = new TreeSet<Integer>();
            int lastPoint = 0;
            boolean trackIndexPointReservedBlockHasNonZeroBit = false;
            for (int j = 0; j < indexPoints; ++j) {
                long offset = provider.bigEndianBytesAsLong(8);
                int pointNumber = provider.bigEndianBytesAsInt(1);
                if (!pointNumbers.add(pointNumber)) {
                    hasDuplicateIndexPoint = true;
                }
                if (j == 0 && pointNumber != 0 && pointNumber != 1) {
                    firstIndexPointIsNotZeroOrOne = true;
                }
                if (j > 0 && pointNumber - lastPoint != 1) {
                    indexPointDoesNotIncreaseByOne = true;
                }
                for (int k = 0; k < 24; ++k) {
                    if (provider.bitsAsInt(1) != 1) continue;
                    indexPointReservedBlockHasNonZeroBit = true;
                    trackIndexPointReservedBlockHasNonZeroBit = true;
                }
                log.trace((Object)("\tIndex point " + j + " - Offset: " + offset + " Point number: " + pointNumber));
                lastPoint = pointNumber;
            }
            if (!trackIndexPointReservedBlockHasNonZeroBit) continue;
            tracksIndexPointsWithNonZeroBitInReservedBlock.add(trackNumber);
        }
        boolean logVerboseError = Boolean.valueOf(System.getProperty(PROP_LOG_VERBOSE_ERROR, "false"));
        if (trackReservedBlockHasNonZeroBit) {
            String message = "Track has non-zero bit in reserved block.";
            if (logVerboseError) {
                message = message + " In Track number(s): " + ((Object)tracksWithNonZeroBitInReservedBlock).toString();
            }
            this.service.addError(message);
        }
        if (indexPointReservedBlockHasNonZeroBit) {
            String message = "Track index has non-zero bit in reserved block.";
            if (logVerboseError) {
                message = message + " In Track number(s): " + ((Object)tracksIndexPointsWithNonZeroBitInReservedBlock).toString();
            }
            this.service.addError(message);
        }
        if (isCDTrackOffetWrong) {
            this.service.addWarning("For CD audio, track offset must be a multiple of 588 (44100 samples/sec * 1/75th of a sec)");
        }
        if (hasTrackNumberZero) {
            this.service.addWarning("Track number 0 is not allowed");
        }
        if (isCDTrackNumberWrong) {
            this.service.addWarning("For CD audio, track numbers which are not leadout tracks must be between 1-99");
        }
        if (isNonCDLastTrackNumberWrong) {
            this.service.addWarning("For non-CD audio, last track in cuesheet must have track number 255");
        }
        if (leadOutTrackHasIndexPoints) {
            this.service.addWarning("Lead out track must have 0 index points");
        }
        if (nonLeadOutTrackHasZeroIndexPoints) {
            this.service.addWarning("Tracks other than the lead out track cannot have 0 index points");
        }
        if (hasDuplicateTrackNumber) {
            this.service.addWarning("Duplicate track numbers are not allowed");
        }
        if (hasDuplicateIndexPoint) {
            this.service.addWarning("Duplicate index points in a track are not allowed");
        }
        if (firstIndexPointIsNotZeroOrOne) {
            this.service.addWarning("First index point in a track must have index of either 0 or 1");
        }
        if (indexPointDoesNotIncreaseByOne) {
            this.service.addWarning("Index points in track must increase by 1");
        }
        this.writer.writeCueSheet(catalogNum, leadInSamples, cdFlag, tracks, 0);
    }
}

